/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.Set;
import javax.transaction.Transaction;
import javax.wsdl.Operation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.BpelInstanceWorker;
import org.apache.ode.bpel.engine.BpelRuntimeContextImpl;
import org.apache.ode.bpel.engine.MexDaoUtil;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.PartnerLinkRoleImpl;
import org.apache.ode.bpel.engine.PartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.ReliablePartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.TransactedPartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.UnreliablePartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PartnerLinkPartnerRoleImpl
extends PartnerLinkRoleImpl {
    static final Log __log = LogFactory.getLog(PartnerLinkPartnerRoleImpl.class);
    Endpoint _initialPartner;
    public PartnerRoleChannel _channel;

    PartnerLinkPartnerRoleImpl(ODEProcess oDEProcess, PartnerLinkModel partnerLinkModel, Endpoint endpoint) {
        super(oDEProcess, partnerLinkModel);
        this._initialPartner = endpoint;
    }

    PartnerRoleMessageExchangeImpl createPartnerRoleMex(MessageExchangeDAO messageExchangeDAO) {
        PartnerRoleMessageExchangeImpl partnerRoleMessageExchangeImpl;
        InvocationStyle invocationStyle = messageExchangeDAO.getInvocationStyle();
        Operation operation = this._plinkDef.getPartnerRoleOperation(messageExchangeDAO.getOperation());
        EndpointReference endpointReference = this._plinkDef.hasMyRole() ? this._process.getInitialMyRoleEPR(this._plinkDef) : null;
        switch (invocationStyle) {
            case UNRELIABLE: {
                partnerRoleMessageExchangeImpl = new UnreliablePartnerRoleMessageExchangeImpl(this._process, (long)messageExchangeDAO.getInstance().getInstanceId(), messageExchangeDAO.getMessageExchangeId(), this._plinkDef, operation, null, endpointReference, this._channel);
                break;
            }
            case TRANSACTED: {
                partnerRoleMessageExchangeImpl = new TransactedPartnerRoleMessageExchangeImpl(this._process, (long)messageExchangeDAO.getInstance().getInstanceId(), messageExchangeDAO.getMessageExchangeId(), this._plinkDef, operation, null, endpointReference, this._channel);
                break;
            }
            case RELIABLE: {
                partnerRoleMessageExchangeImpl = new ReliablePartnerRoleMessageExchangeImpl(this._process, (long)messageExchangeDAO.getInstance().getInstanceId(), messageExchangeDAO.getMessageExchangeId(), this._plinkDef, operation, null, endpointReference, this._channel);
                break;
            }
            default: {
                throw new BpelEngineException("Unexpected InvocationStyle: " + invocationStyle);
            }
        }
        partnerRoleMessageExchangeImpl.load(messageExchangeDAO);
        return partnerRoleMessageExchangeImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeIL(MessageExchangeDAO messageExchangeDAO) {
        Element element = messageExchangeDAO.getEPR();
        EndpointReference endpointReference = this._initialEPR;
        if (element != null) {
            if (this._contexts.eprContext != null) {
                endpointReference = this._contexts.eprContext.resolveEndpointReference(element);
            } else {
                __log.debug((Object)"Partner EPR will not be resolved, no EPR context specified!");
            }
        }
        EndpointReference endpointReference2 = null;
        if (this._plinkDef.hasMyRole()) {
            endpointReference2 = this._process.getInitialMyRoleEPR(this._plinkDef);
        }
        this._process.setStatefulEPRs(messageExchangeDAO);
        Operation operation = this._plinkDef.getPartnerRoleOperation(messageExchangeDAO.getOperation());
        Set set = this._contexts.mexContext.getSupportedInvocationStyle(this._channel, endpointReference);
        boolean bl = messageExchangeDAO.getPattern() == MessageExchange.MessageExchangePattern.REQUEST_ONLY;
        try {
            if (this._process.isInMemory()) {
                this.invokeInMem(messageExchangeDAO, endpointReference, endpointReference2, operation, set, bl);
            } else {
                this.invokePersisted(messageExchangeDAO, endpointReference, endpointReference2, operation, set);
            }
        }
        finally {
            if (messageExchangeDAO.getStatus() != MessageExchange.Status.ACK) {
                messageExchangeDAO.setStatus(MessageExchange.Status.ASYNC);
            }
        }
    }

    private void invokePersisted(MessageExchangeDAO messageExchangeDAO, EndpointReference endpointReference, EndpointReference endpointReference2, Operation operation, Set<InvocationStyle> set) {
        boolean bl = Boolean.parseBoolean(messageExchangeDAO.getProperty("org.apache.ode.bpel.myRoleTransacted"));
        if (set.contains(InvocationStyle.TRANSACTED) && bl) {
            messageExchangeDAO.setInvocationStyle(InvocationStyle.TRANSACTED);
            this.invokeTransacted(messageExchangeDAO, endpointReference, endpointReference2, operation);
        } else if (set.contains(InvocationStyle.RELIABLE)) {
            messageExchangeDAO.setInvocationStyle(InvocationStyle.RELIABLE);
            this.invokeReliable(messageExchangeDAO, endpointReference, endpointReference2, operation);
        } else if (set.contains(InvocationStyle.UNRELIABLE)) {
            messageExchangeDAO.setInvocationStyle(InvocationStyle.UNRELIABLE);
            this.invokeUnreliable(messageExchangeDAO, endpointReference, endpointReference2, operation);
        } else {
            __log.error((Object)("Integration Layer did not agree to any known invocation style for EPR " + endpointReference));
            messageExchangeDAO.setFailureType(MessageExchange.FailureType.COMMUNICATION_ERROR);
            messageExchangeDAO.setStatus(MessageExchange.Status.ACK);
            messageExchangeDAO.setAckType(MessageExchange.AckType.FAILURE);
            messageExchangeDAO.setFaultExplanation("NoMatchingStyle");
        }
    }

    private void invokeUnreliable(MessageExchangeDAO messageExchangeDAO, EndpointReference endpointReference, EndpointReference endpointReference2, Operation operation) {
        UnreliablePartnerRoleMessageExchangeImpl unreliablePartnerRoleMessageExchangeImpl = new UnreliablePartnerRoleMessageExchangeImpl(this._process, (long)messageExchangeDAO.getInstance().getInstanceId(), messageExchangeDAO.getMessageExchangeId(), this._plinkDef, operation, endpointReference, endpointReference2, this._channel);
        unreliablePartnerRoleMessageExchangeImpl.setState(PartnerRoleMessageExchangeImpl.State.INVOKE_XXX);
        unreliablePartnerRoleMessageExchangeImpl.request();
        this._process.scheduleRunnable(new UnreliableInvoker(unreliablePartnerRoleMessageExchangeImpl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeInMem(MessageExchangeDAO messageExchangeDAO, EndpointReference endpointReference, EndpointReference endpointReference2, Operation operation, Set<InvocationStyle> set, boolean bl) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("invokeInMem: mexid=" + messageExchangeDAO.getMessageExchangeId() + " operation=" + messageExchangeDAO.getOperation() + " oneway=" + bl));
        }
        if (set.contains(InvocationStyle.TRANSACTED)) {
            this.invokeTransacted(messageExchangeDAO, endpointReference, endpointReference2, operation);
        } else if (set.contains(InvocationStyle.RELIABLE) && bl) {
            this.invokeReliable(messageExchangeDAO, endpointReference, endpointReference2, operation);
        } else if (set.contains(InvocationStyle.UNRELIABLE)) {
            Transaction transaction;
            UnreliablePartnerRoleMessageExchangeImpl unreliablePartnerRoleMessageExchangeImpl = new UnreliablePartnerRoleMessageExchangeImpl(this._process, (long)messageExchangeDAO.getInstance().getInstanceId(), messageExchangeDAO.getMessageExchangeId(), this._plinkDef, operation, endpointReference, endpointReference2, this._channel);
            try {
                transaction = this._contexts.txManager.suspend();
                __log.debug((Object)("TX " + transaction + " suspended for in-memory invoke. "));
            }
            catch (Exception exception) {
                throw new BpelEngineException("TxManager Error: cannot suspend!", (Throwable)exception);
            }
            unreliablePartnerRoleMessageExchangeImpl.request();
            unreliablePartnerRoleMessageExchangeImpl.setState(PartnerRoleMessageExchangeImpl.State.INVOKE_XXX);
            try {
                try {
                    this._contexts.mexContext.invokePartnerUnreliable((PartnerRoleMessageExchange)unreliablePartnerRoleMessageExchangeImpl);
                }
                catch (Throwable throwable) {
                    __log.error((Object)"Unexpected error invoking partner.", throwable);
                    MexDaoUtil.setFailed(messageExchangeDAO, MessageExchange.FailureType.OTHER, throwable.toString());
                    unreliablePartnerRoleMessageExchangeImpl.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
                    try {
                        this._contexts.txManager.resume(transaction);
                        __log.debug((Object)("TX " + transaction + " resumed for in-memory invoke. "));
                    }
                    catch (Exception exception) {
                        throw new BpelEngineException("TxManager Error: cannot resume!", (Throwable)exception);
                    }
                    return;
                }
                try {
                    unreliablePartnerRoleMessageExchangeImpl.waitForAck(messageExchangeDAO.getTimeout());
                }
                catch (InterruptedException interruptedException) {
                    __log.warn((Object)"Interrupted waiting for MEX response.");
                }
            }
            finally {
                unreliablePartnerRoleMessageExchangeImpl.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
                try {
                    this._contexts.txManager.resume(transaction);
                    __log.debug((Object)("TX " + transaction + " resumed for in-memory invoke. "));
                }
                catch (Exception exception) {
                    throw new BpelEngineException("TxManager Error: cannot resume!", (Throwable)exception);
                }
            }
            if (unreliablePartnerRoleMessageExchangeImpl.getStatus() != MessageExchange.Status.ACK) {
                MexDaoUtil.setFailed(messageExchangeDAO, MessageExchange.FailureType.NO_RESPONSE, "No Response");
            } else {
                unreliablePartnerRoleMessageExchangeImpl.save(messageExchangeDAO);
            }
        } else {
            MexDaoUtil.setFailed(messageExchangeDAO, MessageExchange.FailureType.OTHER, "Unsupported invocation style for in-mem process.");
        }
    }

    private void invokeReliable(MessageExchangeDAO messageExchangeDAO, EndpointReference endpointReference, EndpointReference endpointReference2, Operation operation) {
        ReliablePartnerRoleMessageExchangeImpl reliablePartnerRoleMessageExchangeImpl = new ReliablePartnerRoleMessageExchangeImpl(this._process, (long)messageExchangeDAO.getInstance().getInstanceId(), messageExchangeDAO.getMessageExchangeId(), this._plinkDef, operation, endpointReference, endpointReference2, this._channel);
        reliablePartnerRoleMessageExchangeImpl.request();
        reliablePartnerRoleMessageExchangeImpl.setState(PartnerRoleMessageExchangeImpl.State.INVOKE_XXX);
        Throwable throwable = null;
        try {
            this._contexts.mexContext.invokePartnerReliable((PartnerRoleMessageExchange)reliablePartnerRoleMessageExchangeImpl);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        reliablePartnerRoleMessageExchangeImpl.setState(PartnerRoleMessageExchangeImpl.State.HOLD);
        if (throwable != null) {
            MexDaoUtil.setFailed(messageExchangeDAO, MessageExchange.FailureType.COMMUNICATION_ERROR, throwable.toString());
            reliablePartnerRoleMessageExchangeImpl.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
        } else if (reliablePartnerRoleMessageExchangeImpl.getStatus() == MessageExchange.Status.ACK) {
            reliablePartnerRoleMessageExchangeImpl.save(messageExchangeDAO);
            reliablePartnerRoleMessageExchangeImpl.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
        } else {
            reliablePartnerRoleMessageExchangeImpl.setState(PartnerRoleMessageExchangeImpl.State.ASYNC);
        }
    }

    private void invokeTransacted(MessageExchangeDAO messageExchangeDAO, EndpointReference endpointReference, EndpointReference endpointReference2, Operation operation) {
        TransactedPartnerRoleMessageExchangeImpl transactedPartnerRoleMessageExchangeImpl = new TransactedPartnerRoleMessageExchangeImpl(this._process, (long)messageExchangeDAO.getInstance().getInstanceId(), messageExchangeDAO.getMessageExchangeId(), this._plinkDef, operation, endpointReference, endpointReference2, this._channel);
        transactedPartnerRoleMessageExchangeImpl.request();
        transactedPartnerRoleMessageExchangeImpl.setState(PartnerRoleMessageExchangeImpl.State.INVOKE_XXX);
        try {
            this._contexts.mexContext.invokePartnerTransacted((PartnerRoleMessageExchange)transactedPartnerRoleMessageExchangeImpl);
        }
        catch (Throwable throwable) {
            __log.error((Object)"Transacted partner invoke threw an exception; rolling back.");
            try {
                this._contexts.txManager.setRollbackOnly();
            }
            catch (Exception exception) {
                __log.fatal((Object)"TransactionManager error, could not setRollbackOnly()", (Throwable)exception);
            }
            throw new BpelEngineException("Rollback required.", throwable);
        }
        finally {
            transactedPartnerRoleMessageExchangeImpl.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
        }
        if (transactedPartnerRoleMessageExchangeImpl.getStatus() != MessageExchange.Status.ACK) {
            MexDaoUtil.setFailed(messageExchangeDAO, MessageExchange.FailureType.NO_RESPONSE, "Integration Layer did not provide required ACK.");
        } else {
            transactedPartnerRoleMessageExchangeImpl.save(messageExchangeDAO);
        }
    }

    class UnreliableInvoker
    implements Runnable {
        UnreliablePartnerRoleMessageExchangeImpl _unreliableMex;
        BpelInstanceWorker _iworker;
        BpelRuntimeContextImpl _lastBRC;

        public UnreliableInvoker(UnreliablePartnerRoleMessageExchangeImpl unreliablePartnerRoleMessageExchangeImpl) {
            this._unreliableMex = unreliablePartnerRoleMessageExchangeImpl;
        }

        public void run() {
            assert (!PartnerLinkPartnerRoleImpl.this._contexts.isTransacted());
            Throwable throwable = null;
            this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.INVOKE_XXX);
            try {
                PartnerLinkPartnerRoleImpl.this._contexts.mexContext.invokePartnerUnreliable((PartnerRoleMessageExchange)this._unreliableMex);
                this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.HOLD);
            }
            catch (Throwable throwable2) {
                this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
                throwable = throwable2;
            }
            final Throwable throwable3 = throwable;
            if (this._unreliableMex._operation.getOutput() == null) {
                this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
                return;
            }
            if (throwable3 != null) {
                PartnerLinkPartnerRoleImpl.this._process.enqueueInstanceTransaction(this._unreliableMex.getIID(), new Runnable(){

                    public void run() {
                        MessageExchangeDAO messageExchangeDAO = PartnerLinkPartnerRoleImpl.this._process.loadMexDao(UnreliableInvoker.this._unreliableMex.getMessageExchangeId());
                        MexDaoUtil.setFailed(messageExchangeDAO, MessageExchange.FailureType.OTHER, throwable3.toString());
                        UnreliableInvoker.this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
                    }
                });
                return;
            }
            PartnerLinkPartnerRoleImpl.this._process.enqueueInstanceTransaction(this._unreliableMex.getIID(), new Runnable(){

                public void run() {
                    MessageExchangeDAO messageExchangeDAO = PartnerLinkPartnerRoleImpl.this._process.loadMexDao(UnreliableInvoker.this._unreliableMex.getMessageExchangeId());
                    if (UnreliableInvoker.this._unreliableMex.getStatus() == MessageExchange.Status.ACK) {
                        UnreliableInvoker.this._unreliableMex.save(messageExchangeDAO);
                        UnreliableInvoker.this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
                    } else if (UnreliableInvoker.this._unreliableMex.getStatus() == MessageExchange.Status.REQ && !UnreliableInvoker.this._unreliableMex._asyncReply) {
                        MexDaoUtil.setFailed(messageExchangeDAO, MessageExchange.FailureType.NO_RESPONSE, "No Response");
                        UnreliableInvoker.this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.DEAD);
                    } else {
                        if (UnreliableInvoker.this._unreliableMex._asyncReply) {
                            UnreliableInvoker.this._unreliableMex.setState(PartnerRoleMessageExchangeImpl.State.ASYNC);
                            return;
                        }
                        __log.fatal((Object)"InternalError: Unexpected message exchange state!");
                        MexDaoUtil.setFailed(messageExchangeDAO, MessageExchange.FailureType.OTHER, "Unexpected message exchange state");
                    }
                    PartnerLinkPartnerRoleImpl.this._process.executeContinueInstancePartnerRoleResponseReceived(messageExchangeDAO);
                }
            });
        }
    }
}

