/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.evtproc;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.ode.bpel.evt.ActivityDisabledEvent;
import org.apache.ode.bpel.evt.ActivityEnabledEvent;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.ActivityExecEndEvent;
import org.apache.ode.bpel.evt.ActivityExecStartEvent;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.pmapi.ActivityInfoDocument;
import org.apache.ode.bpel.pmapi.TActivityInfo;
import org.apache.ode.bpel.pmapi.TActivityStatus;
import org.apache.ode.bpel.pmapi.TScopeRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityStateDocumentBuilder
implements BpelEventListener {
    private HashMap<Long, ActivityInfoDocument> _activities = new HashMap();
    private ArrayList<ActivityInfoDocument> _activitiesOrdered = new ArrayList();
    private boolean _removeCompleted = false;
    private Long _scope;

    public List<ActivityInfoDocument> getActivities() {
        return this._activitiesOrdered;
    }

    public boolean isRemoveCompleted() {
        return this._removeCompleted;
    }

    public void setRemoveCompleted(boolean bl) {
        this._removeCompleted = bl;
    }

    public Long getScope() {
        return this._scope;
    }

    public void setScope(Long l) {
        this._scope = l;
    }

    public void onEvent(BpelEvent bpelEvent) {
        if (bpelEvent instanceof ActivityEvent) {
            Calendar calendar;
            ActivityEvent activityEvent = (ActivityEvent)bpelEvent;
            ActivityInfoDocument activityInfoDocument = this.lookup(activityEvent);
            assert (activityInfoDocument != null);
            if (activityEvent instanceof ActivityEnabledEvent) {
                activityInfoDocument.getActivityInfo().setStatus(TActivityStatus.ENABLED);
                calendar = Calendar.getInstance();
                calendar.setTime(activityEvent.getTimestamp());
                activityInfoDocument.getActivityInfo().setDtEnabled(calendar);
                this._activities.put(activityEvent.getActivityId(), activityInfoDocument);
            }
            if (activityEvent instanceof ActivityDisabledEvent) {
                activityInfoDocument.getActivityInfo().setStatus(TActivityStatus.DEAD);
                calendar = Calendar.getInstance();
                calendar.setTime(activityEvent.getTimestamp());
                activityInfoDocument.getActivityInfo().setDtDied(calendar);
            }
            if (activityEvent instanceof ActivityExecStartEvent) {
                activityInfoDocument.getActivityInfo().setStatus(TActivityStatus.STARTED);
                calendar = Calendar.getInstance();
                calendar.setTime(activityEvent.getTimestamp());
                activityInfoDocument.getActivityInfo().setDtStarted(calendar);
            } else if (activityEvent instanceof ActivityExecEndEvent) {
                activityInfoDocument.getActivityInfo().setStatus(TActivityStatus.COMPLETED);
                calendar = Calendar.getInstance();
                calendar.setTime(activityEvent.getTimestamp());
                activityInfoDocument.getActivityInfo().setDtCompleted(calendar);
                this.completed(activityInfoDocument);
            }
        }
    }

    private void completed(ActivityInfoDocument activityInfoDocument) {
        if (this._removeCompleted) {
            this._activitiesOrdered.remove(activityInfoDocument);
            this._activities.values().remove(activityInfoDocument);
        }
    }

    private ActivityInfoDocument lookup(ActivityEvent activityEvent) {
        ActivityInfoDocument activityInfoDocument = this._activities.get(activityEvent.getActivityId());
        if (activityInfoDocument == null) {
            activityInfoDocument = ActivityInfoDocument.Factory.newInstance();
            this.fill(activityInfoDocument.addNewActivityInfo(), activityEvent);
            activityInfoDocument.getActivityInfo().setStatus(TActivityStatus.ENABLED);
            this._activities.put(activityEvent.getActivityId(), activityInfoDocument);
            this._activitiesOrdered.add(activityInfoDocument);
        }
        return activityInfoDocument;
    }

    private void fill(TActivityInfo tActivityInfo, ActivityEvent activityEvent) {
        tActivityInfo.setName(activityEvent.getActivityName());
        tActivityInfo.setType(activityEvent.getActivityType());
        tActivityInfo.setAiid("" + activityEvent.getActivityId());
        tActivityInfo.setScope(TScopeRef.Factory.newInstance());
        tActivityInfo.getScope().setModelId("" + activityEvent.getScopeDeclarationId());
        tActivityInfo.getScope().setName(activityEvent.getScopeName());
        tActivityInfo.getScope().setSiid("" + activityEvent.getScopeId());
    }

    public void shutdown() {
    }

    public void startup(Properties properties) {
    }
}

