/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.restlet.data.Parameter;
import org.restlet.engine.security.SslContextFactory;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSslContextFactory
extends SslContextFactory {
    private volatile String keyManagerAlgorithm = System.getProperty("ssl.KeyManagerFactory.algorithm", KeyManagerFactory.getDefaultAlgorithm());
    private volatile char[] keyStoreKeyPassword = System.getProperty("javax.net.ssl.keyPassword", System.getProperty("javax.net.ssl.keyStorePassword")) != null ? System.getProperty("javax.net.ssl.keyPassword", System.getProperty("javax.net.ssl.keyStorePassword")).toCharArray() : null;
    private volatile char[] keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword") != null ? System.getProperty("javax.net.ssl.keyStorePassword").toCharArray() : null;
    private volatile String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
    private volatile String keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider");
    private volatile String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
    private volatile String secureRandomAlgorithm = null;
    private volatile String secureSocketProtocol = "TLS";
    private volatile String trustManagerAlgorithm = System.getProperty("ssl.TrustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm());
    private volatile char[] trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword") != null ? System.getProperty("javax.net.ssl.trustStorePassword").toCharArray() : null;
    private volatile String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
    private volatile String trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
    private volatile String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType");

    protected final DefaultSslContextFactory clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SSLContext createSslContext() throws Exception {
        KeyManagerFactory kmf = null;
        if (this.keyStorePath != null || this.keyStoreProvider != null || this.keyStoreType != null) {
            KeyStore keyStore;
            block9: {
                keyStore = this.keyStoreProvider != null ? KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType(), this.keyStoreProvider) : KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType());
                FileInputStream keyStoreInputStream = null;
                try {
                    keyStoreInputStream = this.keyStorePath != null && !"NONE".equals(this.keyStorePath) ? new FileInputStream(this.keyStorePath) : null;
                    keyStore.load(keyStoreInputStream, this.keyStorePassword);
                    Object var5_4 = null;
                    if (keyStoreInputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (keyStoreInputStream != null) {
                        keyStoreInputStream.close();
                    }
                    throw throwable;
                }
                keyStoreInputStream.close();
            }
            kmf = KeyManagerFactory.getInstance(this.keyManagerAlgorithm);
            kmf.init(keyStore, this.keyStoreKeyPassword);
        }
        TrustManagerFactory tmf = null;
        if (this.trustStorePath != null || this.trustStoreProvider != null || this.trustStoreType != null) {
            KeyStore trustStore;
            block10: {
                trustStore = this.trustStoreProvider != null ? KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType(), this.trustStoreProvider) : KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType());
                FileInputStream trustStoreInputStream = null;
                try {
                    trustStoreInputStream = this.trustStorePath != null && !"NONE".equals(this.trustStorePath) ? new FileInputStream(this.trustStorePath) : null;
                    trustStore.load(trustStoreInputStream, this.trustStorePassword);
                    Object var7_8 = null;
                    if (trustStoreInputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (trustStoreInputStream != null) {
                        trustStoreInputStream.close();
                    }
                    throw throwable;
                }
                trustStoreInputStream.close();
            }
            tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
            tmf.init(trustStore);
        }
        SSLContext sslContext = SSLContext.getInstance(this.secureSocketProtocol);
        SecureRandom sr = null;
        if (this.secureRandomAlgorithm != null) {
            sr = SecureRandom.getInstance(this.secureRandomAlgorithm);
        }
        sslContext.init(kmf != null ? kmf.getKeyManagers() : null, tmf != null ? tmf.getTrustManagers() : null, sr);
        return sslContext;
    }

    public String getSecureSocketProtocol() {
        return this.secureSocketProtocol;
    }

    @Override
    public void init(Series<Parameter> helperParameters) {
        this.setKeyStorePath(helperParameters.getFirstValue("keystorePath", System.getProperty("javax.net.ssl.keyStore")));
        this.setKeyStorePassword(helperParameters.getFirstValue("keystorePassword", System.getProperty("javax.net.ssl.keyStorePassword", "")));
        this.setKeyStoreType(helperParameters.getFirstValue("keystoreType", System.getProperty("javax.net.ssl.keyStoreType")));
        this.setKeyStoreKeyPassword(helperParameters.getFirstValue("keyPassword", System.getProperty("javax.net.ssl.keyPassword")));
        if (this.keyStoreKeyPassword == null) {
            this.keyStoreKeyPassword = this.keyStorePassword;
        }
        this.setTrustStorePath(helperParameters.getFirstValue("truststorePath", System.getProperty("javax.net.ssl.trustStore")));
        this.setTrustStorePassword(helperParameters.getFirstValue("truststorePassword", System.getProperty("javax.net.ssl.trustStorePassword")));
        this.setTrustStoreType(helperParameters.getFirstValue("truststoreType", System.getProperty("javax.net.ssl.trustStoreType")));
        this.setKeyManagerAlgorithm(helperParameters.getFirstValue("certAlgorithm", "SunX509"));
        this.setSecureSocketProtocol(helperParameters.getFirstValue("sslProtocol", "TLS"));
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.keyManagerAlgorithm = keyManagerAlgorithm;
    }

    public final void setKeyStoreKeyPassword(char[] keyStoreKeyPassword) {
        this.keyStoreKeyPassword = keyStoreKeyPassword;
    }

    public final void setKeyStoreKeyPassword(String keyStoreKeyPassword) {
        this.keyStoreKeyPassword = keyStoreKeyPassword != null ? keyStoreKeyPassword.toCharArray() : null;
    }

    public final void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public final void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword != null ? keyStorePassword.toCharArray() : null;
    }

    public final void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public final void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public void setSecureSocketProtocol(String secureSocketProtocol) {
        this.secureSocketProtocol = secureSocketProtocol;
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.trustManagerAlgorithm = trustManagerAlgorithm;
    }

    public final void setTrustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public final void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword != null ? trustStorePassword.toCharArray() : null;
    }

    public final void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    public final void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    public final void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }
}

