/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.tika.internal;

import java.io.Writer;
import org.apache.tika.sax.ToTextContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PageBreakWriteOutContentHandler
extends WriteOutContentHandler {
    public static final String PAGE_START_TAG = "<page>";
    public static final String PAGE_END_TAG = "</page>";
    private static final char[] PAGE_START_TAG_CHARS = "<page>".toCharArray();
    private static final char[] PAGE_END_TAG_CHARS = "</page>".toCharArray();

    public PageBreakWriteOutContentHandler(ContentHandler handler, int writeLimit) {
        super(handler, writeLimit);
    }

    public PageBreakWriteOutContentHandler(Writer writer, int writeLimit) {
        this((ContentHandler)new ToTextContentHandler(writer), writeLimit);
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        try {
            if ("div".equals(name) && atts != null && "page".equals(atts.getValue("class"))) {
                super.characters(PAGE_START_TAG_CHARS, 0, PAGE_START_TAG_CHARS.length);
            }
            super.startElement(uri, localName, name, atts);
        }
        catch (SAXException e) {
            this.handleException(e);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            super.endElement(uri, localName, name);
            if ("div".equals(name)) {
                super.characters(PAGE_END_TAG_CHARS, 0, PAGE_END_TAG_CHARS.length);
            }
        }
        catch (SAXException e) {
            this.handleException(e);
        }
    }
}

