/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.common.definitions;

import java.util.Date;
import org.eclipse.smila.common.definitions.AccessAny;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;

public class DefinitionBase {
    public static final String KEY_TIMESTAMP = "timestamp";
    public static final String KEY_NAME = "name";
    public static final String KEY_READ_ONLY = "readOnly";
    protected final String _name;
    protected final AnyMap _definitionMap;
    protected final Date _timestamp;
    protected final boolean _readOnly;

    public DefinitionBase(AnyMap definitionMap) throws InvalidDefinitionException {
        this._definitionMap = AccessAny.cloneAnyMap(definitionMap);
        this._name = this.validateName() ? AccessAny.getValidName(this._definitionMap, KEY_NAME) : AccessAny.getStringRequired(this._definitionMap, KEY_NAME);
        this._timestamp = this._definitionMap.getDateTimeValue(KEY_TIMESTAMP);
        this._readOnly = definitionMap.containsKey((Object)KEY_READ_ONLY) ? this._definitionMap.getBooleanValue(KEY_READ_ONLY) : false;
    }

    protected DefinitionBase(String name) {
        this._name = name;
        this._timestamp = new Date();
        this._readOnly = false;
        this._definitionMap = null;
    }

    protected boolean validateName() {
        return true;
    }

    public String getName() {
        return this._name;
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public AnyMap toAny() {
        return this.toAny(true);
    }

    public String toString() {
        return this.toAny().toString();
    }

    public AnyMap toAny(boolean includingAdditionalAttributes) {
        if (includingAdditionalAttributes) {
            return AccessAny.cloneAnyMap(this._definitionMap);
        }
        try {
            AnyMap baseAny = DataFactory.DEFAULT.createAnyMap();
            baseAny.put(KEY_NAME, this._name);
            if (this._timestamp != null) {
                baseAny.put(KEY_TIMESTAMP, (Any)DataFactory.DEFAULT.createDateTimeValue(this._timestamp));
            }
            if (this._readOnly) {
                baseAny.put(KEY_READ_ONLY, Boolean.valueOf(this._readOnly));
            }
            return baseAny;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create Any object for workflow " + this._name, ex);
        }
    }
}

