/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.filter;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.validation.Schema;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.filter.RecordFilterLoadSaveException;
import org.eclipse.smila.datamodel.filter.RecordFilterNotFoundException;
import org.eclipse.smila.datamodel.filter.messages.Element;
import org.eclipse.smila.datamodel.filter.messages.Filter;
import org.eclipse.smila.datamodel.filter.messages.RecordFilters;
import org.eclipse.smila.utils.jaxb.JaxbUtils;
import org.eclipse.smila.utils.xml.SchemaUtils;
import org.xml.sax.SAXException;

public final class RecordFilterUtils {
    private static final String MASK_ANY = "*";
    private static final String BUNDLE_ID = "org.eclipse.smila.datamodel";
    private static final String JAXB_PACKAGE = "org.eclipse.smila.datamodel.filter.messages";
    private static final String SCHEMA_LOCATION = "schemas/RecordFilters.xsd";
    private static final Schema SCHEMA;

    static {
        try {
            SCHEMA = SchemaUtils.loadSchema((String)BUNDLE_ID, (String)SCHEMA_LOCATION);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private RecordFilterUtils() {
    }

    public static RecordFilters unmarshall(InputStream inputStream) throws RecordFilterLoadSaveException {
        try {
            return (RecordFilters)JaxbUtils.unmarshall((String)JAXB_PACKAGE, (ClassLoader)RecordFilters.class.getClassLoader(), (Schema)SCHEMA, (InputStream)inputStream);
        }
        catch (Exception e) {
            throw new RecordFilterLoadSaveException(e);
        }
    }

    public static void marshall(RecordFilters recordFilters, OutputStream outputStream) throws RecordFilterLoadSaveException {
        try {
            JaxbUtils.marshall((Object)recordFilters, (String)JAXB_PACKAGE, (ClassLoader)RecordFilters.class.getClassLoader(), (Schema)SCHEMA, (OutputStream)outputStream);
        }
        catch (Throwable e) {
            throw new RecordFilterLoadSaveException(e);
        }
    }

    public static Filter findFilter(RecordFilters filters, String name) throws RecordFilterNotFoundException {
        if (name == null || "".equals(name)) {
            return filters.getFilter().get(0);
        }
        for (Filter filter : filters.getFilter()) {
            if (!filter.getName().equals(name)) continue;
            return filter;
        }
        throw new RecordFilterNotFoundException(name);
    }

    public static Record filter(Filter filter, Record record) {
        DataFactory dataFactory = record.getFactory();
        Record newRecord = dataFactory.createRecord();
        newRecord.getMetadata().putAll(RecordFilterUtils.filter(filter, record.getMetadata(), dataFactory));
        return newRecord;
    }

    public static AnyMap filter(Filter filter, AnyMap source, DataFactory anyFactory) {
        if (source == null) {
            throw new IllegalArgumentException("source Any cannot be null!");
        }
        if (anyFactory == null) {
            throw new IllegalArgumentException("anyFactory cannot be null!");
        }
        AnyMap destination = anyFactory.createAnyMap();
        for (Map.Entry entry : source.entrySet()) {
            String name = (String)entry.getKey();
            if (!RecordFilterUtils.isAttributePassedThroughFilter(filter, name)) continue;
            Any attributeAny = anyFactory.cloneAny((Any)source.get(name));
            destination.put(name, attributeAny);
        }
        return destination;
    }

    private static boolean isAttributePassedThroughFilter(Filter recordFilter, String name) {
        if ("_recordid".equals(name) || "_source".equals(name)) {
            return true;
        }
        for (Element filterElement : recordFilter.getElement()) {
            if (!MASK_ANY.equals(filterElement.getName()) && !filterElement.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

