/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.util;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.util.AnyUtil;

public final class MetadataUtils {
    private static final Log LOG = LogFactory.getLog(MetadataUtils.class);

    private MetadataUtils() {
    }

    public static Any getAny(Any metadata, Mode mode, String ... path) {
        ArrayList<String> pathElements = new ArrayList<String>(Math.max(path.length, 16));
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String pathSegment = stringArray[n2];
            Object[] split = StringUtils.split((String)pathSegment, (char)'/');
            CollectionUtils.addAll(pathElements, (Object[])split);
            ++n2;
        }
        Any any = MetadataUtils.getAny(metadata, mode, pathElements, 0);
        return any;
    }

    public static AnyMap getMap(AnyMap metadata, boolean createAll, String ... path) {
        Any any = MetadataUtils.getAny((Any)metadata, createAll ? Mode.CREATE_ALL : Mode.CREATE_NONE, path);
        return any == null ? null : any.asMap();
    }

    public static AnyMap getMap(AnyMap metadata, Mode mode, String ... path) {
        Any any = MetadataUtils.getAny((Any)metadata, mode, path);
        return AnyUtil.asMap(any);
    }

    public static AnySeq getSeq(AnyMap metadata, Mode mode, String ... path) {
        Any any = MetadataUtils.getAny((Any)metadata, mode, path);
        return AnyUtil.asSeq(any);
    }

    public static Value getValue(AnyMap metadata, Mode mode, String ... path) {
        Any any = MetadataUtils.getAny((Any)metadata, mode, path);
        return (Value)(any == null ? null : any);
    }

    private static boolean flags2bool(Mode mode) {
        boolean create;
        switch (mode) {
            case CREATE_NONE: 
            case FAIL: {
                create = false;
                break;
            }
            case CREATE_ALL: {
                create = true;
                break;
            }
            default: {
                throw new NotImplementedException("unknown create flag: " + (Object)((Object)mode));
            }
        }
        return create;
    }

    private static Any getAny(Any parent, Mode mode, ArrayList<String> pathElements, int index) {
        Any child;
        if (index >= pathElements.size() || parent == null) {
            return parent;
        }
        String keyOrIndex = pathElements.get(index);
        boolean create = MetadataUtils.flags2bool(mode);
        if (parent.isMap()) {
            child = create ? parent.asMap().getMap(keyOrIndex, create) : (Any)parent.asMap().get(keyOrIndex);
        } else if (parent.isSeq()) {
            child = (Any)parent.asSeq().get(Integer.parseInt(keyOrIndex));
        } else {
            String subPath = MetadataUtils.getSubPath(pathElements, index);
            throw new InvalidValueTypeException("expected Any to be one of SEQ or MAP at: " + subPath);
        }
        if (child == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("missing element: " + MetadataUtils.getSubPath(pathElements, index)));
            }
            if (mode == Mode.FAIL) {
                throw new NoSuchElementException(StringUtils.join(pathElements, (char)'/'));
            }
        }
        return MetadataUtils.getAny(child, mode, pathElements, ++index);
    }

    private static String getSubPath(ArrayList<String> pathElements, int index) {
        return StringUtils.join(pathElements.subList(0, index), (char)'/');
    }

    public static enum Mode {
        CREATE_ALL,
        CREATE_NONE,
        FAIL;

    }
}

