/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.zookeeper.internal;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;

public class ZooKeeperServerRunner
implements Runnable {
    private static final int RESTART_DELAY_AFTER_ERROR = 1000;
    private final Log _log = LogFactory.getLog(this.getClass());
    private final boolean _isCluster;
    private final long _myId;
    private final QuorumPeerConfig _quorumPeerConfig;
    private final ServerConfig _serverConfig;
    private QuorumPeer _quorumPeer;
    private ZooKeeperServer _zkServer;
    private ServerCnxnFactory _cnxnFactory;
    private boolean _doShutdown;

    public ZooKeeperServerRunner(QuorumPeerConfig quorumPeerConfig, boolean isCluster, long myId) {
        this._isCluster = isCluster;
        this._myId = myId;
        this._quorumPeerConfig = quorumPeerConfig;
        this._serverConfig = new ServerConfig();
        this._serverConfig.readFrom(this._quorumPeerConfig);
    }

    @Override
    public void run() {
        this.setDoShutdown(false);
        while (!this.doShutdown()) {
            try {
                this.cleanup();
                if (this._isCluster) {
                    this.runPeer();
                } else {
                    this.runServer();
                }
                if (this.doShutdown()) continue;
                this._log.warn((Object)"ZooKeeper server has finished, will be restarted immediately.");
            }
            catch (Exception ex) {
                this._log.warn((Object)"Error running ZooKeeper server, will retry to start in a moment.", (Throwable)ex);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ex2) {
                    this._log.debug((Object)"Interrupt while waiting to restart failed server.", (Throwable)ex2);
                }
            }
        }
    }

    private synchronized void cleanup() {
        this._quorumPeer = null;
        this._zkServer = null;
        this._cnxnFactory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runServer() throws IOException, InterruptedException {
        ZooKeeperServerRunner zooKeeperServerRunner = this;
        synchronized (zooKeeperServerRunner) {
            System.setProperty("zookeeper.preAllocSize", "100");
            FileTxnLog.setPreallocSize((long)102400L);
            this._zkServer = new ZooKeeperServer();
            FileTxnSnapLog ftxn = new FileTxnSnapLog(new File(this._serverConfig.getDataLogDir()), new File(this._serverConfig.getDataDir()));
            this._zkServer.setTxnLogFactory(ftxn);
            this._zkServer.setTickTime(this._serverConfig.getTickTime());
            this._zkServer.setMinSessionTimeout(this._serverConfig.getMinSessionTimeout());
            this._zkServer.setMaxSessionTimeout(this._serverConfig.getMaxSessionTimeout());
            this._cnxnFactory = NIOServerCnxnFactory.createFactory((InetSocketAddress)this._serverConfig.getClientPortAddress(), (int)this._serverConfig.getMaxClientCnxns());
            this._cnxnFactory.startup(this._zkServer);
        }
        try {
            this._cnxnFactory.join();
        }
        finally {
            if (this._zkServer.isRunning()) {
                this._zkServer.shutdown();
            }
            this._cnxnFactory.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPeer() throws IOException, InterruptedException {
        ZooKeeperServerRunner zooKeeperServerRunner = this;
        synchronized (zooKeeperServerRunner) {
            this._log.info((Object)"Starting ZooKeeper quorum peer");
            this._cnxnFactory = NIOServerCnxnFactory.createFactory((InetSocketAddress)this._quorumPeerConfig.getClientPortAddress(), (int)this._quorumPeerConfig.getMaxClientCnxns());
            this._quorumPeer = new QuorumPeer();
            this._quorumPeer.setClientPortAddress(this._quorumPeerConfig.getClientPortAddress());
            this._quorumPeer.setTxnFactory(new FileTxnSnapLog(new File(this._quorumPeerConfig.getDataLogDir()), new File(this._quorumPeerConfig.getDataDir())));
            this._quorumPeer.setQuorumPeers(this._quorumPeerConfig.getServers());
            this._quorumPeer.setMyid(this._myId);
            this._quorumPeer.setElectionType(this._quorumPeerConfig.getElectionAlg());
            this._quorumPeer.setTickTime(this._quorumPeerConfig.getTickTime());
            this._quorumPeer.setMinSessionTimeout(this._quorumPeerConfig.getMinSessionTimeout());
            this._quorumPeer.setMaxSessionTimeout(this._quorumPeerConfig.getMaxSessionTimeout());
            this._quorumPeer.setInitLimit(this._quorumPeerConfig.getInitLimit());
            this._quorumPeer.setSyncLimit(this._quorumPeerConfig.getSyncLimit());
            this._quorumPeer.setQuorumVerifier(this._quorumPeerConfig.getQuorumVerifier());
            this._quorumPeer.setCnxnFactory(this._cnxnFactory);
            this._quorumPeer.setZKDatabase(new ZKDatabase(this._quorumPeer.getTxnFactory()));
            this._quorumPeer.setLearnerType(this._quorumPeerConfig.getPeerType());
            this._quorumPeer.start();
        }
        this._quorumPeer.join();
    }

    public synchronized void shutdown() {
        this.setDoShutdown(true);
        if (this._quorumPeer != null) {
            try {
                this._quorumPeer.shutdown();
            }
            catch (Exception ex) {
                this._log.warn((Object)"Error during shutdown of peer server", (Throwable)ex);
            }
        }
        if (this._zkServer != null) {
            try {
                this._zkServer.shutdown();
            }
            catch (Exception ex) {
                this._log.warn((Object)"Error during shutdown of stand-alone server, continuing to shutdown connection factory", (Throwable)ex);
            }
        }
        if (this._cnxnFactory != null) {
            try {
                this._cnxnFactory.shutdown();
            }
            catch (Exception ex) {
                this._log.warn((Object)"Error during shutdown of connection factory of stand-alone server", (Throwable)ex);
            }
        }
    }

    private synchronized void setDoShutdown(boolean doShutdown) {
        this._doShutdown = doShutdown;
    }

    private synchronized boolean doShutdown() {
        return this._doShutdown;
    }

    synchronized String getRemoteLeaderConnection() {
        if (this._quorumPeer != null) {
            String[] peers = this._quorumPeer.getQuorumPeers();
            if (peers == null) {
                return null;
            }
            if (peers.length > 1) {
                return null;
            }
            if (peers.length > 0 && this._quorumPeer.getQuorumPeers() != null && this._quorumPeer.getQuorumPeers().length > 0) {
                return this._quorumPeer.getQuorumPeers()[0];
            }
        }
        return null;
    }

    AnyMap getServerStatistics() {
        AnyMap stats = DataFactory.DEFAULT.createAnyMap();
        stats.put("dataDir", this._serverConfig.getDataDir());
        stats.put("dataLogDir", this._serverConfig.getDataLogDir());
        ZooKeeperServer localServer = this._zkServer;
        if (this._quorumPeer != null) {
            localServer = this._quorumPeer.getActiveServer();
        }
        if (localServer != null) {
            ServerStats serverStats;
            if (localServer.getZKDatabase() != null) {
                stats.put("nodeCount", (Number)localServer.getZKDatabase().getNodeCount());
                if (localServer.getZKDatabase().getDataTree() != null) {
                    stats.put("watchCount", (Number)localServer.getZKDatabase().getDataTree().getWatchCount());
                }
                if (localServer.getZKDatabase().getSessions() != null) {
                    stats.put("sessionsCount", (Number)localServer.getZKDatabase().getSessions().size());
                }
            }
            if ((serverStats = localServer.serverStats()) != null) {
                stats.put("avgLatency", (Number)serverStats.getAvgLatency());
                stats.put("minLatency", (Number)serverStats.getMinLatency());
                stats.put("maxLatency", (Number)serverStats.getMaxLatency());
                stats.put("outstandingRequests", (Number)serverStats.getOutstandingRequests());
                stats.put("packetsReceived", (Number)serverStats.getPacketsReceived());
                stats.put("packetsSent", (Number)serverStats.getPacketsSent());
            }
            stats.put("minSessionTimeout", (Number)localServer.getMinSessionTimeout());
            stats.put("maxSessionTimeout", (Number)localServer.getMaxSessionTimeout());
            stats.put("requestsInProcess", (Number)localServer.getInProcess());
        }
        return stats;
    }

    String getServerState() {
        if (this._quorumPeer != null) {
            return this._quorumPeer.getServerState();
        }
        return "standalone";
    }
}

