/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.objectstore.httphandler;

import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonParseException;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.objectstore.BadRequestException;
import org.eclipse.smila.objectstore.NoSuchObjectException;
import org.eclipse.smila.objectstore.NoSuchStoreException;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.ServiceUnavailableException;

public abstract class AStoreHandler
extends JsonRequestHandler {
    private ObjectStoreService _objectStoreService;

    public ObjectStoreService getObjectStoreService() {
        return this._objectStoreService;
    }

    public void setObjectStoreService(ObjectStoreService objectStoreService) {
        this._objectStoreService = objectStoreService;
    }

    public void unsetObjectStoreService(ObjectStoreService objectStoreService) {
        if (this._objectStoreService == objectStoreService) {
            this._objectStoreService = null;
        }
    }

    protected String getStoreName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern " + this.getUriPattern());
    }

    protected String getObjectId(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 1) {
            int lastPos;
            String objectId = (String)uriParts.get(1);
            if (objectId.charAt(lastPos = objectId.length() - 1) == '/') {
                return objectId.substring(0, lastPos);
            }
            return objectId;
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern " + this.getUriPattern());
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof NoSuchStoreException || ex instanceof NoSuchObjectException) {
            return 404;
        }
        if (ex instanceof BadRequestException || ex instanceof IllegalArgumentException || ex instanceof JsonParseException) {
            return 400;
        }
        if (ex instanceof ServiceUnavailableException || ex instanceof IOException) {
            return 503;
        }
        if (ex instanceof ObjectStoreException) {
            return 500;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }
}

