/***********************************************************************************************************************
 * Copyright (c) 2008,2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial API
 **********************************************************************************************************************/
package org.eclipse.smila.common.language;

import java.util.Set;

/**
 * Interface of a service that can identify the language of a text.
 * 
 * @see Language
 */
public interface LanguageIdentifyService {
  /**
   * detect the language of the given text.
   * 
   * @return a {@link Language} object describing the detection result, or <tt>null</tt> if detection was not possible.
   */
  Language identify(String content);

  /**
   * @return the ISO-639 language codes of all languages this service is able to detect.
   */
  Set<String> getSupportedLanguages();

  /**
   * @param isoLanguage
   *          ISO language code.
   * @return alternative name of this language, or <tt>null</tt> if the service does not know a name for this language.
   */
  String getAlternativeName(String isoLanguage);
}
