/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager;

import java.util.Collection;
import java.util.Map;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.definitions.Bucket;
import org.eclipse.smila.jobmanager.definitions.JobDefinition;
import org.eclipse.smila.jobmanager.definitions.WorkflowAction;
import org.eclipse.smila.jobmanager.definitions.WorkflowDefinition;

/**
 * Represents the data for a job run (the JobDefinition, the WorkflowDefinition, WorkerDefinitions, Buckets, etc.).
 */
public interface JobRun {

  /** @return the job's Bucket instance for a bucket with the given name */
  Bucket getBucket(final String bucketName);

  /** @return The Collection of Bucket instances of the JobRun. */
  Collection<Bucket> getBuckets();

  /** @return name of job definition */
  String getJobName();

  /** @return The ID of the job run. */
  String getJobRunId();

  /** @return persistent input buckets of start action. */
  Collection<Bucket> getTriggerBuckets();

  /**
   * @param triggeringBucket
   *          a bucket changed by another workflow
   * @return true if this job run can be triggered by this bucket.
   */
  boolean isTriggeredBy(final Bucket triggeringBucket);

  /** @return start action of this job run. */
  WorkflowAction getStartAction();

  /** @return merged and evaluated parameters for given action. */
  AnyMap getParameters(WorkflowAction action);

  /** @return the JobDefinition. */
  JobDefinition getJobDefinition();

  /** @return the workflow definition this job run is based on. */
  WorkflowDefinition getWorkflowDefinition();

  /** @return workflow actions triggered by given bucket. */
  Collection<WorkflowAction> getTriggeredActionsForBucket(final String bucketName);

  /** @return workflow actions that write to a given bucket. */
  Collection<WorkflowAction> getActionsWritingToBucket(String bucketName);

  /** @return input buckets of given workflow action. (key: input slot name, value: bucket) */
  Map<String, Bucket> getInputBucketsForAction(final WorkflowAction action);

  /** @return output buckets of given workflow action. (key: input slot name, value: bucket) */
  Map<String, Bucket> getOutputBucketsForAction(final WorkflowAction action);

  boolean hasBarriers();

  Collection<WorkflowAction> getBarrierActions();

  Collection<WorkflowAction> getPrecedingBarriers(WorkflowAction barrier);

  Collection<WorkflowAction> getBarriersForAction(WorkflowAction action);

  WorkflowAction getAction(int position);

}
