/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskworker;

import org.eclipse.smila.datamodel.AnyMap;

/**
 * Logging facility for task workers.
 */
public interface TaskLog {
  /** log info message. */
  void info(String message);

  /** log info message and throwable. */
  void info(String message, Throwable error);

  /** log info message and details. */
  void info(String message, AnyMap details);

  /** @return number of info messages written by this log. */
  int getInfoCount();

  /** log warn message. */
  void warn(String message);

  /** log warn message and throwable. */
  void warn(String message, Throwable error);

  /** log warn message and details. */
  void warn(String message, AnyMap details);

  /** @return number of warn messages written by this log. */
  int getWarnCount();

  /** log error message. */
  void error(String message);

  /** log error message and throwable. */
  void error(String message, Throwable error);

  /** log error message and details. */
  void error(String message, AnyMap details);

  /** @return number of error messages written by this log. */
  int getErrorCount();

}
