/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskworker.output;

import java.io.IOException;

import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskworker.io.IODataObject;

/**
 * Super class for the output data in task worker.
 */
public abstract class Output extends IODataObject {

  /**
   * Create Instance. Each subclass must implement the same constructor so that it can be instantiated by
   * {@link Outputs}.
   */
  public Output(final BulkInfo dataObject, final ObjectStoreService objectStore) {
    super(dataObject, objectStore);
  }

  /**
   * Method for committing the data, if necessary.
   */
  public abstract void commit() throws ObjectStoreException, IOException;

  /**
   * method for aborting the stream when not committing it.
   */
  public abstract void abort() throws ObjectStoreException, IOException;
}
