/**
 *
 */
package org.eclipse.smila.search.servlet.solr;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.params.CollectionParams.CollectionAction;
import org.apache.solr.common.params.CoreAdminParams.CoreAdminAction;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.solr.SolrConfig.Mode;
import org.eclipse.smila.solr.SolrOperationService;
import org.eclipse.smila.solr.SolrServerService;
import org.eclipse.smila.utils.service.ServiceUtils;

/**
 * @author pwissel
 *
 */
public class IndexNamesHelper {

  private static final Log _log = LogFactory.getLog(IndexNamesHelper.class);

  public static Collection<String> getIndexNames() throws InterruptedException {
    final SolrOperationService operationService = ServiceUtils.getService(SolrOperationService.class);
    final Mode mode = getMode();
    AnySeq indices = null;
    switch (mode) {
      case CLOUD:
        indices = getCollections(operationService);
        break;
      case EMBEDDED:
      case HTTP:
        indices = getCores(operationService);
        break;
      default:
        throw new NotImplementedException(mode.toString());
    }
    if (!CollectionUtils.isEmpty(indices)) {
      return indices.asStrings();
    }
    return CollectionUtils.EMPTY_COLLECTION;
  }

  private static AnySeq getCollections(final SolrOperationService operationService) {
    final Any response = operationService.processAdminOperation(CollectionAction.LIST.name(), null);
    return response.asMap().getSeq("collections");
  }

  private static AnySeq getCores(final SolrOperationService operationService) {
    final Map<String, String[]> params = new HashMap<String, String[]>();
    params.put("indexInfo", new String[] { "false" });
    final Any response = operationService.processAdminOperation(CoreAdminAction.STATUS.name(), params);
    final AnySeq cores = DataFactory.DEFAULT.createAnySeq();
    if ((response != null) && response.isMap()) {
      final Iterator<String> coreNames = response.asMap().getMap("status").keySet().iterator();
      while (coreNames.hasNext()) {
        cores.add(coreNames.next());
      }
    }
    return cores;
  }

  private static Mode getMode() throws InterruptedException {
    final SolrServerService serverService = ServiceUtils.getService(SolrServerService.class);
    return serverService.getConfig().getMode();
  }

}
