/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.bulkbuilder;

import org.eclipse.smila.objectstore.BadRequestException;
import org.eclipse.smila.utils.MaybeRecoverableException;

/**
 * Exception used by BulkBuilder or other bulkprocessing components to indicate errors with creating or processing a
 * bulk.
 * 
 */
public class BulkbuilderException extends MaybeRecoverableException {

  /**
   * exceptions are serializable.
   */
  private static final long serialVersionUID = 2L;

  /**
   * create exception with details message.
   * 
   * @param message
   *          details message
   */
  public BulkbuilderException(final String message) {
    super(message, false);
  }

  /**
   * create exception with details message and cause.
   * 
   * @param message
   *          details message
   * @param cause
   *          causing exception
   */
  public BulkbuilderException(final String message, final Throwable cause) {
    super(message, cause, isRecoverableCause(cause));
  }

  /** auto-detection of causes that should be recoverable. */
  public static boolean isRecoverableCause(final Throwable cause) {
    if (MaybeRecoverableException.isRecoverableCause(cause)) {
      return true;
    }
    return !(cause instanceof BadRequestException);
  }
}
