/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.bulkbuilder.helper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Implementation of a runnable tracker, that checks if a set time limit was reached for the currently build bulk in a
 * BulkBuilder and commits this bulk.
 * 
 * @author cind01
 * 
 */
public class BulkTracker implements Runnable {

  /**
   * time limit to check all bulks in milliseconds.
   */
  public static final long TIME_LIMIT = 5000;

  /**
   * Reference to the BulkBuilder to monitor.
   */
  private final BulkTrackerCallback _bulkBuilder;

  /**
   * The LOG.
   */
  private final Log _log = LogFactory.getLog(this.getClass());

  /**
   * Conversion Constructor.
   * 
   * @param bulkBuilder
   *          reference to the BulkBuilder to monitor
   */
  public BulkTracker(final BulkTrackerCallback bulkBuilder) {
    if (bulkBuilder == null) {
      throw new IllegalArgumentException("parameter bulkBuilder is null");
    }
    _bulkBuilder = bulkBuilder;
  }

  /**
   * {@inheritDoc}
   * 
   * @see Runnable#run()
   */
  @Override
  public void run() {
    if (_log.isTraceEnabled()) {
      _log.trace("Checking if time limit of  " + TIME_LIMIT + "ms was reached since last reset");
    }
    try {
      _bulkBuilder.checkBulks();
    } catch (final Exception e) {
      if (_log.isErrorEnabled()) {
        _log.error(e.getClass().getSimpleName() + " while committing bulks after reaching time limit", e);
      }
    }
  }
}
