/**
 *
 */
package org.eclipse.smila.solr.params;

import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrRequest.METHOD;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.solr.SolrConstants.ErrorHandling;
import org.eclipse.smila.solr.SolrConstants.QueryLogging;

/**
 * @author pwissel
 *
 */
public class SearchParams extends SolrParams {

  public static final String SEARCH = "search";

  public static final String HTTP_METHOD = "method";

  static final String ERROR_HANDLING = "ErrorHandling";

  public static final String QUERY_LOGGING = "queryLogging";

  /**
   * @param configuration
   */
  public SearchParams(AnyMap configuration) {
    super(configuration);
  }

  /**
   * @param blackboard
   */
  public SearchParams(Blackboard blackboard) {
    super(blackboard);
  }

  /**
   * @param blackboard
   * @param configuration
   */
  public SearchParams(Blackboard blackboard, AnyMap configuration) {
    super(blackboard, configuration);
  }

  /**
   * @param blackboard
   * @param configuration
   * @param recordId
   */
  public SearchParams(Blackboard blackboard, AnyMap configuration, String recordId) {
    super(blackboard, configuration, recordId);
  }

  /**
   * @param blackboard
   * @param recordId
   */
  public SearchParams(Blackboard blackboard, String recordId) {
    super(blackboard, recordId);
  }

  public METHOD getMethod() {
    final String method = getSolrParamAsString(SEARCH, HTTP_METHOD);
    if (method == null) {
      return METHOD.POST;
    }
    try {
      return METHOD.valueOf(method);
    } catch (Exception exception) {
      final String message =
        String.format("Operation must be one of [%s].", StringUtils.join(METHOD.values(), ", "));
      throw new IllegalArgumentException(message, exception);
    }
  }

  public ErrorHandling getErrorHandling() {
    final String handling = getSolrParamAsString(SEARCH, ERROR_HANDLING);
    if (handling == null) {
      return ErrorHandling.IGNORE;
    }
    try {
      return ErrorHandling.get(handling);
    } catch (Exception exception) {
      final String message =
        String.format("ErrorHandling must be one of [%s].", StringUtils.join(ErrorHandling.values(), ", "));
      throw new IllegalArgumentException(message, exception);
    }
  }

  public QueryLogging getQueryLogging() {
    final String logging = getSolrParamAsString(SEARCH, QUERY_LOGGING);
    if (logging == null) {
      return QueryLogging.NONE;
    }
    try {
      return QueryLogging.get(logging);
    } catch (Exception exception) {
      final String message =
        String.format("QueryHandling must be one of [%s].", StringUtils.join(QueryLogging.values(), ", "));
      throw new IllegalArgumentException(message, exception);
    }
  }

}
