/**
 *
 */
package org.eclipse.smila.solr.server;

import java.util.HashMap;
import java.util.Map;

import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.eclipse.smila.solr.SolrConfig;

/**
 * @author pwissel
 *
 */
public abstract class SolrServers {

  private final Map<String, SolrServer> _cache = new HashMap<String, SolrServer>();

  final private SolrConfig _config;

  public SolrServers(final SolrConfig config) {
    _config = config;
  }

  public SolrServer getServer(final String index) throws SolrServerException {
    SolrServer server = _cache.get(index);
    if (server == null) {
      synchronized (_cache) {
        try {
          server = createServer(index);
        } catch (Exception exception) {
          throw new SolrServerException("Unable to create solr server for name: " + index, exception);
        }
        _cache.put(index, server);
      }
    }
    return server;
  }

  public SolrServer getServer() throws SolrServerException {
    SolrServer server = _cache.get(null);
    if (server == null) {
      synchronized (_cache) {
        try {
          server = createServer();
        } catch (Exception exception) {
          throw new SolrServerException("Unable to create solr server", exception);
        }
        _cache.put(null, server);
      }
    }
    return server;
  }

  public void shutdown() {
    for (SolrServer solrServer : _cache.values()) {
      solrServer.shutdown();
    }
  }

  public void removeServer(final String name) {
    synchronized (_cache) {
      _cache.remove(name);
    }
  }

  public void clearCache() {
    synchronized (_cache) {
      _cache.clear();
    }
  }

  protected SolrConfig getConfig() {
    return _config;
  }

  protected abstract SolrServer createServer(final String name) throws Exception;

  protected abstract SolrServer createServer() throws Exception;

}
