/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.objectstore;

import java.util.Date;

import org.eclipse.smila.datamodel.AnyMap;

/**
 * Information about objects in a store of an {@link ObjectStoreService}. This defines only the basic parts of an
 * ObjectInfo that is common to all services. Implementations may choose to extend it add more specific information.
 */
public interface StoreObject {

  /** key of object ID in the AnyMap representation of the ObjectInfo. */
  String KEY_ID = "id";

  /** key of size in the AnyMap representation of the ObjectInfo. */
  String KEY_SIZE = "size";

  /** key of timestamp in the AnyMap representation of the ObjectInfo. */
  String KEY_TIMESTAMP = "timestamp";

  /** @return ID of object. */
  String getId();

  /** @return size of object in bytes. */
  long getSize();

  /** @return timestamp of last modification of object. */
  Date getTimestamp();

  /**
   * Create an {@link AnyMap} with the contents of this {@link StoreObject}. In JSON, it should look like this:
   * 
   * <pre>
   * {
   *   "id" : "name-of-object",
   *   "size" : 42,
   *   "timestamp" : "2011-06-20T09:22:42.123+0100"
   * }
   * </pre>
   * 
   * Service implementations that extend the ObjectInfo should still use this structure as a base and add specific
   * information as they like.
   * 
   * @return
   */
  AnyMap toAny();
}
