/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.common;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.builder.common.AbstractModelElementBuilder;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public abstract class AbstractProcessElementBuilder<T extends IModelElement & IIdentifiableElement, B extends AbstractProcessElementBuilder<T, B>>
extends AbstractModelElementBuilder<T, B> {
    protected ProcessDefinitionType process;

    public AbstractProcessElementBuilder(T element) {
        super((IIdentifiableElement)element);
    }

    public AbstractProcessElementBuilder(ProcessDefinitionType process, T element) {
        this(element);
        this.inProcess(process);
    }

    @Override
    protected T finalizeElement() {
        IModelElement element = (IModelElement)super.finalizeElement();
        if (null == this.process) {
            throw new NullPointerException("Process Definition must be set.");
        }
        return (T)element;
    }

    public B inProcess(ProcessDefinitionType process) {
        this.setProcess(process);
        return (B)((AbstractProcessElementBuilder)this.self());
    }

    public B forProcess(ProcessDefinitionType process) {
        this.setProcess(process);
        return (B)((AbstractProcessElementBuilder)this.self());
    }

    public ProcessDefinitionType process() {
        return this.process;
    }

    protected void setProcess(ProcessDefinitionType process) {
        if (null == this.process) {
            if (null != process) {
                this.process = process;
                ModelType containingModel = ModelUtils.findContainingModel((EObject)process);
                if (null != containingModel) {
                    this.setModel(containingModel);
                }
            }
        } else if (this.process != process) {
            throw new IllegalArgumentException("Process Definition must only be set once.");
        }
    }
}

