/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.defaults;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.engine.core.extensions.triggers.manual.ManualTriggerValidator;
import org.eclipse.stardust.engine.core.pojo.app.PlainJavaAccessPointProvider;
import org.eclipse.stardust.engine.core.pojo.app.PlainJavaApplicationInstance;
import org.eclipse.stardust.engine.core.pojo.app.PlainJavaValidator;
import org.eclipse.stardust.engine.core.pojo.data.JavaBeanAccessPathEvaluator;
import org.eclipse.stardust.engine.core.pojo.data.PrimitiveAccessPathEvaluator;
import org.eclipse.stardust.engine.core.pojo.data.PrimitiveValidator;
import org.eclipse.stardust.engine.core.pojo.data.SerializableValidator;
import org.eclipse.stardust.engine.core.spi.extensions.model.AccessPointProvider;
import org.eclipse.stardust.engine.core.spi.extensions.model.ApplicationValidator;
import org.eclipse.stardust.engine.core.spi.extensions.model.DataValidator;
import org.eclipse.stardust.engine.core.spi.extensions.model.ExtendedDataValidator;
import org.eclipse.stardust.engine.core.spi.extensions.model.TriggerValidator;
import org.eclipse.stardust.engine.core.spi.extensions.runtime.AccessPathEvaluator;
import org.eclipse.stardust.engine.core.spi.extensions.runtime.ApplicationInstance;
import org.eclipse.stardust.engine.core.spi.extensions.runtime.DataFilterExtension;
import org.eclipse.stardust.engine.core.spi.extensions.runtime.DataLoader;
import org.eclipse.stardust.engine.core.spi.extensions.runtime.ExtendedAccessPathEvaluator;
import org.eclipse.stardust.engine.core.spi.extensions.runtime.StatelessApplicationInstance;
import org.eclipse.stardust.engine.core.struct.spi.StructuredDataFilterExtension;
import org.eclipse.stardust.engine.core.struct.spi.StructuredDataLoader;
import org.eclipse.stardust.engine.core.struct.spi.StructuredDataXMLValidator;
import org.eclipse.stardust.engine.core.struct.spi.StructuredDataXPathEvaluator;
import org.eclipse.stardust.engine.extensions.dms.data.VfsDocumentAccessPathEvaluator;
import org.eclipse.stardust.engine.extensions.dms.data.VfsDocumentListAccessPathEvaluator;
import org.eclipse.stardust.engine.extensions.dms.data.VfsDocumentListValidator;
import org.eclipse.stardust.engine.extensions.dms.data.VfsDocumentValidator;
import org.eclipse.stardust.engine.extensions.ejb.SessionBeanValidator;
import org.eclipse.stardust.engine.extensions.ejb.app.SessionBeanAccessPointProvider;
import org.eclipse.stardust.engine.extensions.ejb.app.SessionBeanApplicationInstance;
import org.eclipse.stardust.engine.extensions.ejb.data.EntityBeanEvaluator;
import org.eclipse.stardust.engine.extensions.ejb.data.EntityBeanValidator;
import org.eclipse.stardust.engine.extensions.jaxws.app.WebserviceApplicationInstance;
import org.eclipse.stardust.engine.extensions.jaxws.app.WebserviceApplicationValidator;
import org.eclipse.stardust.engine.extensions.jms.app.JMSApplicationInstance;
import org.eclipse.stardust.engine.extensions.jms.app.JMSValidator;
import org.eclipse.stardust.engine.extensions.xml.data.XMLValidator;
import org.eclipse.stardust.engine.extensions.xml.data.XPathEvaluator;
import org.eclipse.stardust.model.xpdl.builder.model.BpmPackageBuilder;
import org.eclipse.stardust.model.xpdl.builder.spi.ModelInitializer;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationTypeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerTypeType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public class DefaultTypesInitializer
implements ModelInitializer {
    private static final String[] defaultContextTypes = new String[]{"default", "engine", "application", "jfc", "jsp", "processInterface"};
    private static final String[] defaultTriggerTypes = new String[]{"manual", "jms", "mail", "timer"};
    private static final String[] defaultConditionTypes = new String[]{"timer", "exception", "statechange", "processStatechange", "onAssignment"};
    private static final String[] defaultActionTypes = new String[]{"trigger", "mail", "abortProcess", "notifyWfXMLObserversActivity", "completeActivity", "activateActivity", "delegateActivity", "scheduleActivity", "excludeUser", "setData"};

    @Override
    public void initializeModel(ModelType model) {
        this.initializeDataTypes(model);
        this.initializeApplicationTypes(model);
        this.initializeInteractionContextTypes(model);
        this.initializeTriggerTypes(model);
    }

    public void initializeDataTypes(ModelType model) {
        this.initializeDataType(model, "primitive", "Primitive Data", PrimitiveAccessPathEvaluator.class, PrimitiveValidator.class, new Class[0]);
        this.initializeDataType(model, "serializable", "Serializable Data", JavaBeanAccessPathEvaluator.class, SerializableValidator.class, new Class[0]);
        this.initializeDataType(model, "entity", "Entity Bean", EntityBeanEvaluator.class, EntityBeanValidator.class, new Class[0]);
        this.initializeDataType(model, "plainXML", "XML Document", XPathEvaluator.class, XMLValidator.class, new Class[0]);
        this.initializeDataType(model, "struct", "Structured Data", StructuredDataXPathEvaluator.class, StructuredDataXMLValidator.class, StructuredDataFilterExtension.class, StructuredDataLoader.class);
        this.initializeDataType(model, "dmsDocument", "Document", VfsDocumentAccessPathEvaluator.class, VfsDocumentValidator.class, StructuredDataFilterExtension.class, StructuredDataLoader.class);
        this.initializeDataType(model, "dmsDocumentList", "Document List", VfsDocumentListAccessPathEvaluator.class, VfsDocumentListValidator.class, StructuredDataFilterExtension.class, StructuredDataLoader.class);
        this.initializeDataType(model, "dmsFolder", "Folder", VfsDocumentAccessPathEvaluator.class, VfsDocumentValidator.class, StructuredDataFilterExtension.class, StructuredDataLoader.class);
        this.initializeDataType(model, "dmsFolderList", "Folder List", VfsDocumentListAccessPathEvaluator.class, VfsDocumentListValidator.class, StructuredDataFilterExtension.class, StructuredDataLoader.class);
    }

    public void initializeApplicationTypes(ModelType model) {
        this.initializeApplicationType(model, "sessionBean", "Session Bean Application", SessionBeanAccessPointProvider.class, SessionBeanApplicationInstance.class, SessionBeanValidator.class);
        this.initializeApplicationType(model, "plainJava", "Plain Java Application", PlainJavaAccessPointProvider.class, PlainJavaApplicationInstance.class, PlainJavaValidator.class);
        this.initializeApplicationType(model, "jms", "JMS Application", null, JMSApplicationInstance.class, JMSValidator.class);
        this.initializeApplicationType(model, "webservice", "Web Service Application", null, WebserviceApplicationInstance.class, WebserviceApplicationValidator.class);
    }

    public void initializeInteractionContextTypes(ModelType model) {
        this.initializeInteractionContextType(model, "default", "Default Context", false, true);
        this.initializeInteractionContextType(model, "engine", "Engine Context", true, false);
        this.initializeInteractionContextType(model, "externalWebApp", "External Web Application", true, false);
        this.initializeInteractionContextType(model, "application", "Noninteractive Application Context", true, false);
        this.initializeInteractionContextType(model, "processInterface", "Process Interface Context", true, false);
    }

    public void initializeTriggerTypes(ModelType model) {
        this.initializeTriggerType(model, "manual", "Manual Trigger", false, ManualTriggerValidator.class);
    }

    public void initializeDataType(ModelType model, String typeId, String typeName, Class<?> clsEvaluator, Class<?> clsValidator, Class<?> ... clsExtensions) {
        if (!AccessPathEvaluator.class.isAssignableFrom(clsEvaluator) && !ExtendedAccessPathEvaluator.class.isAssignableFrom(clsEvaluator)) {
            throw new IllegalArgumentException("Unsupported data evaluator type: " + clsEvaluator);
        }
        if (!DataValidator.class.isAssignableFrom(clsValidator) && !ExtendedDataValidator.class.isAssignableFrom(clsValidator)) {
            throw new IllegalArgumentException("Unsupported data validator type: " + clsValidator);
        }
        if (null == ModelUtils.findElementById((List)model.getDataType(), (String)typeId)) {
            DataTypeType typeDef = BpmPackageBuilder.F_CWM.createDataTypeType();
            typeDef.setId(typeId);
            typeDef.setName(typeName);
            typeDef.setIsPredefined(true);
            AttributeUtil.setAttribute((IExtensibleElement)typeDef, (String)"carnot:engine:evaluator", (String)clsEvaluator.getName());
            AttributeUtil.setAttribute((IExtensibleElement)typeDef, (String)"carnot:engine:validator", (String)clsValidator.getName());
            if (null != clsExtensions) {
                for (Class<?> clsExtension : clsExtensions) {
                    if (DataFilterExtension.class.isAssignableFrom(clsExtension)) {
                        AttributeUtil.setAttribute((IExtensibleElement)typeDef, (String)"carnot:engine:dataFilterExtension", (String)clsExtension.getName());
                        continue;
                    }
                    if (DataLoader.class.isAssignableFrom(clsExtension)) {
                        AttributeUtil.setAttribute((IExtensibleElement)typeDef, (String)"carnot:engine:dataLoader", (String)clsExtension.getName());
                        continue;
                    }
                    throw new IllegalArgumentException("Unrecognized data type extension: " + clsExtension);
                }
            }
            model.getDataType().add((Object)typeDef);
        }
    }

    public void initializeApplicationType(ModelType model, String typeId, String typeName, Class<? extends AccessPointProvider> clsApProvider, Class<?> clsAppDriver, Class<? extends ApplicationValidator> clsValidator) {
        if (!ApplicationInstance.class.isAssignableFrom(clsAppDriver) && !StatelessApplicationInstance.class.isAssignableFrom(clsAppDriver)) {
            throw new IllegalArgumentException("Unsupported application instance type: " + clsAppDriver);
        }
        if (null == ModelUtils.findElementById((List)model.getApplicationType(), (String)typeId)) {
            ApplicationTypeType typeDef = BpmPackageBuilder.F_CWM.createApplicationTypeType();
            typeDef.setId(typeId);
            typeDef.setName(typeName);
            typeDef.setIsPredefined(true);
            if (null != clsApProvider) {
                AttributeUtil.setAttribute((IExtensibleElement)typeDef, (String)"carnot:engine:accessPointProvider", (String)clsApProvider.getName());
            }
            AttributeUtil.setAttribute((IExtensibleElement)typeDef, (String)"carnot:engine:applicationInstance", (String)clsAppDriver.getName());
            AttributeUtil.setAttribute((IExtensibleElement)typeDef, (String)"carnot:engine:validator", (String)clsValidator.getName());
            model.getApplicationType().add((Object)typeDef);
        }
    }

    private void initializeInteractionContextType(ModelType model, String typeId, String typeName, boolean hasApplicationPath, boolean hasMappingId) {
        if (null == ModelUtils.findElementById((List)model.getApplicationContextType(), (String)typeId)) {
            ApplicationContextTypeType typeDef = BpmPackageBuilder.F_CWM.createApplicationContextTypeType();
            typeDef.setId(typeId);
            typeDef.setName(typeName);
            typeDef.setIsPredefined(true);
            typeDef.setHasApplicationPath(hasApplicationPath);
            typeDef.setHasMappingId(hasMappingId);
            model.getApplicationContextType().add((Object)typeDef);
        }
    }

    public void initializeTriggerType(ModelType model, String typeId, String typeName, boolean isPull, Class<? extends TriggerValidator> clsValidator) {
        if (null == ModelUtils.findElementById((List)model.getApplicationType(), (String)typeId)) {
            TriggerTypeType typeDef = BpmPackageBuilder.F_CWM.createTriggerTypeType();
            typeDef.setId(typeId);
            typeDef.setName(typeName);
            typeDef.setPullTrigger(isPull);
            typeDef.setIsPredefined(true);
            AttributeUtil.setAttribute((IExtensibleElement)typeDef, (String)"carnot:engine:validator", (String)clsValidator.getName());
            model.getTriggerType().add((Object)typeDef);
        }
    }

    private void createDefaultTypes(ModelType model) {
        this.addMetaTypes(model, defaultContextTypes, "contextTypes", CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType_HasMappingId(), CarnotWorkflowModelPackage.eINSTANCE.getApplicationContextTypeType_HasApplicationPath()});
        this.addMetaTypes(model, defaultTriggerTypes, "triggerTypes", CarnotWorkflowModelPackage.eINSTANCE.getTriggerTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getTriggerTypeType_PullTrigger()});
        this.addMetaTypes(model, defaultConditionTypes, "conditionTypes", CarnotWorkflowModelPackage.eINSTANCE.getEventConditionTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getEventConditionTypeType_Implementation(), CarnotWorkflowModelPackage.eINSTANCE.getEventConditionTypeType_ActivityCondition(), CarnotWorkflowModelPackage.eINSTANCE.getEventConditionTypeType_ProcessCondition()});
        this.addMetaTypes(model, defaultActionTypes, "actionTypes", CarnotWorkflowModelPackage.eINSTANCE.getEventActionTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getEventActionTypeType_ActivityAction(), CarnotWorkflowModelPackage.eINSTANCE.getEventActionTypeType_ProcessAction(), CarnotWorkflowModelPackage.eINSTANCE.getEventActionTypeType_SupportedConditionTypes(), CarnotWorkflowModelPackage.eINSTANCE.getEventActionTypeType_UnsupportedContexts()});
    }

    private void addMetaTypes(ModelType model, String[] ids, String extensionPointId, EClass type, EStructuralFeature[] features) {
    }
}

