/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.session;

import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.model.xpdl.builder.session.Modification;

public class EditingSession {
    private static final Logger trace = LogManager.getLogger(EditingSession.class);
    private final String id;
    private final Set<EObject> models = CollectionUtils.newHashSet();
    private ChangeRecorder emfChangeRecorder = new ChangeRecorder(){

        protected boolean isOrphan(EObject eObject) {
            return !EditingSession.this.models.contains(eObject) && super.isOrphan(eObject);
        }
    };
    private final Stack<Modification> undoableModifications = new Stack();
    private final Stack<Modification> redoableModifications = new Stack();

    public EditingSession() {
        this(UUID.randomUUID().toString());
    }

    public EditingSession(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean isTrackingModel(EObject model) {
        return this.models.contains(model);
    }

    public void trackModel(EObject model) {
        if (!this.models.contains(model)) {
            this.models.add(model);
        }
    }

    public boolean isInEditMode() {
        return null != this.emfChangeRecorder && this.emfChangeRecorder.isRecording();
    }

    public boolean beginEdit() {
        if (!this.isInEditMode()) {
            this.emfChangeRecorder = new ChangeRecorder(this.models){

                protected boolean isOrphan(EObject eObject) {
                    return !EditingSession.this.models.contains(eObject) && super.isOrphan(eObject);
                }
            };
            return this.isInEditMode();
        }
        return false;
    }

    public boolean endEdit() {
        if (this.isInEditMode()) {
            ChangeDescription changeDescription = this.emfChangeRecorder.endRecording();
            this.emfChangeRecorder.dispose();
            this.emfChangeRecorder = null;
            if (!this.redoableModifications.isEmpty()) {
                this.redoableModifications.clear();
            }
            this.undoableModifications.push(new Modification(this, changeDescription));
            return !this.isInEditMode();
        }
        return false;
    }

    public boolean canUndo() {
        return !this.undoableModifications.isEmpty() && this.undoableModifications.peek().canUndo();
    }

    public Modification getPendingUndo() {
        return !this.undoableModifications.isEmpty() ? this.undoableModifications.peek() : null;
    }

    public boolean canRedo() {
        return !this.redoableModifications.isEmpty() && this.redoableModifications.peek().canRedo();
    }

    public Modification getPendingRedo() {
        return !this.redoableModifications.isEmpty() ? this.redoableModifications.peek() : null;
    }

    public Modification undoLast() {
        int nUndos = 0;
        Modification change = null;
        if (this.canUndo()) {
            change = this.undoableModifications.pop();
            change.undo();
            ++nUndos;
            this.redoableModifications.push(change);
        }
        return change;
    }

    public Modification redoNext() {
        int nRedos = 0;
        Modification change = null;
        if (this.canRedo()) {
            change = this.redoableModifications.pop();
            change.redo();
            ++nRedos;
            this.undoableModifications.push(change);
        }
        return change;
    }

    public void clearUndoRedoStack() {
        this.undoableModifications.clear();
        this.redoableModifications.clear();
    }
}

