/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.utils;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public class LaneParticipantUtil {
    public static boolean isUsedInLane(IModelParticipant participant) {
        ModelType model = ModelUtils.findContainingModel((EObject)participant);
        for (ProcessDefinitionType process : model.getProcessDefinition()) {
            EList diagrams = process.getDiagram();
            for (DiagramType diagram : diagrams) {
                EList pools = diagram.getPoolSymbols();
                for (PoolSymbol pool : pools) {
                    if (pool.getLanes().isEmpty()) continue;
                    return LaneParticipantUtil.isParticipantUsedInLanes((ISwimlaneSymbol)pool, (EObject)participant);
                }
            }
        }
        return false;
    }

    private static boolean isParticipantUsedInLanes(ISwimlaneSymbol container, EObject element) {
        for (LaneSymbol lane : container.getChildLanes()) {
            IModelParticipant participant = LaneParticipantUtil.getParticipant(lane);
            if (participant != null && participant.equals(element)) {
                return true;
            }
            if (lane.getChildLanes().isEmpty()) continue;
            return LaneParticipantUtil.isParticipantUsedInLanes((ISwimlaneSymbol)lane, element);
        }
        return false;
    }

    public static void deleteLane(LaneSymbol lane) {
        LaneParticipantUtil.setParticipant(lane, null);
    }

    public static void setParticipant(LaneSymbol lane, IModelParticipant participant) {
        lane.setParticipant(null);
        lane.setParticipantReference(participant);
    }

    public static IModelParticipant getParticipant(LaneSymbol lane) {
        IModelParticipant participant = lane.getParticipantReference();
        if (participant == null && (participant = lane.getParticipant()) != null) {
            LaneParticipantUtil.setParticipant(lane, participant);
        }
        if (lane.getParticipantReference() != null) {
            return participant;
        }
        return null;
    }
}

