/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.utils;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.TransformerFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.model.xpdl.builder.utils.PepperConnectionManager;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;

public class PepperModelLoader
extends WorkflowModelManager {
    private PepperConnectionManager manager;

    public void resolve(ModelType model) {
        if (model != null) {
            this.manager = new PepperConnectionManager(model);
            this.manager.resolve();
        }
        super.resolve(model);
    }

    public void save(URI uri) throws IOException {
        if (this.manager == null) {
            ModelType model = this.getModel();
            if (model != null) {
                this.manager = new PepperConnectionManager(model);
            }
        } else {
            this.manager.save();
        }
        super.save(uri);
    }

    public PepperConnectionManager getConnectionManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelType loadModel(File modelXml) throws IOException {
        String ippTraxFactory = Parameters.instance().getString("Carnot.Xml.TrAX.TransformerFactory");
        String traxFactoryOverride = System.getProperty(TransformerFactory.class.getName());
        try {
            if (!StringUtils.isEmpty((String)ippTraxFactory)) {
                System.setProperty(TransformerFactory.class.getName(), ippTraxFactory);
            }
            WorkflowModelManager modelMgr = new WorkflowModelManager();
            modelMgr.load(modelXml);
            ModelType modelType = modelMgr.getModel();
            return modelType;
        }
        finally {
            if (!StringUtils.isEmpty((String)ippTraxFactory) && !StringUtils.isEmpty((String)traxFactoryOverride)) {
                System.setProperty(TransformerFactory.class.getName(), traxFactoryOverride);
            }
        }
    }
}

