/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.activity;

import org.eclipse.emf.common.util.URI;
import org.eclipse.stardust.model.xpdl.builder.activity.AbstractActivityBuilder;
import org.eclipse.stardust.model.xpdl.builder.utils.WebModelerConnectionManager;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IdRef;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.SubProcessModeType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.descriptors.ReplaceModelElementDescriptor;
import org.eclipse.stardust.modeling.repository.common.util.ImportUtils;

public class BpmSubProcessActivityBuilder
extends AbstractActivityBuilder<BpmSubProcessActivityBuilder> {
    ModelType subProcessModel;

    public ModelType getSubProcessModel() {
        return this.subProcessModel;
    }

    public void setSubProcessModel(ModelType subProcessModel) {
        this.subProcessModel = subProcessModel;
    }

    public BpmSubProcessActivityBuilder() {
        ((ActivityType)this.element).setImplementation(ActivityImplementationType.SUBPROCESS_LITERAL);
    }

    @Override
    protected ActivityType finalizeElement() {
        if (null == ((ActivityType)this.element).getSubProcessMode()) {
            ((ActivityType)this.element).setSubProcessMode(SubProcessModeType.SYNC_SHARED_LITERAL);
        }
        return super.finalizeElement();
    }

    public BpmSubProcessActivityBuilder invokingProcess(ProcessDefinitionType process) {
        ActivityType activity = (ActivityType)this.element;
        ModelType processModel = this.getSubProcessModel();
        if (this.model.equals(processModel)) {
            ((ActivityType)this.element).setImplementationProcess(process);
        } else {
            String fileConnectionId = WebModelerConnectionManager.createFileConnection(this.model, processModel);
            String bundleId = "org.eclipse.stardust.modeling.core";
            URI uri = URI.createURI((String)("cnx://" + fileConnectionId + "/"));
            ReplaceModelElementDescriptor descriptor = new ReplaceModelElementDescriptor(uri, (IIdentifiableModelElement)process, bundleId, null, true);
            AttributeUtil.setAttribute((IExtensibleElement)activity, (String)"carnot:connection:uri", (String)descriptor.getURI().toString());
            if (processModel != null) {
                IdRef idRef = CarnotWorkflowModelFactory.eINSTANCE.createIdRef();
                idRef.setRef(process.getId());
                idRef.setPackageRef(ImportUtils.getPackageRef((IObjectDescriptor)descriptor, (ModelType)this.model, (ModelType)processModel));
                activity.setExternalRef(idRef);
                activity.setSubProcessMode(SubProcessModeType.SYNC_SEPARATE_LITERAL);
            }
        }
        return this;
    }

    public BpmSubProcessActivityBuilder usingMode(SubProcessModeType subProcessMode) {
        ((ActivityType)this.element).setSubProcessMode(subProcessMode);
        return this;
    }
}

