/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.common;

import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.builder.common.AbstractElementBuilder;
import org.eclipse.stardust.model.xpdl.builder.utils.NameIdUtilsExtension;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;

public abstract class AbstractIdentifiableElementBuilder<T extends IIdentifiableElement, B extends AbstractIdentifiableElementBuilder<T, B>>
extends AbstractElementBuilder<T, B> {
    public AbstractIdentifiableElementBuilder(T element) {
        super(element);
    }

    @Override
    public T build() {
        if (StringUtils.isEmpty((String)((IIdentifiableElement)this.element).getId())) {
            // empty if block
        }
        return this.finalizeElement();
    }

    protected abstract String deriveDefaultElementId();

    @Override
    protected T finalizeElement() {
        IIdentifiableElement element = (IIdentifiableElement)super.finalizeElement();
        if (!element.isSetId()) {
            if (!StringUtils.isEmpty((String)element.getName())) {
                element.setId(NameIdUtilsExtension.createIdFromName((String)element.getName()));
            } else {
                String defaultId = this.deriveDefaultElementId();
                if (null != defaultId) {
                    element.setId(defaultId);
                }
            }
        }
        if (!element.isSetName()) {
            element.setName(element.getId());
        }
        return (T)element;
    }

    public B withId(String id) {
        ((IIdentifiableElement)this.element).setId(id);
        return (B)((AbstractIdentifiableElementBuilder)this.self());
    }

    public B withName(String name) {
        ((IIdentifiableElement)this.element).setName(name);
        return (B)((AbstractIdentifiableElementBuilder)this.self());
    }

    public B withIdAndName(String id, String name) {
        this.withId(id);
        this.withName(name);
        return (B)((AbstractIdentifiableElementBuilder)this.self());
    }
}

