/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.diagram;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.builder.common.AbstractElementBuilder;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public abstract class AbstractGraphicalObjectBuilder<T extends IGraphicalObject, C extends ISymbolContainer, B extends AbstractGraphicalObjectBuilder<T, C, B>>
extends AbstractElementBuilder<T, B> {
    protected ModelType model;
    protected C container;

    public AbstractGraphicalObjectBuilder(T element) {
        super(element);
    }

    public AbstractGraphicalObjectBuilder(C container, T element) {
        this(element);
        this.inContainer(container);
    }

    @Override
    protected T finalizeElement() {
        IGraphicalObject element = (IGraphicalObject)super.finalizeElement();
        if (null == this.container) {
            throw new NullPointerException("Container must be set.");
        }
        if (null == this.model) {
            throw new NullPointerException("Model must be set.");
        }
        return (T)element;
    }

    public B inContainer(C container) {
        this.setContainer(container);
        return (B)((AbstractGraphicalObjectBuilder)this.self());
    }

    public C container() {
        return this.container;
    }

    protected void setContainer(C container) {
        if (null == this.container) {
            if (null != container) {
                this.container = container;
                ModelType containingModel = ModelUtils.findContainingModel(container);
                if (null != containingModel) {
                    this.setModel(containingModel);
                }
            }
        } else if (this.container != container) {
            throw new IllegalArgumentException("Container must only be set once.");
        }
    }

    public B inModel(ModelType model) {
        this.setModel(model);
        return (B)((AbstractGraphicalObjectBuilder)this.self());
    }

    protected B forElement(IModelElement modelElement) {
        this.setModelElement(modelElement);
        return (B)((AbstractGraphicalObjectBuilder)this.self());
    }

    protected void setModelElement(IModelElement modelElement) {
        ModelType containingModel = ModelUtils.findContainingModel((EObject)modelElement);
        if (null != containingModel) {
            this.setModel(containingModel);
        }
    }

    public B forModel(ModelType model) {
        return this.inModel(model);
    }

    public ModelType model() {
        return this.model;
    }

    protected void setModel(ModelType model) {
        if (null == this.model) {
            if (null != model) {
                this.model = model;
            }
        } else if (this.model != model) {
            throw new IllegalArgumentException("Model must only be set once.");
        }
    }
}

