/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.model;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.config.CurrentVersion;
import org.eclipse.stardust.common.config.ExtensionProviderUtils;
import org.eclipse.stardust.model.xpdl.builder.BpmModelDef;
import org.eclipse.stardust.model.xpdl.builder.common.AbstractIdentifiableElementBuilder;
import org.eclipse.stardust.model.xpdl.builder.defaults.DefaultElementsInitializer;
import org.eclipse.stardust.model.xpdl.builder.defaults.DefaultTypesInitializer;
import org.eclipse.stardust.model.xpdl.builder.spi.ModelInitializer;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.ModelOidUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;

public class BpmPackageBuilder
extends AbstractIdentifiableElementBuilder<ModelType, BpmPackageBuilder> {
    private BpmModelDef definition;

    public BpmPackageBuilder() {
        super(BpmPackageBuilder.doCreate());
        this.withName("New Workflow Model");
    }

    private static ModelType doCreate() {
        ModelType model = F_CWM.createModelType();
        model.setOid(0L);
        long maxUsedOid = ModelUtils.getMaxUsedOid((ModelType)model);
        ModelOidUtil.register((ModelType)model, (long)maxUsedOid, null);
        return model;
    }

    @Override
    protected String deriveDefaultElementId() {
        return "NewWorkflowModel";
    }

    public static BpmPackageBuilder newModel() {
        return new BpmPackageBuilder();
    }

    @Override
    protected ModelType finalizeElement() {
        super.finalizeElement();
        ((ModelType)this.element).setVendor("Eclipse.org, Eclipse Process Manager");
        ((ModelType)this.element).setCarnotVersion(CurrentVersion.getVersionName());
        ((ModelType)this.element).setScript(XpdlFactory.eINSTANCE.createScriptType());
        ((ModelType)this.element).getScript().setType("text/ecmascript");
        ((ModelType)this.element).setTypeDeclarations(XpdlFactory.eINSTANCE.createTypeDeclarationsType());
        ((ModelType)this.element).setCreated(new Date().toString());
        ((ModelType)this.element).setAuthor(System.getProperty("user.name"));
        ((ModelType)this.element).setModelOID(0);
        ArrayList modelInitializers = CollectionUtils.newArrayList();
        modelInitializers.add(new DefaultTypesInitializer());
        modelInitializers.add(new DefaultElementsInitializer());
        modelInitializers.addAll(ExtensionProviderUtils.getExtensionProviders(ModelInitializer.class));
        for (ModelInitializer initializer : modelInitializers) {
            initializer.initializeModel((ModelType)this.element);
        }
        if (null != this.definition) {
            this.definition.build((ModelType)this.element);
        }
        return (ModelType)this.element;
    }

    public BpmPackageBuilder definedAs(BpmModelDef definition) {
        this.definition = definition;
        return this;
    }
}

