/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.strategy;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.builder.BpmModelBuilder;
import org.eclipse.stardust.model.xpdl.builder.common.EObjectUUIDMapper;
import org.eclipse.stardust.model.xpdl.builder.model.BpmPackageBuilder;
import org.eclipse.stardust.model.xpdl.builder.strategy.ModelManagementStrategy;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;

public abstract class AbstractModelManagementStrategy
implements ModelManagementStrategy {
    private boolean hasLoaded = false;
    private Map<String, ModelType> xpdlModels = CollectionUtils.newHashMap();
    private Map<ModelType, EObject> nativeModels = CollectionUtils.newHashMap();
    private final EObjectUUIDMapper eObjectUUIDMapper = new EObjectUUIDMapper();

    @Override
    public Map<String, ModelType> getModels() {
        return this.getModels(false);
    }

    public EObject getNativeModel(String modelId) {
        ModelType xpdlModel = this.getModels().get(modelId);
        EObject originalModel = this.nativeModels.get(xpdlModel);
        return null != originalModel ? originalModel : xpdlModel;
    }

    @Override
    public Map<String, ModelType> getModels(boolean reload) {
        if (reload || !this.hasLoaded) {
            this.hasLoaded = true;
            this.xpdlModels.clear();
            this.nativeModels.clear();
            for (ModelDescriptor modelDescriptor : this.loadModels()) {
                this.xpdlModels.put(modelDescriptor.id, modelDescriptor.xpdlModel);
                if (modelDescriptor.xpdlModel == modelDescriptor.nativeModel) continue;
                this.nativeModels.put(modelDescriptor.xpdlModel, modelDescriptor.nativeModel);
            }
        }
        return this.xpdlModels;
    }

    @Override
    public EObjectUUIDMapper uuidMapper() {
        return this.eObjectUUIDMapper;
    }

    protected void loadEObjectUUIDMap(ModelType model) {
        if (null == this.eObjectUUIDMapper.getUUID((EObject)model)) {
            this.eObjectUUIDMapper.map((EObject)model);
            TreeIterator i = model.eAllContents();
            while (i.hasNext()) {
                this.eObjectUUIDMapper.map((EObject)i.next());
            }
        }
    }

    protected abstract List<ModelDescriptor> loadModels();

    @Override
    public abstract ModelType loadModel(String var1);

    @Override
    public abstract ModelType attachModel(String var1);

    @Override
    public ModelType attachModel(String id, String name, EObject nativeModel) {
        ModelType xpdlModel = null;
        xpdlModel = nativeModel instanceof ModelType ? (ModelType)nativeModel : (ModelType)((BpmPackageBuilder)BpmModelBuilder.newBpmModel().withIdAndName(id, !StringUtils.isEmpty((String)name) ? name : id)).build();
        this.loadEObjectUUIDMap(xpdlModel);
        this.xpdlModels.put(id, xpdlModel);
        if (xpdlModel != nativeModel) {
            this.nativeModels.put(xpdlModel, nativeModel);
        }
        return xpdlModel;
    }

    @Override
    public abstract void saveModel(ModelType var1);

    @Override
    public abstract void deleteModel(ModelType var1);

    @Override
    public abstract void versionizeModel(ModelType var1);

    protected static class ModelDescriptor {
        public final String id;
        public final String fileName;
        public final EObject nativeModel;
        public final ModelType xpdlModel;

        public ModelDescriptor(String id, String fileName, EObject nativeModel, ModelType xpdlModel) {
            this.id = id;
            this.fileName = fileName;
            this.nativeModel = nativeModel;
            this.xpdlModel = xpdlModel;
        }
    }
}

