/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.strategy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.engine.api.runtime.DmsUtils;
import org.eclipse.stardust.engine.api.runtime.Document;
import org.eclipse.stardust.engine.api.runtime.DocumentInfo;
import org.eclipse.stardust.engine.api.runtime.DocumentManagementService;
import org.eclipse.stardust.engine.api.runtime.ServiceFactory;
import org.eclipse.stardust.engine.api.runtime.ServiceFactoryLocator;
import org.eclipse.stardust.model.xpdl.builder.strategy.AbstractModelManagementStrategy;
import org.eclipse.stardust.model.xpdl.builder.strategy.ModelManagementStrategy;
import org.eclipse.stardust.model.xpdl.builder.utils.WebModelerModelManager;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;

public class InMemoryModelManagementStrategy
extends AbstractModelManagementStrategy {
    private static final String MODELS_DIR = "/process-models/";
    private ServiceFactory serviceFactory;
    private DocumentManagementService documentManagementService;
    private List<ModelType> models = new ArrayList<ModelType>();

    public void registerModel(ModelType model) {
        this.models.add(model);
    }

    @Override
    public Map<String, ModelType> getModels() {
        return this.getModels(true);
    }

    @Override
    public List<AbstractModelManagementStrategy.ModelDescriptor> loadModels() {
        ArrayList result = CollectionUtils.newArrayList();
        for (ModelType model : this.models) {
            result.add(new AbstractModelManagementStrategy.ModelDescriptor(model.getId(), null, (EObject)model, model));
        }
        return result;
    }

    @Override
    public ModelType loadModel(String id) {
        for (ModelType model : this.models) {
            if (!model.getId().equalsIgnoreCase(id)) continue;
            return model;
        }
        return null;
    }

    @Override
    public ModelType attachModel(String id) {
        ModelType model = this.loadModel(id);
        this.models.add(model);
        return model;
    }

    @Override
    public void saveModel(ModelType model) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WebModelerModelManager manager = new WebModelerModelManager();
        manager.setModel(model);
        try {
            manager.save(URI.createURI((String)this.getModelFileName(model)), baos);
        }
        catch (IOException ex) {
            throw new InternalException("Unable to save model '" + model.getId() + "'", (Throwable)ex);
        }
        byte[] content = baos.toByteArray();
        DocumentManagementService service = this.getDocumentManagementService();
        Document document = service.getDocument(MODELS_DIR + model.getName() + ".xpdl");
        if (null == document) {
            DocumentInfo info = DmsUtils.createDocumentInfo((String)(model.getName() + ".xpdl"));
            info.setOwner(this.getServiceFactory().getWorkflowService().getUser().getAccount());
            info.setContentType("text/xhtml");
            document = service.createDocument(MODELS_DIR, info, content, null);
            service.versionDocument(document.getId(), null, null);
        } else {
            service.updateDocument(document, content, null, false, null, null, false);
        }
    }

    @Override
    public void deleteModel(ModelType model) {
        Document modelDocument = this.getDocumentManagementService().getDocument(MODELS_DIR + model.getName() + ".xpdl");
        if (modelDocument != null) {
            this.getDocumentManagementService().removeDocument(modelDocument.getId());
        }
        this.getModels().remove(model.getId());
    }

    @Override
    public void versionizeModel(ModelType model) {
    }

    private DocumentManagementService getDocumentManagementService() {
        if (this.documentManagementService == null) {
            this.documentManagementService = this.getServiceFactory().getDocumentManagementService();
        }
        return this.documentManagementService;
    }

    private ServiceFactory getServiceFactory() {
        if (this.serviceFactory == null) {
            this.serviceFactory = ServiceFactoryLocator.get((String)"motu", (String)"motu");
        }
        return this.serviceFactory;
    }

    @Override
    public String getModelFileName(ModelType model) {
        return model.getId() + '.' + "xpdl";
    }

    @Override
    public String getModelFilePath(ModelType model) {
        return null;
    }

    @Override
    public ModelManagementStrategy.ModelUploadStatus uploadModelFile(String fileName, byte[] fileContent, boolean createNewVersion) {
        return null;
    }
}

