/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.utils;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ElementCopier {
    public static final CarnotWorkflowModelFactory F_CWM = CarnotWorkflowModelFactory.eINSTANCE;
    private ModelType target;
    private ModelType source;

    public ElementCopier(ModelType target, ModelType source) {
        this.target = target;
        this.source = source;
    }

    public EObject copy(EObject object) {
        Copier copier = new Copier();
        if (object instanceof DataType) {
            DataType copy = (DataType)copier.copy(object);
            DataTypeType type = ((DataType)object).getType();
            DataTypeType targetType = (DataTypeType)this.findInTarget((EObject)type);
            if (targetType != null) {
                copy.setType(targetType);
            }
            copier.copyReferences();
            this.target.getData().add((Object)copy);
            return copy;
        }
        if (object instanceof IModelParticipant) {
            IModelParticipant copy = (IModelParticipant)copier.copy(object);
            copier.copyReferences();
            if (object instanceof RoleType) {
                this.target.getRole().add((Object)((RoleType)copy));
            } else if (object instanceof OrganizationType) {
                this.target.getOrganization().add((Object)((OrganizationType)copy));
            } else if (object instanceof ConditionalPerformerType) {
                this.target.getConditionalPerformer().add((Object)((ConditionalPerformerType)copy));
            }
            return copy;
        }
        return null;
    }

    EObject findInTarget(EObject object) {
        if (object instanceof DataTypeType) {
            EList dataType = this.target.getDataType();
            for (DataTypeType dataTypeType : dataType) {
                if (!dataTypeType.getId().equals(((DataTypeType)object).getId())) continue;
                return dataTypeType;
            }
        }
        return null;
    }

    class Copier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 1L;

        Copier() {
        }

        public EObject copy(EObject object) {
            if (object instanceof XSDSchema) {
                XSDSchema original = (XSDSchema)object;
                XSDSchema clone = (XSDSchema)original.cloneConcreteComponent(true, false);
                Document doc = clone.updateDocument();
                if (original.getElement() != null) {
                    Element clonedElement = (Element)doc.importNode(original.getElement(), true);
                    doc.appendChild(clonedElement);
                    clone.setElement(clonedElement);
                }
                return clone;
            }
            return super.copy(object);
        }
    }
}

