/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.Direction;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.ErrorCase;
import org.eclipse.stardust.common.error.ObjectNotFoundException;
import org.eclipse.stardust.engine.api.runtime.BpmRuntimeError;
import org.eclipse.stardust.engine.core.pojo.data.JavaDataTypeUtils;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.engine.core.spi.extensions.model.AccessPoint;
import org.eclipse.stardust.engine.extensions.dms.data.DmsConstants;
import org.eclipse.stardust.model.xpdl.builder.BpmModelBuilder;
import org.eclipse.stardust.model.xpdl.builder.activity.BpmApplicationActivityBuilder;
import org.eclipse.stardust.model.xpdl.builder.activity.BpmManualActivityBuilder;
import org.eclipse.stardust.model.xpdl.builder.activity.BpmRouteActivityBuilder;
import org.eclipse.stardust.model.xpdl.builder.activity.BpmSubProcessActivityBuilder;
import org.eclipse.stardust.model.xpdl.builder.common.AbstractElementBuilder;
import org.eclipse.stardust.model.xpdl.builder.initializer.DataStructInitializer;
import org.eclipse.stardust.model.xpdl.builder.initializer.DmsDocumentInitializer;
import org.eclipse.stardust.model.xpdl.builder.initializer.PrimitiveDataInitializer;
import org.eclipse.stardust.model.xpdl.builder.initializer.SerializableDataInitializer;
import org.eclipse.stardust.model.xpdl.builder.model.BpmPackageBuilder;
import org.eclipse.stardust.model.xpdl.builder.participant.BpmConditionalPerformerBuilder;
import org.eclipse.stardust.model.xpdl.builder.participant.BpmOrganizationBuilder;
import org.eclipse.stardust.model.xpdl.builder.participant.BpmRoleBuilder;
import org.eclipse.stardust.model.xpdl.builder.process.BpmProcessDefinitionBuilder;
import org.eclipse.stardust.model.xpdl.builder.strategy.ModelManagementStrategy;
import org.eclipse.stardust.model.xpdl.builder.utils.DateUtils;
import org.eclipse.stardust.model.xpdl.builder.utils.ElementCopier;
import org.eclipse.stardust.model.xpdl.builder.utils.LaneParticipantUtil;
import org.eclipse.stardust.model.xpdl.builder.utils.NameIdUtilsExtension;
import org.eclipse.stardust.model.xpdl.builder.utils.PepperIconFactory;
import org.eclipse.stardust.model.xpdl.builder.utils.WebModelerConnectionManager;
import org.eclipse.stardust.model.xpdl.builder.variable.BpmDocumentVariableBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.BpmPrimitiveVariableBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.BpmStructVariableBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.CamelApplicationBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.DocumentAccessPointBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.ExternalWebApplicationApplicationBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.MessageTransformationApplicationBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.PrimitiveAccessPointBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.StructAccessPointBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.WebserviceApplicationBuilder;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.AnnotationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationTypeType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.EndEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IAccessPointOwner;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IFlowObjectSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.IdRef;
import org.eclipse.stardust.model.xpdl.carnot.IntermediateEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.model.xpdl.carnot.ParameterMappingType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TextType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerTypeType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.extensions.ExtensionsFactory;
import org.eclipse.stardust.model.xpdl.carnot.extensions.FormalParameterMappingsType;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeUtils;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataInitializer;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.IconFactory;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.util.IdFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.BasicTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.DataTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.DeclaredTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributeType;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParameterType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParametersType;
import org.eclipse.stardust.model.xpdl.xpdl2.ModeType;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.descriptors.ReplaceEObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.descriptors.ReplaceModelElementDescriptor;
import org.eclipse.stardust.modeling.repository.common.util.ImportUtils;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class ModelBuilderFacade {
    private static final String TIMESTAMP_TYPE = "Timestamp";
    private static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;
    private ModelManagementStrategy modelManagementStrategy;

    public ModelBuilderFacade(ModelManagementStrategy modelManagementStrategy) {
        this.modelManagementStrategy = modelManagementStrategy;
    }

    public ModelBuilderFacade() {
    }

    public ModelManagementStrategy getModelManagementStrategy() {
        return this.modelManagementStrategy;
    }

    public void setTeamLeader(OrganizationType organization, RoleType role) {
        if (null != organization.getTeamLead()) {
            this.addOrganizationParticipant(organization, (IModelParticipant)organization.getTeamLead());
        }
        organization.setTeamLead(role);
        if (null != role) {
            EList participants = organization.getParticipant();
            ParticipantType removeType = null;
            for (ParticipantType participant : participants) {
                if (!participant.getParticipant().getId().equals(role.getId())) continue;
                removeType = participant;
            }
            if (removeType != null) {
                participants.remove(removeType);
            }
        }
    }

    public void addOrganizationParticipant(OrganizationType organization, IModelParticipant participant) {
        ParticipantType participantType = AbstractElementBuilder.F_CWM.createParticipantType();
        participantType.setParticipant(participant);
        organization.getParticipant().add((Object)participantType);
    }

    public static List<OrganizationType> getParentOrganizations(ModelType model, IModelParticipant participant) {
        ArrayList<OrganizationType> belongsTo = new ArrayList<OrganizationType>();
        for (OrganizationType org : model.getOrganization()) {
            for (ParticipantType pt : org.getParticipant()) {
                if (!participant.equals(pt.getParticipant())) continue;
                belongsTo.add(org);
            }
        }
        return belongsTo;
    }

    public TypeDeclarationType createTypeDeclaration(ModelType model, String typeID, String typeName) {
        TypeDeclarationType structuredDataType = XpdlFactory.eINSTANCE.createTypeDeclarationType();
        structuredDataType.setName(typeName);
        if (StringUtils.isEmpty((String)typeID)) {
            typeID = NameIdUtilsExtension.createIdFromName((String)typeName);
        }
        structuredDataType.setId(typeID);
        SchemaTypeType schema = XpdlFactory.eINSTANCE.createSchemaTypeType();
        structuredDataType.setSchemaType(schema);
        XSDSchema xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
        xsdSchema.getQNamePrefixToNamespaceMap().put("xsd", "http://www.w3.org/2001/XMLSchema");
        xsdSchema.setSchemaForSchemaQNamePrefix("xsd");
        xsdSchema.setTargetNamespace(TypeDeclarationUtils.computeTargetNamespace((ModelType)model, (String)structuredDataType.getId()));
        String prefix = TypeDeclarationUtils.computePrefix((String)structuredDataType.getId(), xsdSchema.getQNamePrefixToNamespaceMap().keySet());
        xsdSchema.getQNamePrefixToNamespaceMap().put(prefix, xsdSchema.getTargetNamespace());
        xsdSchema.setSchemaLocation("urn:internal:" + structuredDataType.getId());
        schema.setSchema(xsdSchema);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        xsdComplexTypeDefinition.setName(structuredDataType.getId());
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        XSDModelGroup modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        particle.setContent((XSDParticleContent)modelGroup);
        modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)particle);
        xsdSchema.getContents().add((Object)xsdComplexTypeDefinition);
        XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElementDeclaration.setName(structuredDataType.getId());
        xsdElementDeclaration.setTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdSchema.getContents().add((Object)xsdElementDeclaration);
        schema.getSchema().updateElement(true);
        model.getTypeDeclarations().getTypeDeclaration().add((Object)structuredDataType);
        Resource o = structuredDataType.getSchema().eResource();
        return structuredDataType;
    }

    public FormalParameterType createPrimitiveParameter(ProcessDefinitionType processInterface, DataType data, String id, String name, String primitiveTypeID, ModeType mode) {
        XpdlFactory xpdlFactory = XpdlPackage.eINSTANCE.getXpdlFactory();
        FormalParameterType parameterType = this.createFormalParameter(processInterface, id, name, mode, xpdlFactory);
        FormalParameterMappingsType parameterMappingsType = processInterface.getFormalParameterMappings();
        if (parameterMappingsType == null) {
            parameterMappingsType = ExtensionsFactory.eINSTANCE.createFormalParameterMappingsType();
        }
        DataTypeType dataTypeType = XpdlFactory.eINSTANCE.createDataTypeType();
        BasicTypeType basicType = xpdlFactory.createBasicTypeType();
        if (!StringUtils.isEmpty((String)primitiveTypeID)) {
            basicType.setType(this.getPrimitiveType(primitiveTypeID));
        }
        dataTypeType.setBasicType(basicType);
        parameterType.setDataType(dataTypeType);
        String typeId = "primitive";
        dataTypeType.setCarnotType(typeId);
        if (data != null) {
            parameterMappingsType.setMappedData(parameterType, data);
        }
        processInterface.setFormalParameterMappings(parameterMappingsType);
        return parameterType;
    }

    public void setDataForFormalParameter(ProcessDefinitionType processInterface, String parameterID, DataType data) {
        FormalParameterType parameterType = processInterface.getFormalParameters().getFormalParameter(parameterID);
        if (parameterType != null) {
            processInterface.getFormalParameterMappings().setMappedData(parameterType, data);
        }
    }

    public FormalParameterType createStructuredParameter(ProcessDefinitionType processInterface, DataType data, String id, String name, String structTypeFullID, ModeType mode) {
        XpdlFactory xpdlFactory = XpdlPackage.eINSTANCE.getXpdlFactory();
        FormalParameterType parameterType = this.createFormalParameter(processInterface, id, name, mode, xpdlFactory);
        DataTypeType dataTypeType = xpdlFactory.createDataTypeType();
        String typeId = "struct";
        parameterType.setDataType(dataTypeType);
        dataTypeType.setCarnotType(typeId);
        String refModelId = null;
        String structTypeId = null;
        String[] splittedIds = structTypeFullID.split(":");
        if (splittedIds.length > 1) {
            refModelId = splittedIds[0];
            structTypeId = splittedIds[1];
        } else {
            structTypeId = splittedIds[0];
        }
        ModelType model = ModelUtils.findContainingModel((EObject)processInterface);
        if (refModelId == null || model != null && refModelId.equals(model.getId())) {
            DeclaredTypeType declaredType = xpdlFactory.createDeclaredTypeType();
            declaredType.setId(structTypeId);
            dataTypeType.setDeclaredType(declaredType);
        } else if (model != null) {
            ModelType ref = this.findModel(refModelId);
            this.updateReferences(model, ref);
            ExternalReferenceType extRef = xpdlFactory.createExternalReferenceType();
            extRef.setLocation(refModelId);
            extRef.setXref(structTypeId);
            dataTypeType.setExternalReference(extRef);
        }
        FormalParameterMappingsType parameterMappingsType = processInterface.getFormalParameterMappings();
        if (parameterMappingsType == null) {
            parameterMappingsType = ExtensionsFactory.eINSTANCE.createFormalParameterMappingsType();
        }
        if (data != null) {
            parameterMappingsType.setMappedData(parameterType, data);
        }
        processInterface.setFormalParameterMappings(parameterMappingsType);
        return parameterType;
    }

    private FormalParameterType createFormalParameter(ProcessDefinitionType processInterface, String id, String name, ModeType mode, XpdlFactory xpdlFactory) {
        FormalParameterType parameterType;
        FormalParametersType parametersType;
        boolean forceSuffix = false;
        if (StringUtils.isEmpty((String)name.trim())) {
            if (StringUtils.isEmpty((String)id.trim())) {
                name = "FormalParameter";
                forceSuffix = true;
            } else {
                name = id;
            }
        }
        if ((parametersType = processInterface.getFormalParameters()) == null) {
            parametersType = xpdlFactory.createFormalParametersType();
            processInterface.setFormalParameters(parametersType);
        }
        if ((parameterType = parametersType.getFormalParameter(id)) == null) {
            parameterType = xpdlFactory.createFormalParameterType();
            parametersType.addFormalParameter(parameterType);
        }
        IdFactory idFactory = new IdFactory(null, name.trim(), XpdlPackage.eINSTANCE.getFormalParameterType(), (EStructuralFeature)XpdlPackage.eINSTANCE.getFormalParameterType_Id(), (EStructuralFeature)XpdlPackage.eINSTANCE.getFormalParameterType_Name());
        List existing = CollectionUtils.copyList((List)parametersType.getFormalParameter());
        existing.remove(parameterType);
        idFactory.computeNames(existing, forceSuffix);
        id = idFactory.getId();
        name = idFactory.getName();
        if (!id.equals(parameterType.getId())) {
            parameterType.setId(id);
        }
        if (!name.equals(parameterType.getName())) {
            parameterType.setName(name);
        }
        if (!CompareHelper.areEqual((Object)mode, (Object)parameterType.getMode())) {
            parameterType.setMode(mode);
        }
        return parameterType;
    }

    public FormalParameterType createDocumentParameter(ProcessDefinitionType processInterface, DataType data, String id, String name, String structTypeFullID, ModeType mode) {
        XpdlFactory xpdlFactory = XpdlPackage.eINSTANCE.getXpdlFactory();
        FormalParameterType parameterType = this.createFormalParameter(processInterface, id, name, mode, xpdlFactory);
        DataTypeType dataTypeType = xpdlFactory.createDataTypeType();
        String typeId = "dmsDocument";
        parameterType.setDataType(dataTypeType);
        dataTypeType.setCarnotType(typeId);
        DeclaredTypeType declaredType = xpdlFactory.createDeclaredTypeType();
        declaredType.setId(this.stripFullId(structTypeFullID));
        dataTypeType.setDeclaredType(declaredType);
        FormalParameterMappingsType parameterMappingsType = processInterface.getFormalParameterMappings();
        if (parameterMappingsType == null) {
            parameterMappingsType = ExtensionsFactory.eINSTANCE.createFormalParameterMappingsType();
        }
        if (data != null) {
            parameterMappingsType.setMappedData(parameterType, data);
        }
        processInterface.setFormalParameterMappings(parameterMappingsType);
        return parameterType;
    }

    public AccessPoint createJavaAccessPoint(String id, String name, String clazz, Direction direction, boolean browsable, Object characteristics) {
        if (clazz == null) {
            clazz = "java.util.Map";
        }
        return JavaDataTypeUtils.createIntrinsicAccessPoint((String)id, (String)name, (String)clazz, (Direction)direction, (boolean)browsable, (Object)characteristics);
    }

    public AccessPointType createPrimitiveAccessPoint(IAccessPointOwner application, String id, String name, String primaryDataTypeID, String direction) {
        return (AccessPointType)((PrimitiveAccessPointBuilder)BpmModelBuilder.newPrimitiveAccessPoint(application).withIdAndName(id, name)).withType(primaryDataTypeID).withDirection(direction).build();
    }

    public AccessPointType createStructuredAccessPoint(IAccessPointOwner application, String id, String name, String structTypeFullID, String direction) {
        return (AccessPointType)((StructAccessPointBuilder)BpmModelBuilder.newStructuredAccessPoint(application).withIdAndName(id, name)).withType(structTypeFullID).withDirection(direction).build();
    }

    public AccessPointType createDocumentAccessPoint(IAccessPointOwner application, String id, String name, String direction) {
        return (AccessPointType)((DocumentAccessPointBuilder)BpmModelBuilder.newDocumentAccessPoint(application).withIdAndName(id, name)).withDirection(direction).build();
    }

    public void setProcessImplementation(ProcessDefinitionType processInterface, ProcessDefinitionType processImplementation) {
        ModelType interfaceModel = ModelUtils.findContainingModel((EObject)processInterface);
        ModelType implementationModel = ModelUtils.findContainingModel((EObject)processImplementation);
        ExternalPackage packageRef = implementationModel.getExternalPackages().getExternalPackage(interfaceModel.getId());
        IdRef idRef = CarnotWorkflowModelFactory.eINSTANCE.createIdRef();
        idRef.setRef(processInterface.getId());
        idRef.setPackageRef(packageRef);
        processImplementation.setExternalRef(idRef);
        FormalParameterMappingsType parameterMappings = ExtensionsFactory.eINSTANCE.createFormalParameterMappingsType();
        FormalParametersType referencedParametersType = processInterface.getFormalParameters();
        FormalParametersType formalParameters = XpdlFactory.eINSTANCE.createFormalParametersType();
        for (FormalParameterType referencedParameterType : referencedParametersType.getFormalParameter()) {
            FormalParameterType parameterType = ModelUtils.cloneFormalParameterType((FormalParameterType)referencedParameterType, null);
            formalParameters.addFormalParameter(parameterType);
            parameterMappings.setMappedData(parameterType, null);
        }
        processImplementation.setFormalParameters(formalParameters);
        processImplementation.setFormalParameterMappings(parameterMappings);
    }

    public void setFormalParameter(ProcessDefinitionType implementingProcess, String parameterID, DataType dataType) {
        FormalParameterType formalParameterType = implementingProcess.getFormalParameters().getFormalParameter(parameterID);
        implementingProcess.getFormalParameterMappings().setMappedData(formalParameterType, dataType);
    }

    public DataType createDocumentData(ModelType model, String dataID, String dataName, String typeDeclarationID) {
        ModelType typeDeclarationModel = null;
        String sourceModelID = null;
        BpmDocumentVariableBuilder documentVariable = BpmModelBuilder.newDocumentVariable(model);
        if (!StringUtils.isEmpty((String)typeDeclarationID)) {
            sourceModelID = this.getModelId(typeDeclarationID);
            if (sourceModelID != null) {
                typeDeclarationModel = this.getModelManagementStrategy().getModels().get(sourceModelID);
            }
            typeDeclarationID = this.stripFullId(typeDeclarationID);
            documentVariable.setTypeDeclarationModel(typeDeclarationModel);
            documentVariable.setTypeDeclaration(typeDeclarationID);
        }
        DataType data = (DataType)((BpmDocumentVariableBuilder)documentVariable.withIdAndName(dataID, dataName)).build();
        return data;
    }

    public DataType createStructuredData(ModelType model, String dataID, String dataName, String typeFullID) {
        String sourceModelID = this.getModelId(typeFullID);
        ModelType typeDeclarationModel = this.getModelManagementStrategy().getModels().get(sourceModelID);
        BpmStructVariableBuilder structVariable = BpmModelBuilder.newStructVariable(model);
        structVariable.setTypeDeclarationModel(typeDeclarationModel);
        String[] ids = typeFullID.split(":");
        String typeValue = null;
        if (ids.length > 1) {
            typeValue = this.stripFullId(typeFullID);
        }
        DataType data = (DataType)((BpmStructVariableBuilder)structVariable.withIdAndName(dataID, dataName)).ofType(typeValue).build();
        return data;
    }

    public void convertDataType(DataType data, String targetTypeID) {
        if (data.getType().getId().equals(targetTypeID)) {
            return;
        }
        data.getAttribute().clear();
        ModelType model = ModelUtils.findContainingModel((EObject)data);
        data.setType((org.eclipse.stardust.model.xpdl.carnot.DataTypeType)ModelUtils.findIdentifiableElement((List)model.getDataType(), (String)targetTypeID));
        IDataInitializer init = this.getInitializer(targetTypeID);
        init.initialize(data, (List)data.getAttribute());
    }

    public void updatePrimitiveData(DataType data, String primitiveTypeID) {
        AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:type", (String)Type.class.getName(), (String)primitiveTypeID);
    }

    public void updateStructuredDataType(DataType data, String typeFullID) {
        ModelType model = ModelUtils.findContainingModel((EObject)data);
        String sourceModelID = this.getModelId(typeFullID);
        ModelType typeDeclarationModel = this.getModelManagementStrategy().getModels().get(sourceModelID);
        if (typeDeclarationModel != null) {
            String declarationID = this.stripFullId(typeFullID);
            TypeDeclarationType typeDeclaration = this.findTypeDeclaration(typeFullID);
            if (sourceModelID.equals(model.getId())) {
                data.setExternalReference(null);
                AttributeType attribute = AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:dataType", (String)declarationID);
                ModelUtils.setReference((AttributeType)attribute, (ModelType)model, (String)"struct");
                AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", null);
            } else {
                String fileConnectionId = WebModelerConnectionManager.createFileConnection(model, typeDeclarationModel);
                String bundleId = "org.eclipse.stardust.modeling.core";
                URI uri = URI.createURI((String)("cnx://" + fileConnectionId + "/"));
                ReplaceEObjectDescriptor descriptor = new ReplaceEObjectDescriptor(MergeUtils.createQualifiedUri((URI)uri, (EObject)typeDeclaration, (boolean)true), (EObject)data, typeDeclaration.getId(), typeDeclaration.getName(), typeDeclaration.getDescription(), bundleId, null);
                AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:path:separator", (String)"/");
                AttributeUtil.setBooleanAttribute((IExtensibleElement)data, (String)"carnot:engine:data:bidirectional", (Boolean)true);
                AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", (String)descriptor.getURI().toString());
                ExternalReferenceType reference = XpdlFactory.eINSTANCE.createExternalReferenceType();
                if (typeDeclarationModel != null) {
                    reference.setLocation(ImportUtils.getPackageRef((IObjectDescriptor)descriptor, (ModelType)model, (ModelType)typeDeclarationModel).getId());
                }
                reference.setXref(declarationID);
                data.setExternalReference(reference);
            }
        }
    }

    public void updateDocumentDataType(DataType data, String typeFullID) {
        ModelType model = ModelUtils.findContainingModel((EObject)data);
        String sourceModelID = this.getModelId(typeFullID);
        ModelType typeDeclarationModel = this.getModelManagementStrategy().getModels().get(sourceModelID);
        if (typeDeclarationModel != null) {
            String qualifiedId = null;
            String declarationID = this.stripFullId(typeFullID);
            TypeDeclarationType typeDeclaration = this.findTypeDeclaration(typeFullID);
            if (sourceModelID.equals(model.getId())) {
                data.setExternalReference(null);
                AttributeType attribute = AttributeUtil.setAttribute((IExtensibleElement)data, (String)DmsConstants.RESOURCE_METADATA_SCHEMA_ATT, (String)declarationID);
                ModelUtils.setReference((AttributeType)attribute, (ModelType)model, (String)"struct");
                AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", null);
                qualifiedId = typeDeclaration.getId();
            } else {
                String fileConnectionId = WebModelerConnectionManager.createFileConnection(model, typeDeclarationModel);
                String bundleId = "org.eclipse.stardust.modeling.core";
                URI uri = URI.createURI((String)("cnx://" + fileConnectionId + "/"));
                ReplaceEObjectDescriptor descriptor = new ReplaceEObjectDescriptor(MergeUtils.createQualifiedUri((URI)uri, (EObject)typeDeclaration, (boolean)true), (EObject)data, typeDeclaration.getId(), typeDeclaration.getName(), typeDeclaration.getDescription(), bundleId, null);
                AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:path:separator", (String)"/");
                AttributeUtil.setBooleanAttribute((IExtensibleElement)data, (String)"carnot:engine:data:bidirectional", (Boolean)true);
                AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", (String)descriptor.getURI().toString());
                ExternalReferenceType reference = XpdlFactory.eINSTANCE.createExternalReferenceType();
                if (typeDeclarationModel != null) {
                    reference.setLocation(ImportUtils.getPackageRef((IObjectDescriptor)descriptor, (ModelType)model, (ModelType)typeDeclarationModel).getId());
                }
                reference.setXref(declarationID);
                data.setExternalReference(reference);
                qualifiedId = sourceModelID + "{" + typeDeclaration.getId() + "}";
            }
            AttributeUtil.setAttribute((IExtensibleElement)data, (String)DmsConstants.RESOURCE_METADATA_SCHEMA_ATT, (String)qualifiedId);
        }
    }

    public DataType createPrimitiveData(ModelType model, String dataID, String dataName, String primitiveTypeID) {
        Type type = null;
        if (primitiveTypeID.equals("string")) {
            type = Type.String;
        } else if (primitiveTypeID.equals("date")) {
            type = Type.Calendar;
        } else if (primitiveTypeID.equals("integer")) {
            type = Type.Integer;
        } else if (primitiveTypeID.equals("double")) {
            type = Type.Double;
        } else if (primitiveTypeID.equals("decimal")) {
            type = Type.Money;
        }
        DataType data = (DataType)((BpmPrimitiveVariableBuilder)BpmModelBuilder.newPrimitiveVariable(model).withIdAndName(dataID, dataName)).ofType(type).build();
        return data;
    }

    public DataType importData(ModelType model, String dataFullID) {
        DataType data = null;
        String dataModelId = this.getModelId(dataFullID);
        ModelType dataModel = this.getModelManagementStrategy().getModels().get(dataModelId);
        try {
            data = this.findData(dataModel, this.stripFullId(dataFullID));
        }
        catch (ObjectNotFoundException ex) {
            // empty catch block
        }
        if (data == null && dataFullID.endsWith("PROCESS_ATTACHMENTS")) {
            data = this.createProcessAttachementData(model);
        }
        if (!dataModelId.equals(model.getId())) {
            String fileConnectionId = WebModelerConnectionManager.createFileConnection(model, dataModel);
            String bundleId = "org.eclipse.stardust.modeling.core";
            URI uri = URI.createURI((String)("cnx://" + fileConnectionId + "/"));
            ModelType loadModel = this.getModelManagementStrategy().loadModel(dataModelId + ".xpdl");
            DataType dataCopy = this.findData(dataModel, this.stripFullId(dataFullID));
            ElementCopier copier = new ElementCopier(dataModel, null);
            dataCopy = (DataType)copier.copy((EObject)data);
            ReplaceModelElementDescriptor descriptor = new ReplaceModelElementDescriptor(uri, (IIdentifiableModelElement)dataCopy, bundleId, null, true);
            PepperIconFactory iconFactory = new PepperIconFactory();
            descriptor.importElements((IconFactory)iconFactory, model, true);
            data = this.findData(model, this.stripFullId(dataFullID));
        }
        return data;
    }

    public LaneSymbol createLane(ModelType model, ProcessDefinitionType processDefinition, String participantFullID, String laneID, String laneName, String orientationID, int xProperty, int yProperty, int widthProperty, int heightProperty, PoolSymbol parentSymbol) {
        LaneSymbol laneSymbol = AbstractElementBuilder.F_CWM.createLaneSymbol();
        laneSymbol.setName(laneName);
        if (StringUtils.isEmpty((String)laneID)) {
            laneID = NameIdUtilsExtension.createIdFromName(null, (EObject)laneSymbol);
        }
        laneSymbol.setId(laneID);
        parentSymbol.getLanes().add((Object)laneSymbol);
        laneSymbol.setParentPool(parentSymbol);
        ((PoolSymbol)((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols().get(0)).getChildLanes().add((Object)laneSymbol);
        laneSymbol.setXPos((long)xProperty);
        laneSymbol.setYPos((long)yProperty);
        laneSymbol.setWidth(widthProperty);
        laneSymbol.setHeight(heightProperty);
        if (orientationID != null && orientationID.equals("DIAGRAM_FLOW_ORIENTATION_HORIZONTAL")) {
            laneSymbol.setOrientation(OrientationType.HORIZONTAL_LITERAL);
        } else {
            laneSymbol.setOrientation(OrientationType.VERTICAL_LITERAL);
        }
        if (participantFullID != null) {
            String participantModelID = this.getModelId(participantFullID);
            if (StringUtils.isEmpty((String)participantModelID)) {
                participantModelID = model.getId();
            }
            ModelType participantModel = model;
            if (!participantModelID.equals(model.getId())) {
                participantModel = this.getModelManagementStrategy().getModels().get(participantModelID);
            }
            IModelParticipant modelParticipant = this.findParticipant(this.getModelManagementStrategy().getModels().get(participantModelID), this.stripFullId(participantFullID));
            if (!participantModelID.equals(model.getId())) {
                String fileConnectionId = WebModelerConnectionManager.createFileConnection(model, participantModel);
                String bundleId = "org.eclipse.stardust.modeling.core";
                URI uri = URI.createURI((String)("cnx://" + fileConnectionId + "/"));
                ModelType loadModel = this.getModelManagementStrategy().loadModel(participantModelID + ".xpdl");
                IModelParticipant participantCopy = this.findParticipant(participantModel, this.stripFullId(participantFullID));
                ElementCopier copier = new ElementCopier(participantModel, null);
                participantCopy = (IModelParticipant)copier.copy((EObject)modelParticipant);
                ReplaceModelElementDescriptor descriptor = new ReplaceModelElementDescriptor(uri, (IIdentifiableModelElement)participantCopy, bundleId, null, true);
                PepperIconFactory iconFactory = new PepperIconFactory();
                descriptor.importElements((IconFactory)iconFactory, model, true);
                modelParticipant = this.findParticipant(model, this.stripFullId(participantFullID));
            }
            LaneParticipantUtil.setParticipant(laneSymbol, modelParticipant);
        }
        return laneSymbol;
    }

    public ActivitySymbolType createActivitySymbol(ModelType model, ActivityType activity, ProcessDefinitionType processDefinition, String parentLaneID, int xProperty, int yProperty, int widthProperty, int heightProperty) {
        ActivitySymbolType activitySymbol = AbstractElementBuilder.F_CWM.createActivitySymbolType();
        LaneSymbol parentLaneSymbol = this.findLaneInProcess(processDefinition, parentLaneID);
        activitySymbol.setXPos((long)xProperty - parentLaneSymbol.getXPos());
        activitySymbol.setYPos((long)yProperty - parentLaneSymbol.getYPos());
        activitySymbol.setWidth(widthProperty);
        activitySymbol.setHeight(heightProperty);
        activitySymbol.setActivity(activity);
        activity.getActivitySymbols().add((Object)activitySymbol);
        ((DiagramType)processDefinition.getDiagram().get(0)).getActivitySymbol().add((Object)activitySymbol);
        parentLaneSymbol.getActivitySymbol().add((Object)activitySymbol);
        return activitySymbol;
    }

    public AnnotationSymbolType createAnnotationSymbol(ModelType model, ProcessDefinitionType processDefinition, String parentLaneID, int xProperty, int yProperty, int widthProperty, int heightProperty, String content) {
        AnnotationSymbolType annotationSymbol = AbstractElementBuilder.F_CWM.createAnnotationSymbolType();
        LaneSymbol parentLaneSymbol = this.findLaneInProcess(processDefinition, parentLaneID);
        annotationSymbol.setXPos((long)xProperty - parentLaneSymbol.getXPos());
        annotationSymbol.setYPos((long)yProperty - parentLaneSymbol.getYPos());
        annotationSymbol.setWidth(widthProperty);
        annotationSymbol.setHeight(heightProperty);
        if (StringUtils.isNotEmpty((String)content)) {
            TextType text = AbstractElementBuilder.F_CWM.createTextType();
            text.getMixed().add((Object)FeatureMapUtil.createRawTextEntry((String)content));
            annotationSymbol.setText(text);
        }
        ((DiagramType)processDefinition.getDiagram().get(0)).getAnnotationSymbol().add((Object)annotationSymbol);
        parentLaneSymbol.getAnnotationSymbol().add((Object)annotationSymbol);
        return annotationSymbol;
    }

    public AnnotationSymbolType findAnnotationSymbol(LaneSymbol parentLaneSymbol, Long annotationOId) {
        for (AnnotationSymbolType annSymbol : parentLaneSymbol.getAnnotationSymbol()) {
            if (!annotationOId.equals(annSymbol.getElementOid())) continue;
            return annSymbol;
        }
        return null;
    }

    public DataSymbolType createDataSymbol(ModelType model, DataType data, ProcessDefinitionType processDefinition, String parentLaneID, int xProperty, int yProperty, int widthProperty, int heightProperty) {
        DataSymbolType dataSymbol = AbstractElementBuilder.F_CWM.createDataSymbolType();
        LaneSymbol parentLaneSymbol = this.findLaneInProcess(processDefinition, parentLaneID);
        dataSymbol.setData(data);
        ((DiagramType)processDefinition.getDiagram().get(0)).getDataSymbol().add((Object)dataSymbol);
        data.getDataSymbols().add((Object)dataSymbol);
        dataSymbol.setXPos((long)xProperty - parentLaneSymbol.getXPos());
        dataSymbol.setYPos((long)yProperty - parentLaneSymbol.getYPos());
        dataSymbol.setWidth(widthProperty);
        dataSymbol.setHeight(heightProperty);
        parentLaneSymbol.getDataSymbol().add((Object)dataSymbol);
        return dataSymbol;
    }

    public RoleType createRole(ModelType model, String roleID, String roleName) {
        RoleType role = (RoleType)((BpmRoleBuilder)BpmModelBuilder.newRole(model).withIdAndName(roleID, roleName)).build();
        return role;
    }

    public ConditionalPerformerType createConditionalPerformer(ModelType model, String conditionalPerformerID, String conditionalPerformerName) {
        ConditionalPerformerType conditionalPerformer = (ConditionalPerformerType)((BpmConditionalPerformerBuilder)BpmModelBuilder.newConditionalPerformer(model).withIdAndName(conditionalPerformerID, conditionalPerformerName)).build();
        return conditionalPerformer;
    }

    public OrganizationType createOrganization(ModelType model, String orgID, String orgName) {
        OrganizationType org = (OrganizationType)((BpmOrganizationBuilder)BpmModelBuilder.newOrganization(model).withIdAndName(orgID, orgName)).build();
        return org;
    }

    public ApplicationType createApplication(ModelType model, String applicationID, String applicationName, String applicationTypeID) {
        if (applicationTypeID.equalsIgnoreCase("messageTransformationBean")) {
            return (ApplicationType)((MessageTransformationApplicationBuilder)BpmModelBuilder.newMessageTransformationApplication(model).withIdAndName(applicationID, applicationName)).build();
        }
        if (applicationTypeID.equalsIgnoreCase("externalWebApp")) {
            return (ApplicationType)((ExternalWebApplicationApplicationBuilder)BpmModelBuilder.newExternalWebApplication(model).withIdAndName(applicationID, applicationName)).build();
        }
        if (applicationTypeID.equalsIgnoreCase("webservice")) {
            return (ApplicationType)((WebserviceApplicationBuilder)BpmModelBuilder.newWebserviceApplication(model).withIdAndName(applicationID, applicationName)).build();
        }
        if (applicationTypeID.equalsIgnoreCase("camelSpringProducerApplication")) {
            return (ApplicationType)((CamelApplicationBuilder)BpmModelBuilder.newCamelApplication(model).withIdAndName(applicationID, applicationName)).build();
        }
        return null;
    }

    public ActivityType createActivity(ModelType model, ProcessDefinitionType processDefinition, String activityType, String taskType, String activityID, String activityName, String participantFullID, String applicationFullID, String subProcessFullID) {
        ActivityType activity = null;
        if ("Task".equals(activityType)) {
            ModelBuilderFacade.setAttribute(activity, "taskType", taskType);
            if ("none".equals(taskType)) {
                activity = (ActivityType)((BpmRouteActivityBuilder)BpmModelBuilder.newRouteActivity(processDefinition).withIdAndName(activityID, activityName)).build();
                activity.setImplementation(ActivityImplementationType.ROUTE_LITERAL);
            } else if ("manual".equals(taskType)) {
                activity = participantFullID != null ? (ActivityType)((BpmManualActivityBuilder)((BpmManualActivityBuilder)BpmModelBuilder.newManualActivity(processDefinition).withIdAndName(activityID, activityName)).havingDefaultPerformer(this.stripFullId(participantFullID))).build() : (ActivityType)((BpmManualActivityBuilder)BpmModelBuilder.newManualActivity(processDefinition).withIdAndName(activityID, activityName)).build();
                activity.setImplementation(ActivityImplementationType.MANUAL_LITERAL);
            } else if ("user".equals(taskType) || "service".equals(taskType) || "script".equals(taskType) || "send".equals(taskType) || "receive".equals(taskType) || "rule".equals(taskType)) {
                String stripFullId_ = this.getModelId(applicationFullID);
                if (StringUtils.isEmpty((String)stripFullId_)) {
                    stripFullId_ = model.getId();
                }
                ApplicationType application = this.getApplication(stripFullId_, this.stripFullId(applicationFullID));
                ModelType applicationModel = ModelUtils.findContainingModel((EObject)application);
                BpmApplicationActivityBuilder applicationActivity = BpmModelBuilder.newApplicationActivity(processDefinition);
                applicationActivity.setApplicationModel(applicationModel);
                BpmApplicationActivityBuilder activityBuilder = (BpmApplicationActivityBuilder)applicationActivity.withIdAndName(activityID, activityName);
                if (null != application) {
                    activityBuilder.invokingApplication(application);
                }
                activity = (ActivityType)activityBuilder.build();
                if ("user".equals(taskType) && participantFullID != null) {
                    activity.setPerformer(this.findParticipant(participantFullID));
                }
                activity.setImplementation(ActivityImplementationType.APPLICATION_LITERAL);
            }
        } else if ("Subprocess".equals(activityType)) {
            String stripFullId = this.getModelId(subProcessFullID);
            if (StringUtils.isEmpty((String)stripFullId)) {
                stripFullId = model.getId();
            }
            ProcessDefinitionType subProcessDefinition = this.findProcessDefinition(this.getModelManagementStrategy().getModels().get(stripFullId), this.stripFullId(subProcessFullID));
            ModelType subProcessModel = ModelUtils.findContainingModel((EObject)subProcessDefinition);
            BpmSubProcessActivityBuilder subProcessActivity = BpmModelBuilder.newSubProcessActivity(processDefinition);
            subProcessActivity.setSubProcessModel(subProcessModel);
            activity = (ActivityType)((BpmSubProcessActivityBuilder)subProcessActivity.withIdAndName(activityID, activityName)).invokingProcess(this.findProcessDefinition(this.getModelManagementStrategy().getModels().get(subProcessModel.getId()), this.stripFullId(subProcessFullID))).build();
        }
        return activity;
    }

    public ProcessDefinitionType createProcess(ModelType model, String processName, String processID) {
        ProcessDefinitionType processDefinition = (ProcessDefinitionType)((BpmProcessDefinitionBuilder)BpmModelBuilder.newProcessDefinition(model).withIdAndName(processID, processName)).build();
        DiagramType diagram = AbstractElementBuilder.F_CWM.createDiagramType();
        diagram.setMode(DiagramModeType.MODE_450_LITERAL);
        diagram.setOrientation(OrientationType.VERTICAL_LITERAL);
        diagram.setName("Diagram 1");
        PoolSymbol poolSymbol = AbstractElementBuilder.F_CWM.createPoolSymbol();
        diagram.getPoolSymbols().add((Object)poolSymbol);
        poolSymbol.setXPos(0L);
        poolSymbol.setYPos(0L);
        poolSymbol.setWidth(500);
        poolSymbol.setHeight(600);
        poolSymbol.setName("DEFAULT_POOL");
        poolSymbol.setId("DEFAULT_POOL");
        poolSymbol.setOrientation(OrientationType.VERTICAL_LITERAL);
        LaneSymbol laneSymbol = AbstractElementBuilder.F_CWM.createLaneSymbol();
        poolSymbol.getChildLanes().add((Object)laneSymbol);
        laneSymbol.setParentPool(poolSymbol);
        laneSymbol.setId("DefaultLane");
        laneSymbol.setName("Default Lane");
        laneSymbol.setXPos(10L);
        laneSymbol.setYPos(10L);
        laneSymbol.setWidth(480);
        laneSymbol.setHeight(580);
        laneSymbol.setOrientation(OrientationType.VERTICAL_LITERAL);
        processDefinition.getDiagram().add((Object)diagram);
        return processDefinition;
    }

    public ProcessDefinitionType createProcess(ModelType model, String id, String name, String defaultLaneName, String defaultPoolName) {
        ProcessDefinitionType processDefinition = (ProcessDefinitionType)((BpmProcessDefinitionBuilder)BpmModelBuilder.newProcessDefinition(model).withIdAndName(id, name)).build();
        DiagramType diagram = AbstractElementBuilder.F_CWM.createDiagramType();
        diagram.setMode(DiagramModeType.MODE_450_LITERAL);
        diagram.setOrientation(OrientationType.VERTICAL_LITERAL);
        diagram.setName("Diagram 1");
        PoolSymbol poolSymbol = AbstractElementBuilder.F_CWM.createPoolSymbol();
        diagram.getPoolSymbols().add((Object)poolSymbol);
        poolSymbol.setXPos(0L);
        poolSymbol.setYPos(0L);
        poolSymbol.setWidth(409);
        poolSymbol.setHeight(670);
        poolSymbol.setName(defaultPoolName);
        poolSymbol.setId("_default_pool__1");
        poolSymbol.setOrientation(OrientationType.VERTICAL_LITERAL);
        LaneSymbol laneSymbol = AbstractElementBuilder.F_CWM.createLaneSymbol();
        poolSymbol.getChildLanes().add((Object)laneSymbol);
        laneSymbol.setParentPool(poolSymbol);
        laneSymbol.setId("DefaultLane");
        laneSymbol.setName(defaultLaneName);
        laneSymbol.setXPos(12L);
        laneSymbol.setYPos(32L);
        laneSymbol.setWidth(375);
        laneSymbol.setHeight(poolSymbol.getHeight() - 70);
        laneSymbol.setOrientation(OrientationType.VERTICAL_LITERAL);
        processDefinition.getDiagram().add((Object)diagram);
        return processDefinition;
    }

    public DataPathType createDataPath() {
        return AbstractElementBuilder.F_CWM.createDataPathType();
    }

    public ModelType findModel(String modelId) {
        return this.getModelManagementStrategy().getModels().get(modelId);
    }

    public ProcessDefinitionType findProcessDefinition(ModelType model, String id) {
        for (ProcessDefinitionType processDefinition : model.getProcessDefinition()) {
            if (!processDefinition.getId().equals(id)) continue;
            return processDefinition;
        }
        throw new ObjectNotFoundException("Process Definition " + id + " does not exist.");
    }

    public ProcessDefinitionType findProcessDefinition(String processFullID) {
        String modelID = this.getModelId(processFullID);
        String processID = this.stripFullId(processFullID);
        ModelType model = this.findModel(modelID);
        for (ProcessDefinitionType processDefinition : model.getProcessDefinition()) {
            if (!processDefinition.getId().equals(processID)) continue;
            return processDefinition;
        }
        throw new ObjectNotFoundException("Process Definition " + processFullID + " does not exist.");
    }

    public ProcessDefinitionType getProcessDefinition(String modelId, String id) {
        return this.findProcessDefinition(this.findModel(modelId), id);
    }

    public ApplicationType findApplication(ModelType model, String id) {
        for (ApplicationType application : model.getApplication()) {
            if (!application.getId().equals(id)) continue;
            return application;
        }
        throw new ObjectNotFoundException("Application " + id + " does not exist.");
    }

    public ApplicationType findApplication(String fullApplicationID) {
        String modelID = this.getModelId(fullApplicationID);
        String applicationID = this.stripFullId(fullApplicationID);
        ModelType model = this.findModel(modelID);
        for (ApplicationType application : model.getApplication()) {
            if (!application.getId().equals(applicationID)) continue;
            return application;
        }
        throw new ObjectNotFoundException("Application " + fullApplicationID + " does not exist.");
    }

    public ApplicationTypeType findApplicationTypeType(ModelType model, String id) {
        ApplicationTypeType applicationMetaType;
        for (ApplicationTypeType applicationType : model.getApplicationType()) {
            if (!applicationType.getId().equals(id)) continue;
            return applicationType;
        }
        if (id.equals("camelConsumerApplication") && null == (applicationMetaType = (ApplicationTypeType)ModelUtils.findIdentifiableElement((List)model.getApplicationType(), (String)"camelConsumerApplication"))) {
            CarnotWorkflowModelFactory F_CWM = CarnotWorkflowModelFactory.eINSTANCE;
            applicationMetaType = F_CWM.createApplicationTypeType();
            applicationMetaType.setId("camelConsumerApplication");
            applicationMetaType.setName("Camel Consumer Application");
            applicationMetaType.setIsPredefined(true);
            applicationMetaType.setSynchronous(false);
            AttributeUtil.setAttribute((IExtensibleElement)applicationMetaType, (String)"carnot:engine:accessPointProvider", (String)"org.eclipse.stardust.engine.extensions.camel.app.CamelProducerSpringBeanAccessPointProvider");
            AttributeUtil.setAttribute((IExtensibleElement)applicationMetaType, (String)"carnot:engine:applicationInstance", (String)"org.eclipse.stardust.engine.extensions.camel.app.CamelProducerSpringBeanApplicationInstance");
            AttributeUtil.setAttribute((IExtensibleElement)applicationMetaType, (String)"carnot:engine:validator", (String)"org.eclipse.stardust.engine.extensions.camel.app.CamelProducerSpringBeanValidator");
            model.getApplicationType().add((Object)applicationMetaType);
        }
        throw new ObjectNotFoundException("Application type " + id + " does not exist.");
    }

    public static TriggerTypeType findTriggerType(ModelType model, String id) {
        CarnotWorkflowModelFactory F_CWM;
        TriggerTypeType triggerMetaType;
        for (TriggerTypeType triggerType : model.getTriggerType()) {
            if (!triggerType.getId().equals(id)) continue;
            return triggerType;
        }
        if (id.equals("camel")) {
            triggerMetaType = (TriggerTypeType)ModelUtils.findIdentifiableElement((List)model.getTriggerType(), (String)"camel");
            if (null == triggerMetaType) {
                F_CWM = CarnotWorkflowModelFactory.eINSTANCE;
                triggerMetaType = F_CWM.createTriggerTypeType();
                triggerMetaType.setId("camel");
                triggerMetaType.setName("Camel Trigger");
                triggerMetaType.setIsPredefined(true);
                triggerMetaType.setPullTrigger(false);
                AttributeUtil.setAttribute((IExtensibleElement)triggerMetaType, (String)"carnot:engine:validator", (String)"org.eclipse.stardust.engine.extensions.camel.trigger.validation.CamelTriggerValidator");
                AttributeUtil.setAttribute((IExtensibleElement)triggerMetaType, (String)"carnot:engine:runtimeValidator", (String)"org.eclipse.stardust.engine.extensions.camel.trigger.validation.CamelTriggerValidator");
                model.getTriggerType().add((Object)triggerMetaType);
                return triggerMetaType;
            }
        } else if (id.equals("scan") && null == (triggerMetaType = (TriggerTypeType)ModelUtils.findIdentifiableElement((List)model.getTriggerType(), (String)"scan"))) {
            F_CWM = CarnotWorkflowModelFactory.eINSTANCE;
            triggerMetaType = F_CWM.createTriggerTypeType();
            triggerMetaType.setId("scan");
            triggerMetaType.setName("Scan Trigger");
            triggerMetaType.setIsPredefined(true);
            triggerMetaType.setPullTrigger(false);
            AttributeUtil.setAttribute((IExtensibleElement)triggerMetaType, (String)"carnot:engine:validator", (String)"org.eclipse.stardust.engine.core.extensions.triggers.manual.ManualTriggerValidator");
            model.getTriggerType().add((Object)triggerMetaType);
            return triggerMetaType;
        }
        return null;
    }

    public ApplicationContextTypeType findApplicationContextTypeType(ModelType model, String id) {
        for (ApplicationContextTypeType applicationContextType : model.getApplicationContextType()) {
            if (!applicationContextType.getId().equals(id)) continue;
            return applicationContextType;
        }
        throw new ObjectNotFoundException("Application Context type " + id + " does not exist.");
    }

    public TypeDeclarationType findTypeDeclaration(ModelType model, String id) {
        TypeDeclarationType typeDeclaration = model.getTypeDeclarations().getTypeDeclaration(id);
        if (typeDeclaration == null) {
            throw new ObjectNotFoundException((ErrorCase)BpmRuntimeError.MDL_UNKNOWN_TYPE_DECLARATION_ID.raise((Object)id));
        }
        return typeDeclaration;
    }

    public TypeDeclarationType findTypeDeclaration(String fullTypeID) {
        String[] ids = fullTypeID.split(":");
        return this.findTypeDeclaration(this.findModel(ids[0]), ids[1]);
    }

    public org.eclipse.stardust.model.xpdl.carnot.DataTypeType findDataType(ModelType model, String id) {
        for (org.eclipse.stardust.model.xpdl.carnot.DataTypeType dataType : model.getDataType()) {
            if (!dataType.getId().equals(id)) continue;
            return dataType;
        }
        throw new ObjectNotFoundException("Data type " + id + " does not exist.");
    }

    public DataType findData(ModelType model, String id) {
        for (DataType data : model.getData()) {
            if (!data.getId().equals(id)) continue;
            return data;
        }
        throw new ObjectNotFoundException("Data " + id + " does not exist.");
    }

    public DataType findData(String dataFullID) {
        String modelID = this.getModelId(dataFullID);
        String dataID = this.stripFullId(dataFullID);
        ModelType model = this.findModel(modelID);
        for (DataType data : model.getData()) {
            if (!data.getId().equals(dataID)) continue;
            return data;
        }
        throw new ObjectNotFoundException("Data " + dataFullID + " does not exist.");
    }

    public IModelParticipant findParticipant(ModelType model, String id) {
        for (RoleType role : model.getRole()) {
            if (!role.getId().equals(id)) continue;
            return role;
        }
        for (OrganizationType organization : model.getOrganization()) {
            if (!organization.getId().equals(id)) continue;
            return organization;
        }
        for (ConditionalPerformerType conditionalPerformer : model.getConditionalPerformer()) {
            if (!conditionalPerformer.getId().equals(id)) continue;
            return conditionalPerformer;
        }
        throw new ObjectNotFoundException("Participant " + id + " does not exist.");
    }

    public IModelParticipant findParticipant(String fullParticipantID) {
        String modelID = this.getModelId(fullParticipantID);
        String participantID = this.stripFullId(fullParticipantID);
        ModelType model = this.findModel(modelID);
        for (RoleType role : model.getRole()) {
            if (!role.getId().equals(participantID)) continue;
            return role;
        }
        for (OrganizationType organization : model.getOrganization()) {
            if (!organization.getId().equals(participantID)) continue;
            return organization;
        }
        throw new ObjectNotFoundException("Participant " + fullParticipantID + " does not exist.");
    }

    public DataSymbolType findDataSymbol(DiagramType diagram, long oid) {
        for (DataSymbolType dataSymbol : diagram.getDataSymbol()) {
            if (dataSymbol.getElementOid() != oid) continue;
            return dataSymbol;
        }
        for (PoolSymbol poolSymbol : diagram.getPoolSymbols()) {
            for (LaneSymbol childLaneSymbol : poolSymbol.getChildLanes()) {
                DataSymbolType dataSymbol = this.findDataSymbolRecursively(childLaneSymbol, oid);
                if (dataSymbol == null) continue;
                return dataSymbol;
            }
        }
        throw new ObjectNotFoundException("Data Symbol " + oid + " does not exist.");
    }

    public DataSymbolType findDataSymbolRecursively(LaneSymbol laneSymbol, long oid) {
        for (DataSymbolType dataSymbol : laneSymbol.getDataSymbol()) {
            if (dataSymbol.getElementOid() != oid) continue;
            return dataSymbol;
        }
        for (LaneSymbol childLaneSymbol : laneSymbol.getChildLanes()) {
            DataSymbolType dataSymbol = this.findDataSymbolRecursively(childLaneSymbol, oid);
            if (dataSymbol == null) continue;
            return dataSymbol;
        }
        return null;
    }

    public ActivityType findActivity(ProcessDefinitionType processDefinition, String id) {
        for (ActivityType activity : processDefinition.getActivity()) {
            if (!activity.getId().equals(id)) continue;
            return activity;
        }
        throw new ObjectNotFoundException("Activity " + id + " does not exist.");
    }

    public static ActivitySymbolType findActivitySymbol(DiagramType diagram, long oid) {
        LaneSymbol laneSymbol = ModelBuilderFacade.findLaneContainingActivitySymbol(diagram, oid);
        if (laneSymbol != null) {
            return ModelBuilderFacade.findActivitySymbol(laneSymbol, oid);
        }
        return null;
    }

    public static ActivitySymbolType findActivitySymbol(LaneSymbol laneSymbol, long oid) {
        for (ActivitySymbolType activitySymbol : laneSymbol.getActivitySymbol()) {
            if (activitySymbol.getElementOid() != oid) continue;
            return activitySymbol;
        }
        return null;
    }

    public static LaneSymbol findLaneContainingActivitySymbol(DiagramType diagram, long oid) {
        for (PoolSymbol poolSymbol : diagram.getPoolSymbols()) {
            for (LaneSymbol laneSymbol : poolSymbol.getChildLanes()) {
                LaneSymbol containingLaneSymbol = ModelBuilderFacade.findLaneContainingActivitySymbolRecursively(laneSymbol, oid);
                if (containingLaneSymbol == null) continue;
                return containingLaneSymbol;
            }
        }
        return null;
    }

    public static LaneSymbol findLaneContainingActivitySymbolRecursively(LaneSymbol laneSymbol, long oid) {
        for (ActivitySymbolType activitySymbol : laneSymbol.getActivitySymbol()) {
            if (activitySymbol.getElementOid() != oid) continue;
            return laneSymbol;
        }
        for (LaneSymbol childLaneSymbol : laneSymbol.getChildLanes()) {
            LaneSymbol containingLaneSymbol = ModelBuilderFacade.findLaneContainingActivitySymbolRecursively(childLaneSymbol, oid);
            if (containingLaneSymbol == null) continue;
            return containingLaneSymbol;
        }
        return null;
    }

    public AnnotationSymbolType findAnnotationSymbol(DiagramType diagram, long oid) {
        LaneSymbol laneSymbol = this.findLaneContainingAnnotationSymbol(diagram, oid);
        if (laneSymbol != null) {
            return this.findAnnotationSymbol(laneSymbol, (Long)oid);
        }
        return null;
    }

    private LaneSymbol findLaneContainingAnnotationSymbol(DiagramType diagram, long oid) {
        for (PoolSymbol poolSymbol : diagram.getPoolSymbols()) {
            for (LaneSymbol laneSymbol : poolSymbol.getChildLanes()) {
                LaneSymbol containingLaneSymbol = this.findLaneContainingAnnotationSymbolRecursively(laneSymbol, oid);
                if (containingLaneSymbol == null) continue;
                return containingLaneSymbol;
            }
        }
        return null;
    }

    private LaneSymbol findLaneContainingAnnotationSymbolRecursively(LaneSymbol laneSymbol, long oid) {
        for (AnnotationSymbolType annotationSymbol : laneSymbol.getAnnotationSymbol()) {
            if (annotationSymbol.getElementOid() != oid) continue;
            return laneSymbol;
        }
        for (LaneSymbol childLaneSymbol : laneSymbol.getChildLanes()) {
            LaneSymbol containingLaneSymbol = this.findLaneContainingAnnotationSymbolRecursively(childLaneSymbol, oid);
            if (containingLaneSymbol == null) continue;
            return containingLaneSymbol;
        }
        return null;
    }

    public LaneSymbol findLaneInProcess(ProcessDefinitionType processDefinition, String id) {
        for (PoolSymbol poolSymbol : ((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols()) {
            for (LaneSymbol laneSymbol : poolSymbol.getChildLanes()) {
                LaneSymbol foundLaneSymbol = this.findLaneRecursively(laneSymbol, id);
                if (foundLaneSymbol == null) continue;
                return foundLaneSymbol;
            }
        }
        return null;
    }

    public static StartEventSymbol findStartEventSymbol(DiagramType diagram, long oid) {
        return ModelBuilderFacade.findSymbolRecursively(oid, StartEventSymbol.class, diagram, PKG_CWM.getISymbolContainer_StartEventSymbols());
    }

    public static StartEventSymbol findStartEventSymbol(LaneSymbol laneSymbol, long oid) {
        return ModelBuilderFacade.findSymbol(oid, StartEventSymbol.class, (ISymbolContainer)laneSymbol, PKG_CWM.getISymbolContainer_StartEventSymbols());
    }

    public static IntermediateEventSymbol findIntermediateEventSymbol(DiagramType diagram, long oid) {
        return ModelBuilderFacade.findSymbolRecursively(oid, IntermediateEventSymbol.class, diagram, PKG_CWM.getISymbolContainer_IntermediateEventSymbols());
    }

    public static IntermediateEventSymbol findIntermediateEventSymbol(LaneSymbol laneSymbol, long oid) {
        return ModelBuilderFacade.findSymbol(oid, IntermediateEventSymbol.class, (ISymbolContainer)laneSymbol, PKG_CWM.getISymbolContainer_IntermediateEventSymbols());
    }

    public static EndEventSymbol findEndEventSymbol(DiagramType diagram, long oid) {
        return ModelBuilderFacade.findSymbolRecursively(oid, EndEventSymbol.class, diagram, PKG_CWM.getISymbolContainer_EndEventSymbols());
    }

    public static EndEventSymbol findEndEventSymbol(ISymbolContainer container, long oid) {
        return ModelBuilderFacade.findSymbol(oid, EndEventSymbol.class, container, PKG_CWM.getISymbolContainer_EndEventSymbols());
    }

    public static <S extends IGraphicalObject> S findSymbolRecursively(long oid, Class<S> symbolType, DiagramType diagram, EReference containmentFeature) {
        S symbol = ModelBuilderFacade.findSymbol(oid, symbolType, (ISymbolContainer)diagram, containmentFeature);
        if (null != symbol) {
            return symbol;
        }
        for (PoolSymbol poolSymbol : diagram.getPoolSymbols()) {
            symbol = ModelBuilderFacade.findSymbolRecursively(oid, symbolType, poolSymbol, containmentFeature);
            if (null == symbol) continue;
            return symbol;
        }
        return null;
    }

    public static <S extends IGraphicalObject, C extends ISymbolContainer & ISwimlaneSymbol> S findSymbolRecursively(long oid, Class<S> symbolType, C container, EReference containmentFeature) {
        S symbol = ModelBuilderFacade.findSymbol(oid, symbolType, container, containmentFeature);
        if (null != symbol) {
            return symbol;
        }
        if (INodeSymbol.class.isAssignableFrom(symbolType)) {
            for (LaneSymbol childLaneSymbol : ((ISwimlaneSymbol)container).getChildLanes()) {
                symbol = ModelBuilderFacade.findSymbolRecursively(oid, symbolType, childLaneSymbol, containmentFeature);
                if (null == symbol) continue;
                return symbol;
            }
        }
        return null;
    }

    public static <S extends IGraphicalObject> S findSymbol(long oid, Class<S> symbolType, ISymbolContainer container, EReference containmentFeature) {
        if (containmentFeature.isMany()) {
            List containedSymbols = (List)container.eGet((EStructuralFeature)containmentFeature);
            for (IGraphicalObject symbol : containedSymbols) {
                if (symbol.getElementOid() != oid) continue;
                return (S)((IGraphicalObject)symbolType.cast(symbol));
            }
        } else {
            IGraphicalObject containedSymbol = (IGraphicalObject)container.eGet((EStructuralFeature)containmentFeature);
            if (null != containedSymbol && containedSymbol.getElementOid() == oid) {
                return (S)((IGraphicalObject)symbolType.cast(containedSymbol));
            }
        }
        return null;
    }

    public LaneSymbol findLaneRecursively(LaneSymbol laneSymbol, String id) {
        if (laneSymbol.getId().equals(id)) {
            return laneSymbol;
        }
        for (LaneSymbol childLaneSymbol : laneSymbol.getChildLanes()) {
            LaneSymbol foundLaneSymbol = this.findLaneRecursively(childLaneSymbol, id);
            if (foundLaneSymbol == null) continue;
            return foundLaneSymbol;
        }
        return null;
    }

    public LaneSymbol findLaneContainingActivitySymbol(ProcessDefinitionType processDefinition, ActivitySymbolType activitySymbol) {
        for (PoolSymbol poolSymbol : ((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols()) {
            for (LaneSymbol laneSymbol : poolSymbol.getChildLanes()) {
                LaneSymbol foundLaneSymbol = this.findLaneContainingActivitySymbolRecursively(laneSymbol, activitySymbol);
                if (foundLaneSymbol == null) continue;
                return foundLaneSymbol;
            }
        }
        throw new ObjectNotFoundException("Lane symbol containing Activity Symbol for Activity " + activitySymbol.getActivity().getId() + " cannot be found.");
    }

    public LaneSymbol findLaneContainingActivitySymbolRecursively(LaneSymbol laneSymbol, ActivitySymbolType activitySymbol) {
        if (laneSymbol.getActivitySymbol().contains((Object)activitySymbol)) {
            return laneSymbol;
        }
        for (LaneSymbol childLaneSymbol : laneSymbol.getChildLanes()) {
            LaneSymbol foundLaneSymbol = this.findLaneContainingActivitySymbolRecursively(childLaneSymbol, activitySymbol);
            if (foundLaneSymbol == null) continue;
            return foundLaneSymbol;
        }
        return null;
    }

    public static TransitionConnectionType findTransitionConnectionByModelOid(ProcessDefinitionType processDefinition, long oid) {
        DiagramType diagram = (DiagramType)processDefinition.getDiagram().get(0);
        TransitionConnectionType connection = ModelBuilderFacade.findSymbolRecursively(oid, TransitionConnectionType.class, diagram, PKG_CWM.getISymbolContainer_TransitionConnection());
        if (null != connection) {
            return connection;
        }
        throw new ObjectNotFoundException("Could not find Transition " + oid + ".");
    }

    public DataMappingConnectionType findDataMappingConnectionByModelOid(ProcessDefinitionType processDefinition, long oid) {
        for (DataMappingConnectionType dataMappingConnectionType : ((DiagramType)processDefinition.getDiagram().get(0)).getDataMappingConnection()) {
            if (dataMappingConnectionType.getElementOid() != oid) continue;
            return dataMappingConnectionType;
        }
        for (DataMappingConnectionType dataMappingConnectionType : ((PoolSymbol)((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols().get(0)).getDataMappingConnection()) {
            if (dataMappingConnectionType.getElementOid() != oid) continue;
            return dataMappingConnectionType;
        }
        throw new ObjectNotFoundException("Could not find " + oid + ".");
    }

    public PoolSymbol findPoolSymbolByElementOid(ProcessDefinitionType processDefinition, long oid) {
        for (PoolSymbol poolSymbol : ((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols()) {
            if (poolSymbol.getElementOid() != oid) continue;
            return poolSymbol;
        }
        throw new ObjectNotFoundException("Could not find Pool Symbol with OID " + oid + ".");
    }

    public LaneSymbol findLaneSymbolByElementOid(PoolSymbol poolSymbol, long oid) {
        for (LaneSymbol laneSymbol : poolSymbol.getLanes()) {
            if (laneSymbol.getElementOid() != oid) continue;
            return laneSymbol;
        }
        throw new ObjectNotFoundException("Could not find Lane Symbol with OID " + oid + ".");
    }

    public LaneSymbol findLaneSymbolById(ProcessDefinitionType processDefinition, String id) {
        for (PoolSymbol poolSymbol : ((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols()) {
            for (LaneSymbol laneSymbol : poolSymbol.getLanes()) {
                if (!laneSymbol.getId().equals(id)) continue;
                return laneSymbol;
            }
        }
        throw new ObjectNotFoundException("Could not find Lane Symbol with ID " + id + ".");
    }

    public ApplicationType getApplication(String modelId, String appId) {
        ModelType model = this.getModelManagementStrategy().getModels().get(modelId);
        EList apps = model.getApplication();
        for (ApplicationType a : apps) {
            if (!a.getId().equals(appId)) continue;
            return a;
        }
        return null;
    }

    public String createFullId(ModelType model, EObject modelElement) {
        if (null != model && null != modelElement) {
            if (modelElement instanceof IIdentifiableModelElement) {
                return model.getId() + ":" + ((IIdentifiableModelElement)modelElement).getId();
            }
            if (modelElement instanceof TypeDeclarationType) {
                return model.getId() + ":" + ((TypeDeclarationType)modelElement).getId();
            }
        }
        return null;
    }

    public String stripFullId(String fullId) {
        String[] ids = fullId.split(":");
        return ids[ids.length - 1];
    }

    public String getModelId(String fullId) {
        String[] ids = fullId.split(":");
        return ids[0];
    }

    private IDataInitializer getInitializer(String dataTypeTypeID) {
        if (dataTypeTypeID.equals("primitive")) {
            return new PrimitiveDataInitializer();
        }
        if (dataTypeTypeID.equals("struct")) {
            return new DataStructInitializer();
        }
        if (dataTypeTypeID.equals("serializable")) {
            return new SerializableDataInitializer();
        }
        if (dataTypeTypeID.equals("dmsDocument")) {
            return new DmsDocumentInitializer();
        }
        return null;
    }

    private TypeType getPrimitiveType(String primitiveTypeID) {
        TypeType type = null;
        if (primitiveTypeID.equals("string")) {
            type = TypeType.STRING_LITERAL;
        } else if (primitiveTypeID.equals("date")) {
            type = TypeType.DATETIME_LITERAL;
        } else if (primitiveTypeID.equals("int")) {
            type = TypeType.INTEGER_LITERAL;
        } else if (primitiveTypeID.equals("double")) {
            type = TypeType.FLOAT_LITERAL;
        } else if (primitiveTypeID.equals("decimal")) {
            type = TypeType.FLOAT_LITERAL;
        } else if (primitiveTypeID.equals("boolean")) {
            type = TypeType.BOOLEAN_LITERAL;
        } else if (primitiveTypeID.equals("Calendar")) {
            type = TypeType.DATETIME_LITERAL;
        } else if (primitiveTypeID.equals("long")) {
            type = TypeType.INTEGER_LITERAL;
        }
        return type;
    }

    public ContextType getApplicationContext(ApplicationType application, String contextTypeKey) {
        for (ContextType contextType : application.getContext()) {
            if (!contextType.getType().getId().equals(contextTypeKey)) continue;
            return contextType;
        }
        return null;
    }

    public ContextType createApplicationContext(ApplicationType application, String contextId) {
        ModelType model = ModelUtils.findContainingModel((EObject)application);
        ContextType context = AbstractElementBuilder.F_CWM.createContextType();
        ApplicationContextTypeType contextTypeType = null;
        try {
            contextTypeType = this.findApplicationContextTypeType(model, contextId);
        }
        catch (ObjectNotFoundException x) {
            // empty catch block
        }
        if (contextTypeType == null) {
            contextTypeType = AbstractElementBuilder.F_CWM.createApplicationContextTypeType();
            if ("externalWebApp".equals(contextId)) {
                contextTypeType.setName("External Web Application");
                contextTypeType.setId("externalWebApp");
                contextTypeType.setIsPredefined(true);
                model.getApplicationContextType().add((Object)contextTypeType);
            } else if ("application".equals(contextId)) {
                contextTypeType.setName("Noninteractive Application Context");
                contextTypeType.setId("application");
                contextTypeType.setIsPredefined(true);
                model.getApplicationContextType().add((Object)contextTypeType);
            } else if ("engine".equals(contextId)) {
                contextTypeType.setName("Engine Context");
                contextTypeType.setId("engine");
                contextTypeType.setIsPredefined(true);
                model.getApplicationContextType().add((Object)contextTypeType);
            } else if ("default".equals(contextId)) {
                contextTypeType.setName("Default Context");
                contextTypeType.setId("default");
                contextTypeType.setIsPredefined(true);
                model.getApplicationContextType().add((Object)contextTypeType);
            }
        }
        context.setType(contextTypeType);
        application.getContext().add((Object)context);
        return context;
    }

    public Class<?> getClassForType(String type) {
        if (type.equalsIgnoreCase("long")) {
            return Long.class;
        }
        if (type.equalsIgnoreCase("long")) {
            return Short.class;
        }
        if (type.equalsIgnoreCase("float")) {
            return Float.class;
        }
        if (type.equalsIgnoreCase("double")) {
            return Double.class;
        }
        if (type.equalsIgnoreCase("byte")) {
            return Byte.class;
        }
        if (type.equalsIgnoreCase("Calendar")) {
            return Calendar.class;
        }
        if (type.equalsIgnoreCase(TIMESTAMP_TYPE)) {
            return Calendar.class;
        }
        if (type.equalsIgnoreCase("int")) {
            return Integer.class;
        }
        if (type.equalsIgnoreCase("java.lang.Integer")) {
            return Integer.class;
        }
        if (type.equals("String")) {
            return String.class;
        }
        return String.class;
    }

    private String parseName(String path) {
        if (path.startsWith("typeDeclaration:")) {
            path = path.replaceAll("typeDeclaration:", "");
            path = path.replace("{", "");
            path = path.replace("}", " / ");
        }
        return path;
    }

    public ProcessDefinitionType setSubProcess(ActivityType activity, String processFullId) {
        ModelType processModel;
        ProcessDefinitionType process = this.getProcessDefinition(this.getModelId(processFullId), this.stripFullId(processFullId));
        ModelType model = ModelUtils.findContainingModel((EObject)activity);
        if (model.equals(processModel = ModelUtils.findContainingModel((EObject)process))) {
            activity.setImplementationProcess(process);
        } else {
            String fileConnectionId = WebModelerConnectionManager.createFileConnection(model, processModel);
            String bundleId = "org.eclipse.stardust.modeling.core";
            URI uri = URI.createURI((String)("cnx://" + fileConnectionId + "/"));
            ReplaceModelElementDescriptor descriptor = new ReplaceModelElementDescriptor(uri, (IIdentifiableModelElement)process, bundleId, null, true);
            AttributeUtil.setAttribute((IExtensibleElement)activity, (String)"carnot:connection:uri", (String)descriptor.getURI().toString());
            IdRef idRef = CarnotWorkflowModelFactory.eINSTANCE.createIdRef();
            idRef.setRef(process.getId());
            idRef.setPackageRef(ImportUtils.getPackageRef((IObjectDescriptor)descriptor, (ModelType)model, (ModelType)processModel));
            activity.setExternalRef(idRef);
            activity.setImplementationProcess(process);
        }
        return process;
    }

    public ApplicationType setApplication(ActivityType activity, String applicationFullId) {
        ModelType applicationModel;
        ApplicationType application = this.getApplication(this.getModelId(applicationFullId), this.stripFullId(applicationFullId));
        ModelType model = ModelUtils.findContainingModel((EObject)activity);
        if (model.equals(applicationModel = ModelUtils.findContainingModel((EObject)application))) {
            activity.setApplication(application);
        } else {
            String fileConnectionId = WebModelerConnectionManager.createFileConnection(model, applicationModel);
            String bundleId = "org.eclipse.stardust.modeling.core";
            URI uri = URI.createURI((String)("cnx://" + fileConnectionId + "/"));
            ReplaceModelElementDescriptor descriptor = new ReplaceModelElementDescriptor(uri, (IIdentifiableModelElement)application, bundleId, null, true);
            AttributeUtil.setAttribute((IExtensibleElement)activity, (String)"carnot:connection:uri", (String)descriptor.getURI().toString());
            IdRef idRef = CarnotWorkflowModelFactory.eINSTANCE.createIdRef();
            idRef.setRef(application.getId());
            idRef.setPackageRef(ImportUtils.getPackageRef((IObjectDescriptor)descriptor, (ModelType)model, (ModelType)applicationModel));
            activity.setExternalRef(idRef);
        }
        return application;
    }

    public static void setAttribute(Object element, String name, String value) {
        if (element instanceof Extensible) {
            ExtendedAttributeUtil.setAttribute((Extensible)((Extensible)element), (String)name, (String)value);
        }
        if (element instanceof IExtensibleElement) {
            AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)name, (String)value);
        }
    }

    public static void setTimestampAttribute(IExtensibleElement element, String name, String value) {
        AttributeUtil.setAttribute((IExtensibleElement)element, (String)name, (String)TIMESTAMP_TYPE, (String)value);
    }

    public Date getTimestampAttribute(IExtensibleElement element, String name) {
        Date date = null;
        String attributeValue = AttributeUtil.getAttributeValue((IExtensibleElement)element, (String)name);
        if (attributeValue != null) {
            try {
                date = DateUtils.getNonInteractiveDateFormat().parse(attributeValue);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return date;
    }

    public static void setBooleanAttribute(Object element, String name, boolean value) {
        if (element instanceof Extensible) {
            ExtendedAttributeUtil.setBooleanAttribute((Extensible)((Extensible)element), (String)name, (boolean)value);
        }
        if (element instanceof IExtensibleElement) {
            AttributeUtil.setBooleanAttribute((IExtensibleElement)((IExtensibleElement)element), (String)name, (Boolean)value);
        }
    }

    public boolean getBooleanAttribute(Object element, String name) {
        if (element instanceof Extensible) {
            return ExtendedAttributeUtil.getBooleanValue((Extensible)((Extensible)element), (String)name);
        }
        if (element instanceof IExtensibleElement) {
            return AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)element), (String)name);
        }
        return false;
    }

    public List getAttributes(Object element) {
        if (element instanceof Extensible && ((Extensible)element).getExtendedAttributes() != null) {
            return ((Extensible)element).getExtendedAttributes().getExtendedAttribute();
        }
        if (element instanceof IExtensibleElement) {
            return ((IExtensibleElement)element).getAttribute();
        }
        return new ArrayList();
    }

    public List getAttributes(Object element, boolean excludeBoolean, boolean booleanOnly) {
        if (excludeBoolean == booleanOnly && booleanOnly) {
            return new ArrayList();
        }
        List attributes = this.getAttributes(element);
        if (excludeBoolean == booleanOnly && !booleanOnly) {
            return attributes;
        }
        ArrayList filteredAttributes = new ArrayList();
        for (Object attribute : attributes) {
            if ((!booleanOnly || !this.isBooleanAttribute(attribute)) && (!excludeBoolean || this.isBooleanAttribute(attribute))) continue;
            filteredAttributes.add(attribute);
        }
        return filteredAttributes;
    }

    public Object getAttribute(Object element, String attributeName) {
        for (Object attribute : this.getAttributes(element)) {
            if (!this.getAttributeName(attribute).equals(attributeName)) continue;
            return attribute;
        }
        return null;
    }

    public String getAttributeName(Object attribute) {
        if (attribute instanceof ExtendedAttributeType) {
            return ((ExtendedAttributeType)attribute).getName();
        }
        if (attribute instanceof AttributeType) {
            return ((AttributeType)attribute).getName();
        }
        return null;
    }

    public String getAttributeValue(Object attribute) {
        if (attribute instanceof ExtendedAttributeType) {
            return ((ExtendedAttributeType)attribute).getValue();
        }
        if (attribute instanceof AttributeType) {
            return ((AttributeType)attribute).getValue();
        }
        return null;
    }

    public boolean isBooleanAttribute(Object attribute) {
        ExtendedAttributeType attributeType;
        if (attribute instanceof ExtendedAttributeType && ((attributeType = (ExtendedAttributeType)attribute).getValue().equalsIgnoreCase("true") || attributeType.getValue().equalsIgnoreCase("false"))) {
            return true;
        }
        return attribute instanceof AttributeType && (attributeType = (AttributeType)attribute).getType() != null && attributeType.getType().equalsIgnoreCase("Boolean");
    }

    public boolean isExternalReference(EObject modelElement) {
        if (modelElement != null) {
            String uri;
            if (modelElement.eIsProxy()) {
                return true;
            }
            if (modelElement instanceof DataType) {
                DataType dataType = (DataType)modelElement;
                if (dataType.eIsProxy()) {
                    return true;
                }
                if (dataType.getType() != null && dataType.getType().getId().equalsIgnoreCase("dmsDocument")) {
                    return false;
                }
                if (dataType.getType() != null && dataType.getType().getId().equalsIgnoreCase("struct")) {
                    return false;
                }
            }
            if (modelElement instanceof IExtensibleElement && AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)modelElement), (String)"carnot:connection:uri") != null) {
                String importString;
                uri = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)modelElement), (String)"carnot:connection:uri");
                ModelType model = ModelUtils.findContainingModel((EObject)modelElement);
                if (model == null) {
                    return false;
                }
                Connection connection = (Connection)model.getConnectionManager().findConnection(uri);
                return connection == null || (importString = connection.getAttribute("importByReference")) == null || !importString.equalsIgnoreCase("false");
            }
            if (modelElement instanceof Extensible && ExtendedAttributeUtil.getAttributeValue((Extensible)((Extensible)modelElement), (String)"carnot:connection:uri") != null) {
                String importString;
                uri = ExtendedAttributeUtil.getAttributeValue((Extensible)((Extensible)modelElement), (String)"carnot:connection:uri");
                ModelType model = ModelUtils.findContainingModel((EObject)modelElement);
                if (model == null) {
                    return false;
                }
                Connection connection = (Connection)model.getConnectionManager().findConnection(uri);
                return connection == null || (importString = connection.getAttribute("importByReference")) == null || !importString.equalsIgnoreCase("false");
            }
        }
        return false;
    }

    public void updateTeamLead(OrganizationType organization, String participantFullID) {
        if ("TO_BE_DEFINED".equals(participantFullID)) {
            this.setTeamLeader(organization, null);
            return;
        }
        ModelType model = ModelUtils.findContainingModel((EObject)organization);
        if (participantFullID != null) {
            String participantModelID = this.getModelId(participantFullID);
            if (StringUtils.isEmpty((String)participantModelID)) {
                participantModelID = model.getId();
            }
            ModelType participantModel = model;
            if (!participantModelID.equals(model.getId())) {
                participantModel = this.getModelManagementStrategy().getModels().get(participantModelID);
            }
            IModelParticipant modelParticipant = this.findParticipant(this.getModelManagementStrategy().getModels().get(participantModelID), this.stripFullId(participantFullID));
            if (!participantModelID.equals(model.getId())) {
                String fileConnectionId = WebModelerConnectionManager.createFileConnection(model, participantModel);
                String bundleId = "org.eclipse.stardust.modeling.core";
                URI uri = URI.createURI((String)("cnx://" + fileConnectionId + "/"));
                ModelType loadModel = this.getModelManagementStrategy().loadModel(participantModelID + ".xpdl");
                IModelParticipant participantCopy = this.findParticipant(participantModel, this.stripFullId(participantFullID));
                ElementCopier copier = new ElementCopier(participantModel, null);
                participantCopy = (IModelParticipant)copier.copy((EObject)modelParticipant);
                ReplaceModelElementDescriptor descriptor = new ReplaceModelElementDescriptor(uri, (IIdentifiableModelElement)participantCopy, bundleId, null, true);
                PepperIconFactory iconFactory = new PepperIconFactory();
                descriptor.importElements((IconFactory)iconFactory, model, true);
                modelParticipant = this.findParticipant(model, this.stripFullId(participantFullID));
            }
            this.setTeamLeader(organization, (RoleType)modelParticipant);
        }
    }

    public void setModified(ModelType modelType, String modified) {
        AttributeUtil.setAttribute((IExtensibleElement)modelType, (String)"ipp:model:modified", (String)modified);
    }

    public void setModified(ModelType modelType, Date modified) {
        AttributeUtil.setAttribute((IExtensibleElement)modelType, (String)"ipp:model:modified", (String)new Date().toString());
    }

    public String getModified(ModelType modelType) {
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)modelType, (String)"ipp:model:modified");
        if (attribute != null) {
            return this.convertDate(attribute.getValue());
        }
        return "unknown";
    }

    public ModelType createModel(String modelID, String modelName) {
        Map<String, ModelType> models = this.modelManagementStrategy.getModels(false);
        ArrayList<ModelType> ids = new ArrayList<ModelType>(models.values());
        ModelType model = (ModelType)((BpmPackageBuilder)BpmModelBuilder.newBpmModel().withIdAndName(modelID, modelName)).build();
        model.setConnectionManager((IConnectionManager)new WebModelerConnectionManager(model, this.modelManagementStrategy));
        if (StringUtils.isEmpty((String)modelID)) {
            modelID = NameIdUtilsExtension.createIdFromName((String)modelName, ids);
        }
        model.setId(modelID);
        return model;
    }

    public DataType createProcessAttachementData(ModelType model) {
        org.eclipse.stardust.model.xpdl.carnot.DataTypeType dataTypeType = (org.eclipse.stardust.model.xpdl.carnot.DataTypeType)ModelUtils.findIdentifiableElement((List)model.getDataType(), (String)"dmsDocumentList");
        DataType data = CarnotWorkflowModelFactory.eINSTANCE.createDataType();
        data.setId("PROCESS_ATTACHMENTS");
        data.setName("Process Attachments");
        data.setType(dataTypeType);
        model.getData().add((Object)data);
        AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:className", (String)List.class.getName());
        AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:data:bidirectional", (String)Boolean.TYPE.getName(), (String)Boolean.TRUE.toString());
        return data;
    }

    public ParameterMappingType createParameterMapping(TriggerType trigger, String parameter, String dataFullID, String dataPath) {
        ParameterMappingType mappingType = CarnotWorkflowModelFactory.eINSTANCE.createParameterMappingType();
        mappingType.setParameter(parameter);
        DataType dt = this.importData(ModelUtils.findContainingModel((EObject)trigger), dataFullID);
        mappingType.setData(dt);
        if (dataPath != null) {
            mappingType.setDataPath(dataPath);
        }
        trigger.getParameterMapping().add((Object)mappingType);
        return mappingType;
    }

    public String convertDate(String date) {
        ResourceBundle rb = ResourceBundle.getBundle("portal-common-messages");
        String format = rb.getString("portalFramework.formats.defaultDateTimeFormat");
        if (format == null) {
            format = "MM/dd/yy hh:mm a";
        }
        String pattern = "E MMM dd HH:mm:ss zzz yyyy";
        SimpleDateFormat instance = new SimpleDateFormat(pattern, Locale.ROOT);
        try {
            Date parse = instance.parse(date);
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.applyPattern(format);
            date = sdf.format(parse);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return date;
    }

    public TransitionType createTransition(ProcessDefinitionType processDefinition, ActivityType sourceActivity, ActivityType targetActivity, String id, String name, String description, boolean otherwise, String condition) {
        TransitionType transition = AbstractElementBuilder.F_CWM.createTransitionType();
        processDefinition.getTransition().add((Object)transition);
        transition.setFrom(sourceActivity);
        transition.setTo(targetActivity);
        if (StringUtils.isEmpty((String)id)) {
            id = UUID.randomUUID().toString();
        }
        transition.setId(id);
        transition.setName(name);
        if (otherwise) {
            transition.setCondition("OTHERWISE");
        } else {
            transition.setCondition("CONDITION");
            if (StringUtils.isEmpty((String)condition)) {
                condition = "true";
            }
            XmlTextNode expression = CarnotWorkflowModelFactory.eINSTANCE.createXmlTextNode();
            ModelUtils.setCDataString((FeatureMap)expression.getMixed(), (String)condition, (boolean)true);
            transition.setExpression(expression);
        }
        return transition;
    }

    public TransitionConnectionType createTransitionSymbol(ProcessDefinitionType processDefinition, IFlowObjectSymbol sourceActivitySymbol, IFlowObjectSymbol targetActivitySymbol, TransitionType transition, String fromAnchorOrientation, String toAnchorOrientation) {
        TransitionConnectionType transitionConnection = AbstractElementBuilder.F_CWM.createTransitionConnectionType();
        if (null != transition) {
            transition.getTransitionConnections().add((Object)transitionConnection);
            transitionConnection.setTransition(transition);
        }
        transitionConnection.setSourceNode((INodeSymbol)sourceActivitySymbol);
        transitionConnection.setTargetNode((INodeSymbol)targetActivitySymbol);
        transitionConnection.setSourceAnchor(fromAnchorOrientation);
        transitionConnection.setTargetAnchor(toAnchorOrientation);
        ((PoolSymbol)((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols().get(0)).getTransitionConnection().add((Object)transitionConnection);
        return transitionConnection;
    }

    private void deleteDuplicateConnections(long sourceOid, long targetOid, ProcessDefinitionType processDefinition) {
        ArrayList<TransitionConnectionType> tobeRemoved = new ArrayList<TransitionConnectionType>();
        EList transitionConnections = ((PoolSymbol)((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols().get(0)).getTransitionConnection();
        for (TransitionConnectionType transitionConnectionType : transitionConnections) {
            if (transitionConnectionType.getSourceActivitySymbol().getElementOid() != sourceOid || transitionConnectionType.getTargetActivitySymbol().getElementOid() != targetOid) continue;
            tobeRemoved.add(transitionConnectionType);
        }
        for (TransitionConnectionType transitionConnectionType : tobeRemoved) {
            transitionConnections.remove((Object)transitionConnectionType);
            processDefinition.getTransition().remove((Object)transitionConnectionType.getTransition());
        }
    }

    public void createControlFlowConnection(ProcessDefinitionType processDefinition, ActivitySymbolType sourceActivitySymbol, ActivitySymbolType targetActivitySymbol, String id, String name, String description, boolean otherwise, String condition, String fromAnchor, String toAnchor) {
        this.deleteDuplicateConnections(sourceActivitySymbol.getElementOid(), targetActivitySymbol.getElementOid(), processDefinition);
        TransitionType transition = this.createTransition(processDefinition, sourceActivitySymbol.getActivity(), targetActivitySymbol.getActivity(), id, name, description, otherwise, condition);
        this.createTransitionSymbol(processDefinition, (IFlowObjectSymbol)sourceActivitySymbol, (IFlowObjectSymbol)targetActivitySymbol, transition, fromAnchor, toAnchor);
    }

    public DataMappingConnectionType createDataFlowConnection(ProcessDefinitionType processDefinition, ActivitySymbolType activitySymbol, DataSymbolType dataSymbol, DirectionType direction, String fromAnchor, String toAnchor, String context, String activityAccessPointId) {
        DataType data = dataSymbol.getData();
        ActivityType activity = activitySymbol.getActivity();
        DataMappingType dataMapping = AbstractElementBuilder.F_CWM.createDataMappingType();
        DataMappingConnectionType dataMappingConnection = AbstractElementBuilder.F_CWM.createDataMappingConnectionType();
        dataMapping.setId(data.getId());
        dataMapping.setName(data.getName());
        dataMapping.setDirection(direction);
        dataMapping.setData(data);
        dataMapping.setContext(context);
        if (activityAccessPointId != null) {
            dataMapping.setApplicationAccessPoint(activityAccessPointId);
        }
        activity.getDataMapping().add((Object)dataMapping);
        ((PoolSymbol)((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols().get(0)).getDataMappingConnection().add((Object)dataMappingConnection);
        dataMappingConnection.setActivitySymbol(activitySymbol);
        dataMappingConnection.setDataSymbol(dataSymbol);
        activitySymbol.getDataMappings().add((Object)dataMappingConnection);
        dataSymbol.getDataMappings().add((Object)dataMappingConnection);
        dataMappingConnection.setSourceAnchor(fromAnchor);
        dataMappingConnection.setTargetAnchor(toAnchor);
        return dataMappingConnection;
    }

    public DataMappingConnectionType createDataFlowConnection(ProcessDefinitionType processDefinition, ActivitySymbolType activitySymbol, DataSymbolType dataSymbol, String inputContextId, String inputAccessPointId, String outputContextId, String outputAccessPointId, String fromAnchor, String toAnchor) {
        DataMappingType dataMapping;
        DataType data = dataSymbol.getData();
        ActivityType activity = activitySymbol.getActivity();
        if (inputAccessPointId != null) {
            dataMapping = AbstractElementBuilder.F_CWM.createDataMappingType();
            dataMapping.setId(data.getId());
            dataMapping.setName(data.getName());
            dataMapping.setDirection(DirectionType.IN_LITERAL);
            dataMapping.setData(data);
            dataMapping.setContext(inputContextId);
            dataMapping.setApplicationAccessPoint(inputAccessPointId);
            activity.getDataMapping().add((Object)dataMapping);
        }
        if (outputAccessPointId != null) {
            dataMapping = AbstractElementBuilder.F_CWM.createDataMappingType();
            dataMapping.setId(data.getId());
            dataMapping.setName(data.getName());
            dataMapping.setDirection(DirectionType.OUT_LITERAL);
            dataMapping.setData(data);
            dataMapping.setContext(outputContextId);
            dataMapping.setApplicationAccessPoint(outputAccessPointId);
            activity.getDataMapping().add((Object)dataMapping);
        }
        DataMappingConnectionType dataMappingConnection = AbstractElementBuilder.F_CWM.createDataMappingConnectionType();
        ((PoolSymbol)((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols().get(0)).getDataMappingConnection().add((Object)dataMappingConnection);
        dataMappingConnection.setActivitySymbol(activitySymbol);
        dataMappingConnection.setDataSymbol(dataSymbol);
        activitySymbol.getDataMappings().add((Object)dataMappingConnection);
        dataSymbol.getDataMappings().add((Object)dataMappingConnection);
        dataMappingConnection.setSourceAnchor(fromAnchor);
        dataMappingConnection.setTargetAnchor(toAnchor);
        return dataMappingConnection;
    }

    public AccessPointType findFirstApplicationAccessPointForType(ApplicationType application, DirectionType direction) {
        for (AccessPointType accessPoint : application.getAccessPoint()) {
            if (!accessPoint.getDirection().equals((Object)direction)) continue;
            return accessPoint;
        }
        return null;
    }

    public boolean isReadOnly(EObject element) {
        AttributeType attribute;
        return element != null && element instanceof ModelType && (attribute = AttributeUtil.getAttribute((IExtensibleElement)((ModelType)element), (String)"stardust:security:hash")) != null && attribute.getValue() != null && attribute.getValue().length() > 0;
    }

    public void updateReferences(ModelType model, ModelType ref) {
        String connId = WebModelerConnectionManager.createFileConnection(model, ref);
        ExternalPackages packs = model.getExternalPackages();
        if (packs == null) {
            packs = XpdlFactory.eINSTANCE.createExternalPackages();
            model.setExternalPackages(packs);
        }
        if (packs.getExternalPackage(ref.getId()) == null) {
            ExternalPackage pack = XpdlFactory.eINSTANCE.createExternalPackage();
            pack.setId(ref.getId());
            pack.setName(ref.getName());
            pack.setHref(ref.getId());
            ExtendedAttributeUtil.setAttribute((Extensible)pack, (String)"carnot:connection:uri", (String)("cnx://" + connId + "/"));
            EList packList = packs.getExternalPackage();
            packList.add(pack);
        }
    }
}

