/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.model.xpdl.builder.strategy.ModelManagementStrategy;
import org.eclipse.stardust.model.xpdl.builder.utils.WebModelerModelManager;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;

public class XpdlModelIoUtils {
    public static ModelType loadModel(byte[] modelXml, ModelManagementStrategy strategy) {
        try {
            return XpdlModelIoUtils.loadModel(new ByteArrayInputStream(modelXml), strategy);
        }
        catch (IOException ex) {
            throw new InternalException("Error loading model.", (Throwable)ex);
        }
    }

    public static ModelType loadModel(InputStream modelXml, ModelManagementStrategy strategy) throws IOException {
        WebModelerModelManager mgr = new WebModelerModelManager(strategy);
        mgr.load(URI.createURI((String)"temp.xpdl"), modelXml);
        return mgr.getModel();
    }

    public static ModelType loadModel(File modelXml, ModelManagementStrategy strategy) throws IOException {
        WebModelerModelManager mgr = new WebModelerModelManager(strategy);
        mgr.load(modelXml);
        return mgr.getModel();
    }

    public static byte[] saveModel(ModelType model) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WebModelerModelManager mgr = new WebModelerModelManager();
        mgr.setModel(model);
        try {
            mgr.save(URI.createURI((String)(model.getId() + "." + "xpdl")), baos);
        }
        catch (IOException ex) {
            throw new InternalException("Error saving model '" + model.getId() + "'", (Throwable)ex);
        }
        return baos.toByteArray();
    }
}

