/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.activity;

import org.eclipse.stardust.model.xpdl.builder.activity.AbstractActivityBuilder;
import org.eclipse.stardust.model.xpdl.builder.connectionhandler.IdRefHandler;
import org.eclipse.stardust.model.xpdl.builder.utils.ExternalReferenceUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.SubProcessModeType;

public class BpmSubProcessActivityBuilder
extends AbstractActivityBuilder<BpmSubProcessActivityBuilder> {
    ModelType subProcessModel;

    public ModelType getSubProcessModel() {
        return this.subProcessModel;
    }

    public void setSubProcessModel(ModelType subProcessModel) {
        this.subProcessModel = subProcessModel;
    }

    public BpmSubProcessActivityBuilder() {
        ((ActivityType)this.element).setImplementation(ActivityImplementationType.SUBPROCESS_LITERAL);
    }

    @Override
    protected ActivityType finalizeElement() {
        if (null == ((ActivityType)this.element).getSubProcessMode()) {
            ((ActivityType)this.element).setSubProcessMode(SubProcessModeType.SYNC_SHARED_LITERAL);
        }
        return super.finalizeElement();
    }

    public BpmSubProcessActivityBuilder invokingProcess(ProcessDefinitionType process) {
        ModelType processModel = this.getSubProcessModel();
        if (this.model.equals(processModel)) {
            IdRefHandler.cleanup((IIdentifiableModelElement)this.element);
            ((ActivityType)this.element).setImplementationProcess(process);
        } else {
            ExternalReferenceUtils.createExternalReferenceToProcess((ActivityType)this.element, process, this.model, processModel);
        }
        return this;
    }

    public BpmSubProcessActivityBuilder usingMode(SubProcessModeType subProcessMode) {
        ((ActivityType)this.element).setSubProcessMode(subProcessMode);
        return this;
    }
}

