/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.common;

import java.util.UUID;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.builder.common.AbstractIdentifiableElementBuilder;
import org.eclipse.stardust.model.xpdl.builder.connectionhandler.IdRefHandler;
import org.eclipse.stardust.model.xpdl.builder.utils.ElementBuilderUtils;
import org.eclipse.stardust.model.xpdl.builder.utils.NameIdUtilsExtension;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DescriptionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.IdRefOwner;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public abstract class AbstractModelElementBuilder<T extends IIdentifiableElement & IModelElement, B extends AbstractModelElementBuilder<T, B>>
extends AbstractIdentifiableElementBuilder<T, B> {
    protected ModelType model;
    private String generatedID = null;

    public String getGeneratedID() {
        return this.generatedID;
    }

    public AbstractModelElementBuilder(T element) {
        super(element);
    }

    @Override
    public T build() {
        Object element = super.build();
        this.generateId();
        EList<T> elementContainer = this.getElementContainer();
        if (null != elementContainer && !elementContainer.contains(element)) {
            elementContainer.add(element);
        }
        if (element instanceof DataType || element instanceof ApplicationType || element instanceof ActivityType || element instanceof IModelParticipant || element instanceof ProcessDefinitionType) {
            AttributeUtil.setAttribute((IExtensibleElement)((IIdentifiableModelElement)element), (String)"carnot:model:uuid", (String)UUID.randomUUID().toString());
        }
        if (element instanceof IdRefOwner || element instanceof DataType) {
            IdRefHandler.adapt((IIdentifiableModelElement)element);
        }
        return element;
    }

    @Override
    protected T finalizeElement() {
        Object element = super.finalizeElement();
        if (null == this.model) {
            throw new NullPointerException("Model must be set.");
        }
        return element;
    }

    public B inModel(ModelType model) {
        this.setModel(model);
        return (B)((AbstractModelElementBuilder)this.self());
    }

    public B forModel(ModelType model) {
        return this.inModel(model);
    }

    public ModelType model() {
        return this.model;
    }

    public B withDescription(String description) {
        if (!StringUtils.isEmpty((String)description)) {
            DescriptionType descriptor = F_CWM.createDescriptionType();
            ModelUtils.setCDataString((FeatureMap)descriptor.getMixed(), (String)description, (boolean)true);
            if (this.element instanceof IIdentifiableModelElement) {
                ((IIdentifiableModelElement)this.element).setDescription(descriptor);
            } else {
                throw new IllegalArgumentException("Unsupported proeprty: description");
            }
        }
        return (B)((AbstractModelElementBuilder)this.self());
    }

    protected void setModel(ModelType model) {
        if (null == this.model) {
            if (null != model) {
                this.model = model;
            }
        } else if (this.model != model) {
            throw new IllegalArgumentException("Model must only be set once.");
        }
    }

    @Override
    protected String deriveDefaultElementId() {
        if (null != this.getElementContainer()) {
            return ElementBuilderUtils.deriveDefaultId(this.element, this.getElementContainer(), this.getDefaultElementIdPrefix());
        }
        return null;
    }

    protected EList<? super T> getElementContainer() {
        return null;
    }

    protected abstract String getDefaultElementIdPrefix();

    protected void generateId() {
        if (this.generatedID == null) {
            this.generatedID = NameIdUtilsExtension.createIdFromName(this.getElementContainer(), (EObject)this.element);
            if (!StringUtils.isEmpty((String)((IIdentifiableElement)this.element).getId())) {
                this.generatedID = ((IIdentifiableElement)this.element).getId();
            } else if (!StringUtils.isEmpty((String)this.generatedID) && StringUtils.isEmpty((String)((IIdentifiableElement)this.element).getId())) {
                ((IIdentifiableElement)this.element).setId(this.generatedID);
            }
        }
    }
}

