/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.emf.ecore.EObject;

public class EObjectUUIDMapper {
    protected Map<UUID, EObject> uuidEObjectMap = new HashMap<UUID, EObject>();
    protected List<EObject> unmappedObjects = new ArrayList<EObject>();

    public String map(EObject obj) {
        UUID uuid = UUID.randomUUID();
        this.uuidEObjectMap.put(uuid, obj);
        this.unmappedObjects.remove(obj);
        return uuid.toString();
    }

    public void unmap(EObject obj, boolean checkForExistence) {
        UUID uuid;
        if (checkForExistence && (uuid = this.getRealUUID(obj)) == null) {
            return;
        }
        this.unmappedObjects.add(obj);
    }

    public void cleanup() {
        for (EObject element : this.unmappedObjects) {
            UUID uuid = this.getRealUUID(element);
            this.uuidEObjectMap.remove(uuid);
        }
        this.unmappedObjects.clear();
    }

    public EObject getEObject(UUID uuid) {
        return this.uuidEObjectMap.get(uuid);
    }

    public EObject getEObject(String uuid) {
        return this.uuidEObjectMap.get(UUID.fromString(uuid));
    }

    public String getUUID(EObject obj) {
        if (null != obj) {
            Set<Map.Entry<UUID, EObject>> entrySet = this.uuidEObjectMap.entrySet();
            for (Map.Entry<UUID, EObject> e : entrySet) {
                if (!obj.equals(e.getValue())) continue;
                return e.getKey().toString();
            }
        }
        return null;
    }

    private UUID getRealUUID(EObject obj) {
        if (null != obj) {
            Set<Map.Entry<UUID, EObject>> entrySet = this.uuidEObjectMap.entrySet();
            for (Map.Entry<UUID, EObject> e : entrySet) {
                if (!obj.equals(e.getValue())) continue;
                return e.getKey();
            }
        }
        return null;
    }

    public void empty() {
        this.uuidEObjectMap = new HashMap<UUID, EObject>();
    }
}

