/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.common;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.model.xpdl.builder.common.AbstractElementBuilder;
import org.eclipse.stardust.model.xpdl.builder.common.AbstractIdentifiableElementBuilder;
import org.eclipse.stardust.model.xpdl.builder.common.AbstractModelElementBuilder;
import org.eclipse.stardust.model.xpdl.builder.common.AbstractProcessElementBuilder;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public abstract class PropertySetter {
    private final EStructuralFeature property;

    public static PropertySetter directValue(EStructuralFeature property, Object value) {
        return new DirectValueSetter(property, value);
    }

    public static ModelParticipantSetter participantById(EStructuralFeature property, String participantId) {
        return new ModelParticipantSetter(property, participantId);
    }

    public static IdentifiedElementSetter elementById(EStructuralFeature property, EReference elementDomain, String elementId) {
        return new IdentifiedElementSetter(property, elementDomain, elementId);
    }

    protected abstract Object resolveValue(AbstractElementBuilder<?, ?> var1);

    public PropertySetter(EStructuralFeature property) {
        this.property = property;
    }

    public <T extends EObject, B extends AbstractElementBuilder<T, B>> void apply(B builder) {
        Object value = this.resolveValue(builder);
        builder.element.eSet(this.property, value);
    }

    public static class IdentifiedElementSetter
    extends PropertySetter {
        protected final EReference elementDomain;
        protected final String elementId;

        public IdentifiedElementSetter(EStructuralFeature property, EReference elementDomain, String elementId) {
            super(property);
            this.elementDomain = elementDomain;
            this.elementId = elementId;
        }

        @Override
        protected Object resolveValue(AbstractElementBuilder<?, ?> builder) {
            EObject value = null;
            if (AbstractIdentifiableElementBuilder.PKG_CWM.getModelType() == this.elementDomain.getEContainingClass()) {
                ModelType model = null;
                if (builder instanceof AbstractModelElementBuilder) {
                    model = ((AbstractModelElementBuilder)builder).model();
                }
                if (null == model) {
                    model = ModelUtils.findContainingModel(builder.element);
                }
                value = ModelUtils.findElementById((EObject)model, (EStructuralFeature)this.elementDomain, (String)this.elementId);
            } else if (AbstractIdentifiableElementBuilder.PKG_CWM.getProcessDefinitionType() == this.elementDomain.getEContainingClass()) {
                ProcessDefinitionType process = null;
                if (builder instanceof AbstractProcessElementBuilder) {
                    process = ((AbstractProcessElementBuilder)builder).process();
                }
                if (null == process) {
                    process = ModelUtils.findContainingProcess(builder.element);
                }
                value = ModelUtils.findElementById((EObject)process, (EStructuralFeature)this.elementDomain, (String)this.elementId);
            }
            return value;
        }
    }

    public static class ModelParticipantSetter
    extends PropertySetter {
        private final String participantId;

        public ModelParticipantSetter(EStructuralFeature feature, String participantId) {
            super(feature);
            this.participantId = participantId;
        }

        protected IModelParticipant resolveValue(AbstractElementBuilder<?, ?> builder) {
            IModelParticipant participant;
            ModelType model = null;
            if (builder instanceof AbstractModelElementBuilder) {
                model = ((AbstractModelElementBuilder)builder).model();
            }
            if (null == model) {
                model = ModelUtils.findContainingModel(builder.element);
            }
            if (null == (participant = (IModelParticipant)ModelUtils.findElementById((List)model.getRole(), (String)this.participantId))) {
                participant = (IModelParticipant)ModelUtils.findElementById((List)model.getOrganization(), (String)this.participantId);
            }
            if (null == participant) {
                participant = (IModelParticipant)ModelUtils.findElementById((List)model.getConditionalPerformer(), (String)this.participantId);
            }
            return participant;
        }
    }

    public static class DirectValueSetter
    extends PropertySetter {
        private final Object value;

        public DirectValueSetter(EStructuralFeature feature, Object value) {
            super(feature);
            this.value = value;
        }

        @Override
        protected Object resolveValue(AbstractElementBuilder<?, ?> builder) {
            return this.value;
        }
    }
}

