/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.connectionhandler;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.api.runtime.DocumentManagementService;
import org.eclipse.stardust.model.xpdl.builder.connectionhandler.EObjectProxyHandler;
import org.eclipse.stardust.model.xpdl.builder.strategy.ModelManagementStrategy;
import org.eclipse.stardust.model.xpdl.builder.utils.ExternalReferenceUtils;
import org.eclipse.stardust.model.xpdl.builder.utils.PepperIconFactory;
import org.eclipse.stardust.model.xpdl.builder.utils.WebModelerConnectionManager;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DescriptionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.IconFactory;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionHandler;
import org.eclipse.stardust.modeling.repository.common.IFilter;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.ImportCancelledException;
import org.eclipse.stardust.modeling.repository.common.ImportStrategy;
import org.eclipse.stardust.modeling.repository.common.ImportableDescriptor;
import org.eclipse.stardust.modeling.repository.common.SimpleImportStrategy;
import org.eclipse.stardust.modeling.repository.common.descriptors.CategoryDescriptor;
import org.eclipse.stardust.modeling.repository.common.descriptors.EObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.descriptors.ModelElementDescriptor;
import org.eclipse.stardust.modeling.repository.common.util.ImportUtils;

public class WebModelerConnectionHandler
implements ConnectionHandler {
    DocumentManagementService documentManagementService;
    private boolean open;
    private URI uri;
    private IObjectDescriptor[] children = null;
    private Connection connection;
    private ModelManagementStrategy strategy;
    private static final List<String> PARTICIPANTS = Arrays.asList("role", "organization", "conditionalPerformer");
    private EObjectDescriptor modelDescriptor;
    private ModelType model;
    private boolean missingModel;

    public WebModelerConnectionHandler(ModelManagementStrategy strategy) {
        this.strategy = strategy;
    }

    synchronized ModelType loadModel(String id) {
        String uuid;
        String modelId = id.split("\\.")[0];
        ModelType model = this.strategy.getModels(false).get(modelId);
        if (model == null) {
            model = this.strategy.loadModel(modelId);
        }
        if (model == null && (uuid = this.connection.getAttribute("connectionUUID")) != null) {
            for (ModelType uuidModel : this.strategy.getModels().values()) {
                AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)uuidModel, (String)"carnot:model:uuid");
                if (attribute == null || !attribute.getValue().equals(uuid)) continue;
                model = uuidModel;
            }
        }
        return model;
    }

    public void importObject(ModelType model, IObjectDescriptor[] descriptors, boolean asLink) {
        for (int i = 0; i < descriptors.length; ++i) {
            IObjectDescriptor descriptor = descriptors[i];
            if (!(descriptor instanceof ImportableDescriptor)) continue;
            try {
                ((ImportableDescriptor)descriptor).importElements(model, (ImportStrategy)new SimpleImportStrategy(asLink));
                continue;
            }
            catch (Exception f) {
                Throwable targetException;
                Throwable undeclaredThrowable;
                if (!(f instanceof UndeclaredThrowableException ? (undeclaredThrowable = ((UndeclaredThrowableException)f).getUndeclaredThrowable()) instanceof InvocationTargetException && (targetException = ((InvocationTargetException)undeclaredThrowable).getTargetException()) instanceof ImportCancelledException : f instanceof ImportCancelledException)) continue;
                throw new ImportCancelledException();
            }
        }
    }

    public EObject resolve(ModelType model, EObject object) {
        URI uri = WebModelerConnectionManager.getURI(object);
        IObjectDescriptor node = this.find(uri);
        if (node instanceof ModelElementDescriptor) {
            return EObjectProxyHandler.createProxy(object, ((ModelElementDescriptor)node).getEObject());
        }
        return object;
    }

    public IObjectDescriptor find(URI uri) {
        if (uri.equals(this.uri)) {
            ModelType modelType;
            String connectionUUID;
            if (this.modelDescriptor == null && (connectionUUID = this.connection.getAttribute("connectionUUID")) != null && (modelType = ExternalReferenceUtils.getModelByUUID(this.strategy.getModels(), connectionUUID)) != null) {
                this.modelDescriptor = new EObjectDescriptor(uri, (EObject)modelType, modelType.getId(), modelType.getName(), ModelUtils.getDescriptionText((DescriptionType)modelType.getDescription()), "org.eclipse.stardust.modeling.core", null);
                this.missingModel = false;
                this.model = modelType;
            }
            return this.modelDescriptor;
        }
        String uuid = this.parseQuery(uri.query()).get("uuid");
        uri = uri.trimQuery();
        if (this.children != null) {
            for (IObjectDescriptor child : this.children) {
                URI categoryUri;
                if (uri.equals(child.getURI())) {
                    return child;
                }
                if (!(child instanceof CategoryDescriptor) || !this.isChildOf(categoryUri = child.getURI(), uri)) continue;
                IObjectDescriptor item = ((CategoryDescriptor)child).find(uri);
                if (!StringUtils.isEmpty((String)uuid) && !this.matches(uuid, item)) {
                    item = this.findByUUID(uuid, (CategoryDescriptor)child);
                }
                return item;
            }
        }
        return null;
    }

    private boolean matches(String uuid, IObjectDescriptor item) {
        return item instanceof EObjectDescriptor && uuid.equals(ModelUtils.getUUID((EObject)((EObjectDescriptor)item).getEObject()));
    }

    private IObjectDescriptor findByUUID(String uuid, CategoryDescriptor category) {
        for (IObjectDescriptor item : category.getChildren()) {
            if (!this.matches(uuid, item)) continue;
            return item;
        }
        return null;
    }

    private Map<String, String> parseQuery(String query) {
        if (StringUtils.isEmpty((String)query)) {
            return Collections.emptyMap();
        }
        Map map = CollectionUtils.newMap();
        for (String token : query.split("&")) {
            int ix = token.indexOf(61);
            map.put(ix < 0 ? token : token.substring(0, ix), ix < 0 ? token : token.substring(ix + 1));
        }
        return map;
    }

    public boolean isChildOf(URI categoryUri, URI uri) {
        if (uri.toString().startsWith(categoryUri.toString())) {
            return true;
        }
        if ("participants".equals(categoryUri.lastSegment()) && uri.segmentCount() > categoryUri.segmentCount()) {
            return PARTICIPANTS.contains(uri.segment(categoryUri.segmentCount() - 1));
        }
        return false;
    }

    public void open(Connection connection) throws CoreException {
        if (this.open) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.repository.common", 0, MessageFormat.format("EXC_ALREADY_OPEN", connection.getId()), null));
        }
        this.uri = WebModelerConnectionManager.makeURI(connection);
        String filename = connection.getAttribute("filename");
        String xpdlId = null;
        if (filename != null) {
            xpdlId = this.resolve(filename);
        }
        this.connection = connection;
        try {
            if (xpdlId != null) {
                this.updateCache(xpdlId);
            }
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.stardust.modeling.repository.file", "EXC_UNABLE_TO_LOAD_MD", (Throwable)ex));
        }
        this.open = true;
    }

    public void close(Connection connection) throws CoreException {
        if (!this.open) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.repository.common", 0, MessageFormat.format("EXC_ALREADY_CLOSED", connection.getId()), null));
        }
        this.open = false;
        this.connection = null;
    }

    public List<IObjectDescriptor> select(IFilter[] filters) throws CoreException {
        IObjectDescriptor searchDescriptor;
        int i;
        List result = CollectionUtils.newList();
        if (filters == null || filters.length == 0) {
            for (i = 0; i < this.children.length; ++i) {
                result.add(this.children[i]);
            }
        } else {
            block1: for (i = 0; i < this.children.length; ++i) {
                IObjectDescriptor descriptor = this.children[i];
                for (int j = 0; j < filters.length; ++j) {
                    if (filters[j] == null || !filters[j].accept((Object)descriptor)) continue;
                    result.add(descriptor);
                    continue block1;
                }
            }
        }
        if ((searchDescriptor = (IObjectDescriptor)this.connection.getProperty("search.result")) != null) {
            result.add(searchDescriptor);
        }
        return Collections.unmodifiableList(result);
    }

    private void updateCache(String id) throws IOException {
        if (!this.missingModel) {
            this.model = this.loadModel(id);
            boolean bl = this.missingModel = this.model == null;
        }
        if (this.model == null) {
            throw new IOException("Model not found: " + id);
        }
        PepperIconFactory iconFactory = new PepperIconFactory();
        this.modelDescriptor = new EObjectDescriptor(this.uri, (EObject)this.model, this.model.getId(), this.model.getName(), ModelUtils.getDescriptionText((DescriptionType)this.model.getDescription()), "org.eclipse.stardust.modeling.core", null);
        List descriptors = ImportUtils.createObjectDescriptors((IconFactory)iconFactory, (ModelType)this.model, (URI)this.uri);
        if (descriptors.size() > 0) {
            this.children = descriptors.toArray(new IObjectDescriptor[0]);
        }
    }

    private String resolve(String fileName) {
        String xpdlName = null;
        java.net.URI uri = java.net.URI.create(fileName = fileName.replace(" ", "%20"));
        if ("project".equals(uri.getScheme())) {
            String path = uri.getPath();
            xpdlName = path.substring(1);
        } else if (!"platform".equals(uri.getScheme()) && null == uri.getScheme()) {
            xpdlName = fileName;
        }
        return xpdlName;
    }
}

