/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.initializer;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataInitializer;

public class SerializableDataInitializer
implements IDataInitializer {
    public List initialize(DataType data, List attributes) {
        String className = null;
        for (int i = 0; i < attributes.size(); ++i) {
            AttributeType attribute = (AttributeType)attributes.get(i);
            if ("carnot:engine:className".equals(attribute.getName())) {
                className = attribute.getValue();
            } else if ("carnot:engine:remoteInterface".equals(attribute.getName())) {
                className = attribute.getValue();
            } else if ("carnot:engine:type".equals(attribute.getName())) {
                try {
                    Class type = Reflect.getClassFromAbbreviatedName((String)attribute.getValue());
                    if (null != type) {
                        className = type.getName();
                    }
                }
                catch (InternalException internalException) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((String)className)) break;
        }
        AttributeType attribute = CarnotWorkflowModelFactory.eINSTANCE.createAttributeType();
        attribute.setName("carnot:engine:className");
        attribute.setValue(className == null ? Serializable.class.getName() : className);
        return Collections.singletonList(attribute);
    }
}

