/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.session;

import java.util.Collections;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.model.xpdl.builder.session.Modification;

public class EditingSession {
    private static final Logger trace = LogManager.getLogger(EditingSession.class);
    private final String id;
    private final Set<EObject> models = CollectionUtils.newHashSet();
    private ChangeRecorder emfChangeRecorder = null;
    private final Stack<Modification> undoableModifications = new Stack();
    private final Stack<Modification> redoableModifications = new Stack();
    private boolean keepChangeRecorder;

    public EditingSession() {
        this(UUID.randomUUID().toString());
    }

    public EditingSession(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean isTrackingModel(EObject model) {
        return this.models.contains(model);
    }

    public Set<EObject> getTrackedModels() {
        return Collections.unmodifiableSet(this.models);
    }

    public void reset() {
        if (this.isInEditMode()) {
            this.endEdit(false);
        }
        this.clearUndoRedoStack();
        this.models.clear();
    }

    public void trackModel(EObject model) {
        if (!this.models.contains(model)) {
            this.models.add(model);
        }
    }

    public boolean isInEditMode() {
        return null != this.emfChangeRecorder && this.emfChangeRecorder.isRecording();
    }

    public boolean beginEdit() {
        this.keepChangeRecorder = true;
        if (!this.isInEditMode()) {
            if (this.emfChangeRecorder == null) {
                this.emfChangeRecorder = new ChangeRecorder(){

                    protected boolean isOrphan(EObject eObject) {
                        return !EditingSession.this.models.contains(eObject) && super.isOrphan(eObject);
                    }

                    public ChangeDescription endRecording() {
                        if (this.isRecording()) {
                            this.setRecording(EditingSession.this.keepChangeRecorder);
                            this.consolidateChanges();
                            return this.getChangeDescription();
                        }
                        return null;
                    }
                };
                this.emfChangeRecorder.setResolveProxies(true);
                this.emfChangeRecorder.beginRecording(this.models);
            }
            return this.isInEditMode();
        }
        return false;
    }

    public boolean endEdit(boolean keepCR) {
        if (this.isInEditMode()) {
            this.keepChangeRecorder = keepCR;
            ChangeDescription changeDescription = this.emfChangeRecorder.endRecording();
            if (!this.keepChangeRecorder) {
                this.emfChangeRecorder.dispose();
                this.emfChangeRecorder = null;
            }
            if (!this.redoableModifications.isEmpty()) {
                this.redoableModifications.clear();
            }
            if (this.keepChangeRecorder) {
                this.undoableModifications.push(new Modification(this, changeDescription));
            }
            return !this.isInEditMode();
        }
        return false;
    }

    public boolean endEdit() {
        if (this.isInEditMode()) {
            ChangeDescription changeDescription = this.emfChangeRecorder.endRecording();
            this.emfChangeRecorder.dispose();
            this.emfChangeRecorder = null;
            if (!this.redoableModifications.isEmpty()) {
                this.redoableModifications.clear();
            }
            this.undoableModifications.push(new Modification(this, changeDescription));
            return !this.isInEditMode();
        }
        return false;
    }

    public boolean canUndo() {
        return !this.undoableModifications.isEmpty() && this.undoableModifications.peek().canUndo();
    }

    public Modification getPendingUndo() {
        return !this.undoableModifications.isEmpty() ? this.undoableModifications.peek() : null;
    }

    public boolean canRedo() {
        return !this.redoableModifications.isEmpty() && this.redoableModifications.peek().canRedo();
    }

    public Modification getPendingRedo() {
        return !this.redoableModifications.isEmpty() ? this.redoableModifications.peek() : null;
    }

    public Modification undoLast() {
        Modification change = null;
        if (this.canUndo()) {
            change = this.undoableModifications.pop();
            change.undo();
            this.redoableModifications.push(change);
        }
        return change;
    }

    public Modification redoNext() {
        Modification change = null;
        if (this.canRedo()) {
            change = this.redoableModifications.pop();
            change.redo();
            this.undoableModifications.push(change);
        }
        return change;
    }

    public void clearUndoRedoStack() {
        this.undoableModifications.clear();
        this.redoableModifications.clear();
    }
}

