/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.session;

import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeFactory;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.impl.ChangeDescriptionImpl;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.builder.session.EditingSession;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;

public class Modification {
    private final String id;
    private final EditingSession session;
    private Map<String, String> metadata = CollectionUtils.newHashMap();
    private final ChangeDescription changeDescription;
    private final Exception failure;
    private State state;
    private final Set<EObject> modifiedElements = new CopyOnWriteArraySet<EObject>();
    private final Set<EObject> addedElements = new CopyOnWriteArraySet<EObject>();
    private final Set<EObject> removedElements = new CopyOnWriteArraySet<EObject>();

    public Modification(EditingSession session, ChangeDescription changeDescription) {
        this.id = UUID.randomUUID().toString();
        this.session = session;
        this.changeDescription = changeDescription;
        this.failure = null;
        this.state = State.UNDOABLE;
        this.normalizeChangeSet();
    }

    public Modification(EditingSession session, Exception failure) {
        this.id = UUID.randomUUID().toString();
        this.session = session;
        this.changeDescription = ChangeFactory.eINSTANCE.createChangeDescription();
        this.failure = failure;
        this.state = State.UNDOABLE;
        this.normalizeChangeSet();
    }

    public String getId() {
        return this.id;
    }

    public EditingSession getSession() {
        return this.session;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public boolean canUndo() {
        return null != this.changeDescription && State.UNDOABLE == this.state;
    }

    public boolean canRedo() {
        return null != this.changeDescription && State.REDOABLE == this.state;
    }

    public void undo() {
        if (this.canUndo()) {
            this.changeDescription.applyAndReverse();
            this.state = State.REDOABLE;
            this.normalizeChangeSet();
        }
    }

    public void redo() {
        if (this.canRedo()) {
            this.changeDescription.applyAndReverse();
            this.state = State.UNDOABLE;
            this.normalizeChangeSet();
        }
    }

    public Collection<EObject> getAddedElements() {
        return Collections.unmodifiableCollection(this.addedElements);
    }

    public Collection<EObject> getModifiedElements() {
        return Collections.unmodifiableCollection(this.modifiedElements);
    }

    public Collection<EObject> getRemovedElements() {
        return Collections.unmodifiableCollection(this.removedElements);
    }

    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    public boolean wasFailure() {
        return null != this.failure;
    }

    public Exception getFailure() {
        return this.failure;
    }

    private void normalizeChangeSet() {
        this.modifiedElements.clear();
        this.addedElements.clear();
        this.removedElements.clear();
        this.collectChangedElements(this.changeDescription.getObjectChanges().keySet(), this.modifiedElements);
        for (EObject candidate : this.changeDescription.getObjectsToDetach()) {
            EObject changedElement;
            if (null == ModelUtils.findContainingModel((EObject)candidate) || this.isModelOrModelElement(candidate) || (changedElement = this.determineChangedElement(candidate)).eIsProxy() && !(changedElement instanceof Proxy)) continue;
            this.modifiedElements.add(changedElement);
        }
        for (EObject candidate : this.changeDescription.getObjectsToDetach()) {
            if (null != ModelUtils.findContainingModel((EObject)candidate) && !this.isModelOrModelElement(candidate)) continue;
            this.addedElements.add(candidate);
        }
        for (EObject candidate : this.changeDescription.getObjectsToAttach()) {
            if (!this.isModelOrModelElement(candidate)) continue;
            this.removedElements.add(candidate);
        }
        this.modifiedElements.removeAll(this.addedElements);
        this.modifiedElements.removeAll(this.removedElements);
    }

    private void collectChangedElements(Collection<EObject> candidates, Set<EObject> result) {
        for (EObject changedObject : candidates) {
            EObject changedElement = this.determineChangedElement(changedObject);
            if (changedElement.eIsProxy() && !(changedElement instanceof Proxy)) continue;
            result.add(changedElement);
        }
    }

    public EObject determineChangedElement(EObject changedObject) {
        EObject element;
        for (element = changedObject; null != element && !this.isModelOrModelElement(element); element = element.eContainer()) {
        }
        return null != element ? element : changedObject;
    }

    private boolean isModelOrModelElement(EObject changedObject) {
        return changedObject instanceof ModelType || changedObject instanceof IModelElement || changedObject instanceof Extensible;
    }

    public boolean wasModified(EObject eObject, EStructuralFeature eFeature) {
        EList changes = (EList)this.getChangeDescription().getObjectChanges().get((Object)eObject);
        if (!CollectionUtils.isEmpty((Collection)changes)) {
            for (FeatureChange change : changes) {
                if (eFeature != change.getFeature()) continue;
                return true;
            }
        }
        return false;
    }

    public <T extends EObject> T findContainer(EObject element, Class<T> containerType) {
        EObject currentElement = element;
        while (null != currentElement) {
            EObject currentContainer = currentElement.eContainer();
            if (currentContainer instanceof ChangeDescription && this.getRemovedElements().contains(currentElement) && this.getChangeDescription() instanceof ChangeDescriptionImpl) {
                currentContainer = ((ChangeDescriptionImpl)this.getChangeDescription()).getOldContainer(currentElement);
            }
            if (containerType.isInstance(currentContainer)) {
                return (T)((EObject)containerType.cast(currentContainer));
            }
            currentElement = currentContainer;
        }
        return null;
    }

    public boolean isChangedElement(EObject element) {
        return this.modifiedElements.contains(element) || this.addedElements.contains(element) || this.removedElements.contains(element);
    }

    public void markUnmodified(EObject element) {
        this.modifiedElements.remove(element);
        this.addedElements.remove(element);
        this.removedElements.remove(element);
    }

    public void markAlsoModified(EObject element) {
        this.markAlsoModified(element, false);
    }

    public void markAlsoModified(EObject element, boolean overrideStatus) {
        if (!this.isChangedElement(element) || overrideStatus) {
            this.modifiedElements.add(element);
            this.addedElements.remove(element);
            this.removedElements.remove(element);
        }
    }

    public void markAlsoAdded(EObject element) {
        this.markAlsoAdded(element, false);
    }

    public void markAlsoAdded(EObject element, boolean overrideStatus) {
        if (!this.isChangedElement(element) || overrideStatus) {
            this.addedElements.add(element);
            this.modifiedElements.remove(element);
            this.removedElements.remove(element);
        }
    }

    public void markAlsoRemoved(EObject element) {
        this.markAlsoRemoved(element, false);
    }

    public void markAlsoRemoved(EObject element, boolean overrideStatus) {
        if (!this.isChangedElement(element) || overrideStatus) {
            this.removedElements.add(element);
            this.modifiedElements.remove(element);
            this.addedElements.remove(element);
        }
    }

    private static enum State {
        UNDOABLE,
        REDOABLE;

    }
}

