/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.builder.strategy.AbstractModelManagementStrategy;
import org.eclipse.stardust.model.xpdl.builder.strategy.ModelManagementStrategy;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;

public class InMemoryModelManagementStrategy
extends AbstractModelManagementStrategy {
    private List<ModelType> models = new ArrayList<ModelType>();

    public void registerModel(ModelType model) {
        this.models.add(model);
    }

    @Override
    public Map<String, ModelType> getModels() {
        return this.getModels(true);
    }

    @Override
    public List<AbstractModelManagementStrategy.ModelDescriptor> loadModels() {
        ArrayList result = CollectionUtils.newArrayList();
        for (ModelType model : this.models) {
            result.add(new AbstractModelManagementStrategy.ModelDescriptor(model.getId(), null, (EObject)model, model));
            this.loadEObjectUUIDMap(model);
        }
        return result;
    }

    @Override
    public ModelType loadModel(String id) {
        for (ModelType model : this.models) {
            if (!model.getId().equalsIgnoreCase(id)) continue;
            return model;
        }
        return null;
    }

    @Override
    public String getUniqueModelId(EObject model) {
        for (ModelType xpdlModel : this.models) {
            if (model != xpdlModel) continue;
            return xpdlModel.getId();
        }
        return null;
    }

    @Override
    public ModelType attachModel(String id) {
        ModelType model = this.loadModel(id);
        this.models.add(model);
        return model;
    }

    @Override
    public void saveModel(ModelType model) {
    }

    @Override
    public void deleteModel(ModelType model) {
    }

    @Override
    public void versionizeModel(ModelType model) {
    }

    @Override
    public String getModelFileName(ModelType model) {
        return model.getId() + '.' + "xpdl";
    }

    @Override
    public String getModelFilePath(ModelType model) {
        return null;
    }

    @Override
    public ModelManagementStrategy.ModelUploadStatus uploadModelFile(String fileName, byte[] fileContent, boolean createNewVersion) {
        return null;
    }
}

