/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.utils;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.engine.extensions.dms.data.DmsConstants;
import org.eclipse.stardust.model.xpdl.builder.connectionhandler.EObjectProxyHandler;
import org.eclipse.stardust.model.xpdl.builder.connectionhandler.IdRefHandler;
import org.eclipse.stardust.model.xpdl.builder.exception.ModelerErrorClass;
import org.eclipse.stardust.model.xpdl.builder.exception.ModelerException;
import org.eclipse.stardust.model.xpdl.builder.utils.ModelBuilderFacade;
import org.eclipse.stardust.model.xpdl.builder.utils.WebModelerConnectionManager;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IdRef;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.SubProcessModeType;
import org.eclipse.stardust.model.xpdl.carnot.merge.LinkAttribute;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IConnection;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.xpdl2.DataTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributesType;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParameterType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.descriptors.ReplaceEObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.descriptors.ReplaceModelElementDescriptor;
import org.eclipse.stardust.modeling.repository.common.util.ImportUtils;
import org.eclipse.xsd.XSDImport;

public class ExternalReferenceUtils {
    public static void createExternalReferenceToApplication(ActivityType activity, ApplicationType application, ModelType consumerModel, ModelType providerModel) {
        if (ModelUtils.hasCircularDependency((String)consumerModel.getId(), (ModelType)providerModel)) {
            throw new ModelerException(ModelerErrorClass.CIRCULAR_DEPENDENCY);
        }
        String fileConnectionId = WebModelerConnectionManager.createFileConnection(consumerModel, providerModel);
        String bundleId = "org.eclipse.stardust.modeling.core";
        URI uri = URI.createURI((String)("cnx://" + fileConnectionId + "/"));
        ReplaceModelElementDescriptor descriptor = new ReplaceModelElementDescriptor(uri, (IIdentifiableModelElement)application, bundleId, null, true);
        AttributeUtil.setAttribute((IExtensibleElement)activity, (String)"carnot:connection:uri", (String)descriptor.getURI().toString());
        IdRef idRef = CarnotWorkflowModelFactory.eINSTANCE.createIdRef();
        idRef.setRef(application.getId());
        idRef.setPackageRef(ImportUtils.getPackageRef((IObjectDescriptor)descriptor, (ModelType)consumerModel, (ModelType)providerModel));
        activity.setExternalRef(idRef);
        AttributeType uuidAttribute = AttributeUtil.getAttribute((IExtensibleElement)application, (String)"carnot:model:uuid");
        if (uuidAttribute != null) {
            AttributeUtil.setAttribute((IExtensibleElement)activity, (String)"carnot:connection:uuid", (String)uuidAttribute.getValue());
        }
        IdRefHandler.adapt((IIdentifiableModelElement)activity);
    }

    public static void createExternalReferenceToProcess(ActivityType activity, ProcessDefinitionType process, ModelType consumerModel, ModelType processModel) {
        if (ModelUtils.hasCircularDependency((String)consumerModel.getId(), (ModelType)processModel)) {
            throw new ModelerException(ModelerErrorClass.CIRCULAR_DEPENDENCY);
        }
        String fileConnectionId = WebModelerConnectionManager.createFileConnection(consumerModel, processModel);
        String bundleId = "org.eclipse.stardust.modeling.core";
        URI uri = URI.createURI((String)("cnx://" + fileConnectionId + "/"));
        ReplaceModelElementDescriptor descriptor = new ReplaceModelElementDescriptor(uri, (IIdentifiableModelElement)process, bundleId, null, true);
        AttributeUtil.setAttribute((IExtensibleElement)activity, (String)"carnot:connection:uri", (String)descriptor.getURI().toString());
        if (processModel != null) {
            IdRef idRef = CarnotWorkflowModelFactory.eINSTANCE.createIdRef();
            idRef.setRef(process.getId());
            idRef.setPackageRef(ImportUtils.getPackageRef((IObjectDescriptor)descriptor, (ModelType)consumerModel, (ModelType)processModel));
            activity.setExternalRef(idRef);
            activity.setSubProcessMode(SubProcessModeType.SYNC_SEPARATE_LITERAL);
            AttributeType uuidAttribute = AttributeUtil.getAttribute((IExtensibleElement)process, (String)"carnot:model:uuid");
            if (uuidAttribute != null) {
                AttributeUtil.setAttribute((IExtensibleElement)activity, (String)"carnot:connection:uuid", (String)uuidAttribute.getValue());
            }
            IdRefHandler.adapt((IIdentifiableModelElement)activity);
        }
    }

    public static void createExternalReferenceToDocument(DataType data, ModelType consumerModel, ModelType typeDeclarationModel, TypeDeclarationType typeDeclaration) {
        if (ModelUtils.hasCircularDependency((String)consumerModel.getId(), (ModelType)typeDeclarationModel)) {
            throw new ModelerException(ModelerErrorClass.CIRCULAR_DEPENDENCY);
        }
        String fileConnectionId = WebModelerConnectionManager.createFileConnection(consumerModel, typeDeclarationModel);
        String bundleId = "org.eclipse.stardust.modeling.core";
        URI uri = URI.createURI((String)("cnx://" + fileConnectionId + "/"));
        ReplaceEObjectDescriptor descriptor = new ReplaceEObjectDescriptor(MergeUtils.createQualifiedUri((URI)uri, (EObject)typeDeclaration, (boolean)true), (EObject)data, typeDeclaration.getId(), typeDeclaration.getName(), typeDeclaration.getDescription(), bundleId, null);
        AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:path:separator", (String)"/");
        AttributeUtil.setBooleanAttribute((IExtensibleElement)data, (String)"carnot:engine:data:bidirectional", (Boolean)true);
        AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", (String)descriptor.getURI().toString());
        ExternalReferenceType reference = XpdlFactory.eINSTANCE.createExternalReferenceType();
        if (typeDeclarationModel != null) {
            reference.setLocation(ImportUtils.getPackageRef((IObjectDescriptor)descriptor, (ModelType)consumerModel, (ModelType)typeDeclarationModel).getId());
        }
        reference.setXref(typeDeclaration.getId());
        String uuid = ExtendedAttributeUtil.getAttributeValue((ExtendedAttributesType)typeDeclaration.getExtendedAttributes(), (String)"carnot:model:uuid");
        if (uuid != null) {
            reference.setUuid(uuid);
        }
        data.setExternalReference(reference);
    }

    public static void createExternalReferenceToTypeDeclaration(DataType dataType, ModelType consumerModel, ModelType typeDeclarationModel, TypeDeclarationType typeDeclaration) {
        if (ModelUtils.hasCircularDependency((String)consumerModel.getId(), (ModelType)typeDeclarationModel)) {
            throw new ModelerException(ModelerErrorClass.CIRCULAR_DEPENDENCY);
        }
        String fileConnectionId = WebModelerConnectionManager.createFileConnection(consumerModel, typeDeclarationModel);
        String bundleId = "org.eclipse.stardust.modeling.core";
        URI uri = URI.createURI((String)("cnx://" + fileConnectionId + "/"));
        ReplaceEObjectDescriptor descriptor = new ReplaceEObjectDescriptor(MergeUtils.createQualifiedUri((URI)uri, (EObject)typeDeclaration, (boolean)true), (EObject)dataType, typeDeclaration.getId(), typeDeclaration.getName(), typeDeclaration.getDescription(), bundleId, null);
        AttributeUtil.setAttribute((IExtensibleElement)dataType, (String)"carnot:engine:path:separator", (String)"/");
        AttributeUtil.setBooleanAttribute((IExtensibleElement)dataType, (String)"carnot:engine:data:bidirectional", (Boolean)true);
        AttributeUtil.setAttribute((IExtensibleElement)dataType, (String)"carnot:connection:uri", (String)descriptor.getURI().toString());
        ExternalReferenceType reference = XpdlFactory.eINSTANCE.createExternalReferenceType();
        if (typeDeclarationModel != null) {
            reference.setLocation(ImportUtils.getPackageRef((IObjectDescriptor)descriptor, (ModelType)consumerModel, (ModelType)typeDeclarationModel).getId());
        }
        reference.setXref(typeDeclaration.getId());
        String uuid = ExtendedAttributeUtil.getAttributeValue((ExtendedAttributesType)typeDeclaration.getExtendedAttributes(), (String)"carnot:model:uuid");
        if (uuid != null) {
            reference.setUuid(uuid);
        }
        dataType.setExternalReference(reference);
    }

    public static void createStructReferenceForFormalParameter(FormalParameterType parameter, String declarationID, ModelType model, ModelType providerModel) {
        if (ModelUtils.hasCircularDependency((String)model.getId(), (ModelType)providerModel)) {
            throw new ModelerException(ModelerErrorClass.CIRCULAR_DEPENDENCY);
        }
        XpdlFactory xpdlFactory = XpdlPackage.eINSTANCE.getXpdlFactory();
        ExternalReferenceUtils.updateReferences(model, providerModel);
        ExternalReferenceType extRef = xpdlFactory.createExternalReferenceType();
        extRef.setLocation(providerModel.getId());
        extRef.setXref(declarationID);
        TypeDeclarationType typeDeclaration = providerModel.getTypeDeclarations().getTypeDeclaration(declarationID);
        String uuid = ExtendedAttributeUtil.getAttributeValue((ExtendedAttributesType)typeDeclaration.getExtendedAttributes(), (String)"carnot:model:uuid");
        if (uuid != null) {
            extRef.setUuid(uuid);
        }
        parameter.getDataType().setExternalReference(extRef);
    }

    public static void createStructReferenceForAccessPoint(AccessPointType accessPoint, String typeID, ModelType refModel) {
        String uuid;
        TypeDeclarationType typeDeclaration = refModel.getTypeDeclarations().getTypeDeclaration(typeID);
        if (typeDeclaration != null && (uuid = ExtendedAttributeUtil.getAttributeValue((ExtendedAttributesType)typeDeclaration.getExtendedAttributes(), (String)"carnot:model:uuid")) != null) {
            AttributeUtil.setAttribute((IExtensibleElement)accessPoint, (String)"carnot:connection:uuid", (String)uuid);
        }
    }

    public static void createStructReferenceForDocument(DataType data, String declarationID, ModelType model, ModelType providerModel) {
        if (ModelUtils.hasCircularDependency((String)model.getId(), (ModelType)providerModel)) {
            throw new ModelerException(ModelerErrorClass.CIRCULAR_DEPENDENCY);
        }
        TypeDeclarationType typeDeclaration = providerModel.getTypeDeclarations().getTypeDeclaration(declarationID);
        if (typeDeclaration != null) {
            String fileConnectionId = WebModelerConnectionManager.createFileConnection(model, providerModel);
            String bundleId = "org.eclipse.stardust.modeling.core";
            URI uri = URI.createURI((String)("cnx://" + fileConnectionId + "/"));
            ReplaceEObjectDescriptor descriptor = new ReplaceEObjectDescriptor(MergeUtils.createQualifiedUri((URI)uri, (EObject)typeDeclaration, (boolean)true), (EObject)data, typeDeclaration.getId(), typeDeclaration.getName(), typeDeclaration.getDescription(), bundleId, null);
            AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:path:separator", (String)"/");
            AttributeUtil.setBooleanAttribute((IExtensibleElement)data, (String)"carnot:engine:data:bidirectional", (Boolean)true);
            AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", (String)descriptor.getURI().toString());
            ExternalReferenceType reference = XpdlFactory.eINSTANCE.createExternalReferenceType();
            if (providerModel != null) {
                reference.setLocation(ImportUtils.getPackageRef((IObjectDescriptor)descriptor, (ModelType)model, (ModelType)providerModel).getId());
            }
            reference.setXref(declarationID);
            String uuid = ExtendedAttributeUtil.getAttributeValue((ExtendedAttributesType)typeDeclaration.getExtendedAttributes(), (String)"carnot:model:uuid");
            if (uuid != null) {
                reference.setUuid(uuid);
            }
            data.setExternalReference(reference);
        }
    }

    public static void createStructReferenceForPrimitive(DataType data, ModelType model, String declarationID, ModelType typeDeclarationModel) {
        if (ModelUtils.hasCircularDependency((String)model.getId(), (ModelType)typeDeclarationModel)) {
            throw new ModelerException(ModelerErrorClass.CIRCULAR_DEPENDENCY);
        }
        String fileConnectionId = WebModelerConnectionManager.createFileConnection(model, typeDeclarationModel);
        URI uri = URI.createURI((String)("cnx://" + fileConnectionId + "/"));
        ExternalReferenceType reference = XpdlFactory.eINSTANCE.createExternalReferenceType();
        if (typeDeclarationModel != null) {
            String uuid;
            reference.setLocation(ExternalReferenceUtils.getPackageRef(uri, model, typeDeclarationModel).getId());
            TypeDeclarationType typeDeclaration = typeDeclarationModel.getTypeDeclarations().getTypeDeclaration(declarationID);
            if (typeDeclaration != null && (uuid = ExtendedAttributeUtil.getAttributeValue((ExtendedAttributesType)typeDeclaration.getExtendedAttributes(), (String)"carnot:model:uuid")) != null) {
                ModelBuilderFacade.setAttribute(data, "carnot:connection:uuid", uuid);
            }
        }
        reference.setXref(declarationID);
        data.setExternalReference(reference);
    }

    public static void updateReferences(ModelType model, ModelType ref) {
        if (ModelUtils.hasCircularDependency((String)model.getId(), (ModelType)ref)) {
            throw new ModelerException(ModelerErrorClass.CIRCULAR_DEPENDENCY);
        }
        String connId = WebModelerConnectionManager.createFileConnection(model, ref);
        ExternalPackages packs = model.getExternalPackages();
        if (packs == null) {
            packs = XpdlFactory.eINSTANCE.createExternalPackages();
            model.setExternalPackages(packs);
        }
        if (packs.getExternalPackage(ref.getId()) == null) {
            ExternalPackage pack = XpdlFactory.eINSTANCE.createExternalPackage();
            pack.setId(ref.getId());
            pack.setName(ref.getName());
            pack.setHref(ref.getId());
            ExtendedAttributeUtil.setAttribute((Extensible)pack, (String)"carnot:connection:uri", (String)("cnx://" + connId + "/"));
            EList packList = packs.getExternalPackage();
            packList.add(pack);
        }
    }

    public static List<EObject> getExternalReferences(ModelType model, Connection connection) {
        String importString = connection.getAttribute("importByReference");
        if (importString != null && importString.equalsIgnoreCase("false")) {
            return Collections.emptyList();
        }
        IConnectionManager connectionManager = model.getConnectionManager();
        String connectionId = connection.getId();
        List list = CollectionUtils.newList();
        TreeIterator i = model.eAllContents();
        while (i.hasNext()) {
            ProcessDefinitionType processDefinition;
            AccessPointType accessPoint;
            String declaredType;
            String uri;
            ExternalPackage pack;
            ExternalPackages packs;
            DataTypeType dataTypeType;
            ExternalPackage pack2;
            ExternalPackages packs2;
            QName qname;
            String namespace;
            String location;
            EObject modelElement = (EObject)i.next();
            ExternalReferenceUtils.checkExtensible(connectionManager, connectionId, list, modelElement);
            if (modelElement instanceof XSDImport && (location = ((XSDImport)modelElement).getSchemaLocation()) != null && location.startsWith("urn:internal:") && !"".equals(namespace = (qname = QName.valueOf(location.substring("urn:internal:".length()))).getNamespaceURI()) && !namespace.equals(model.getId()) && (packs2 = model.getExternalPackages()) != null && (pack2 = packs2.getExternalPackage(namespace)) != null) {
                String uri2 = ExtendedAttributeUtil.getAttributeValue((Extensible)pack2, (String)"carnot:connection:uri");
                ExternalReferenceUtils.checkConnectionUsed(connectionManager, list, connectionId, modelElement, uri2 == null ? null : URI.createURI((String)uri2));
            }
            if (modelElement instanceof DataTypeType && (dataTypeType = (DataTypeType)modelElement).getExternalReference() != null && (packs = model.getExternalPackages()) != null && (pack = packs.getExternalPackage(dataTypeType.getExternalReference().getLocation())) != null) {
                uri = ExtendedAttributeUtil.getAttributeValue((Extensible)pack, (String)"carnot:connection:uri");
                ExternalReferenceUtils.checkConnectionUsed(connectionManager, list, connectionId, modelElement, uri == null ? null : URI.createURI((String)uri));
            }
            if (modelElement instanceof AccessPointType && (declaredType = AttributeUtil.getAttributeValue((IExtensibleElement)(accessPoint = (AccessPointType)modelElement), (String)"carnot:engine:dataType")) != null && declaredType.indexOf("{") > 0) {
                ExternalPackage pack3;
                ExternalPackages packs3;
                String typeID = declaredType.substring(declaredType.indexOf("}") + 1);
                String refModelID = declaredType.substring(declaredType.indexOf("{") + 1, declaredType.indexOf("}"));
                if (!typeID.equals("TO_BE_DEFINED") && (packs3 = model.getExternalPackages()) != null && (pack3 = packs3.getExternalPackage(refModelID)) != null) {
                    String uri3 = ExtendedAttributeUtil.getAttributeValue((Extensible)pack3, (String)"carnot:connection:uri");
                    ExternalReferenceUtils.checkConnectionUsed(connectionManager, list, connectionId, modelElement, uri3 == null ? null : URI.createURI((String)uri3));
                }
            }
            if (!(modelElement instanceof ProcessDefinitionType) || (processDefinition = (ProcessDefinitionType)modelElement).getExternalRef() == null || (packs = model.getExternalPackages()) == null || (pack = processDefinition.getExternalRef().getPackageRef()) == null) continue;
            uri = ExtendedAttributeUtil.getAttributeValue((Extensible)pack, (String)"carnot:connection:uri");
            ExternalReferenceUtils.checkConnectionUsed(connectionManager, list, connectionId, modelElement, uri == null ? null : URI.createURI((String)uri));
        }
        return list;
    }

    private static void checkExtensible(IConnectionManager connectionManager, String connectionId, List<EObject> list, EObject modelElement) {
        URI connectionUri = null;
        if (modelElement.eIsProxy()) {
            URI proxyUri = ((InternalEObject)modelElement).eProxyURI();
            if ("cnx".equals(proxyUri.scheme())) {
                connectionUri = proxyUri.trimSegments(proxyUri.segmentCount());
            }
        } else {
            String uri = null;
            if (modelElement instanceof IExtensibleElement) {
                uri = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)modelElement), (String)"carnot:connection:uri");
            } else if (modelElement instanceof Extensible) {
                uri = ExtendedAttributeUtil.getAttributeValue((Extensible)((Extensible)modelElement), (String)"carnot:connection:uri");
            }
            if (uri != null) {
                connectionUri = URI.createURI((String)uri);
            }
        }
        ExternalReferenceUtils.checkConnectionUsed(connectionManager, list, connectionId, modelElement, connectionUri);
    }

    private static void checkConnectionUsed(IConnectionManager connectionManager, List<EObject> list, String connectionId, EObject modelElement, URI connectionUri) {
        IConnection refConnection;
        if (connectionUri != null && (refConnection = connectionManager.findConnection(connectionUri)) != null && connectionId.equals(refConnection.getId())) {
            list.add(modelElement);
        }
    }

    public static void fixExternalReferences(Map<String, ModelType> models, ModelType model) {
        for (DataType data : model.getData()) {
            AttributeType attribute;
            if (data.getType() == null || data.eIsProxy() || data.getExternalReference() != null) continue;
            if (data.getType().getId().equals("struct") && (attribute = AttributeUtil.getAttribute((IExtensibleElement)data, (String)"carnot:engine:dataType")) != null) {
                ModelUtils.setReference((AttributeType)attribute, (ModelType)model, (String)"struct");
            }
            if (!data.getType().getId().equals("dmsDocument") || (attribute = AttributeUtil.getAttribute((IExtensibleElement)data, (String)DmsConstants.RESOURCE_METADATA_SCHEMA_ATT)) == null) continue;
            ModelUtils.setReference((AttributeType)attribute, (ModelType)model, (String)"struct");
        }
        List uris = ModelUtils.getURIsForExternalPackages((ModelType)model);
        for (String uri : uris) {
            String connectionUUID;
            WebModelerConnectionManager cm = (WebModelerConnectionManager)model.getConnectionManager();
            Connection connection = (Connection)cm.findConnection(uri);
            List<EObject> references = ExternalReferenceUtils.getExternalReferences(model, connection);
            ModelType modelType = ModelUtils.getReferencedModelByURI((ModelType)model, (String)uri);
            if (modelType == null) continue;
            ModelType refModel = models.get(modelType.getId());
            if (refModel == null && (connectionUUID = connection.getAttribute("connectionUUID")) != null) {
                refModel = ExternalReferenceUtils.getModelByUUID(models, connectionUUID);
            }
            if (refModel == null) continue;
            ExternalReferenceUtils.fixConnection(connection, refModel);
            for (EObject ref : references) {
                if (ref instanceof ExternalPackage) {
                    ExternalReferenceUtils.fixExternalPackage((ExternalPackage)ref, refModel);
                }
                if (ref instanceof ActivityType) {
                    ExternalReferenceUtils.fixActivity((ActivityType)ref, refModel);
                }
                if (ref instanceof DataType) {
                    ExternalReferenceUtils.fixData((DataType)ref, refModel);
                }
                if (ref instanceof DataTypeType) {
                    ExternalReferenceUtils.fixDataTypeType((DataTypeType)ref, refModel);
                }
                if (!(ref instanceof AccessPointType)) continue;
                ExternalReferenceUtils.fixAccessPoint((AccessPointType)ref, refModel);
            }
        }
    }

    public static List<EObject> fixExternalReferences(Map<String, ModelType> models, ModelType model, EObject referedObject) {
        ArrayList<EObject> referingObjects = new ArrayList<EObject>();
        List uris = ModelUtils.getURIsForExternalPackages((ModelType)model);
        for (String uri : uris) {
            String connectionUUID;
            WebModelerConnectionManager cm = (WebModelerConnectionManager)model.getConnectionManager();
            Connection connection = (Connection)cm.findConnection(uri);
            List<EObject> references = ExternalReferenceUtils.getExternalReferences(model, connection);
            ModelType modelType = ModelUtils.getReferencedModelByURI((ModelType)model, (String)uri);
            if (modelType == null) continue;
            ModelType refModel = models.get(modelType.getId());
            if (refModel == null && (connectionUUID = connection.getAttribute("connectionUUID")) != null) {
                refModel = ExternalReferenceUtils.getModelByUUID(models, connectionUUID);
            }
            if (refModel == null) continue;
            for (EObject ref : references) {
                DataTypeType dataType;
                boolean changed;
                DataType data;
                if (ref instanceof DataType && (data = (DataType)ref).getType().getId() != null) {
                    changed = false;
                    if (data.getType().getId().equalsIgnoreCase("struct")) {
                        changed = ExternalReferenceUtils.fixStructuredData((DataType)ref, refModel);
                    }
                    if (data.getType().getId().equalsIgnoreCase("dmsDocument")) {
                        changed = ExternalReferenceUtils.fixDocumentData((DataType)ref, refModel);
                    }
                    if (changed) {
                        referingObjects.add(ref);
                    }
                }
                if (!(ref instanceof DataTypeType) || !((dataType = (DataTypeType)ref).eContainer() instanceof FormalParameterType) || dataType.getCarnotType() == null || !dataType.getCarnotType().equals("struct") && !dataType.getCarnotType().equals("dmsDocument") || !(changed = ExternalReferenceUtils.fixDataTypeType((DataTypeType)ref, refModel))) continue;
                ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)ref);
                referingObjects.add((EObject)process);
            }
        }
        return referingObjects;
    }

    public static ModelType getModelByUUID(Map<String, ModelType> models, String connectionUUID) {
        for (ModelType uuidModel : models.values()) {
            AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)uuidModel, (String)"carnot:model:uuid");
            if (attribute == null || !attribute.getValue().equals(connectionUUID)) continue;
            return uuidModel;
        }
        return null;
    }

    private static void fixConnection(Connection connection, ModelType refModel) {
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)refModel, (String)"carnot:model:uuid");
        String connectionUUID = connection.getAttribute("connectionUUID");
        if (null != connectionUUID) {
            String filename;
            if (null != attribute && attribute.getValue().equals(connectionUUID) && null != (filename = connection.getAttribute("filename"))) {
                String realFilename;
                String lastSegment = null;
                try {
                    lastSegment = filename.substring(filename.lastIndexOf("/") + 1);
                }
                catch (Throwable t) {
                    return;
                }
                if (null != lastSegment && null != refModel.eResource() && !lastSegment.equals(realFilename = refModel.eResource().getURI().toString())) {
                    filename = filename.replaceAll(lastSegment, realFilename);
                    connection.setAttribute("filename", filename);
                }
            }
        } else if (null != attribute) {
            connection.setAttribute("connectionUUID", attribute.getValue());
        }
    }

    private static void fixExternalPackage(ExternalPackage ref, ModelType refModel) {
        if (!ref.getHref().equals(refModel.getId())) {
            ref.setHref(refModel.getId());
            ref.setId(refModel.getId());
            ref.setName(refModel.getName());
        }
    }

    private static void fixAccessPoint(AccessPointType accessPoint, ModelType refModel) {
        String declaredType = AttributeUtil.getAttributeValue((IExtensibleElement)accessPoint, (String)"carnot:engine:dataType");
        if (declaredType != null) {
            TypeDeclarationType declaration;
            String typeID = declaredType.substring(declaredType.indexOf("}") + 1);
            String refModelID = declaredType.substring(declaredType.indexOf("{") + 1, declaredType.indexOf("}"));
            AttributeType uuidAttribute = AttributeUtil.getAttribute((IExtensibleElement)accessPoint, (String)"carnot:connection:uuid");
            if (!(uuidAttribute == null || (declaration = ExternalReferenceUtils.findTypeDeclarationModelUUID(refModel, uuidAttribute.getAttributeValue())) == null || declaration.getId().equals(typeID) && refModel.getId().equals(refModelID))) {
                declaredType = "typeDeclaration:{" + refModel.getId() + "}" + declaration.getId();
                AttributeUtil.setAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:dataType", (String)declaredType);
            }
        }
    }

    public static boolean fixDataTypeType(DataTypeType dataTypeType, ModelType refModel) {
        TypeDeclarationType declaration;
        boolean changed = false;
        ExternalReferenceType ref = dataTypeType.getExternalReference();
        if (ref != null && ref.getUuid() != null && (declaration = ExternalReferenceUtils.findTypeDeclarationModelUUID(refModel, ref.getUuid())) != null && !declaration.getId().equals(ref.getXref())) {
            ref.setXref(declaration.getId());
            changed = true;
        }
        return changed;
    }

    private static void fixData(DataType data, ModelType refModel) {
        if (data.getType() != null) {
            if (data.getType().getId().equals("struct")) {
                ExternalReferenceUtils.fixStructuredData(data, refModel);
            }
            if (data.getType().getId().equals("dmsDocument")) {
                ExternalReferenceUtils.fixDocumentData(data, refModel);
            }
        }
    }

    public static boolean fixDocumentData(DataType data, ModelType refModel) {
        TypeDeclarationType declaration;
        boolean changed = false;
        ExternalReferenceType ref = data.getExternalReference();
        if (ref != null && ref.getUuid() != null && (declaration = ExternalReferenceUtils.findTypeDeclarationModelUUID(refModel, ref.getUuid())) != null) {
            if (!declaration.getId().equals(ref.getXref())) {
                ref.setXref(declaration.getId());
                AttributeType uriAttribute = AttributeUtil.getAttribute((IExtensibleElement)data, (String)"carnot:connection:uri");
                if (uriAttribute != null) {
                    String uri = uriAttribute.getAttributeValue();
                    uri = uri.substring(0, uri.lastIndexOf("/")) + "/" + declaration.getId();
                    AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", (String)uri);
                    AttributeType metaDataAttribute = AttributeUtil.getAttribute((IExtensibleElement)data, (String)"carnot:engine:dms:resourceMetadataSchema");
                    if (metaDataAttribute != null) {
                        String metaData = metaDataAttribute.getAttributeValue();
                        metaData = metaData.substring(0, metaData.indexOf("{")) + "{" + declaration.getId() + "}";
                        AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:dms:resourceMetadataSchema", (String)metaData);
                    }
                }
                changed = true;
            }
            if (!refModel.getId().equals(ref.getLocation())) {
                ref.setLocation(refModel.getId());
                AttributeType metaDataAttribute = AttributeUtil.getAttribute((IExtensibleElement)data, (String)"carnot:engine:dms:resourceMetadataSchema");
                if (metaDataAttribute != null) {
                    String metaData = metaDataAttribute.getAttributeValue();
                    metaData = refModel.getId() + metaData.substring(metaData.indexOf("{"));
                    AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:dms:resourceMetadataSchema", (String)metaData);
                }
                changed = true;
            }
        }
        return changed;
    }

    public static boolean fixStructuredData(DataType data, ModelType refModel) {
        TypeDeclarationType declaration;
        boolean changed = false;
        ExternalReferenceType ref = data.getExternalReference();
        if (ref != null && ref.getUuid() != null && (declaration = ExternalReferenceUtils.findTypeDeclarationModelUUID(refModel, ref.getUuid())) != null) {
            if (!declaration.getId().equals(ref.getXref())) {
                ref.setXref(declaration.getId());
                AttributeType uriAttribute = AttributeUtil.getAttribute((IExtensibleElement)data, (String)"carnot:connection:uri");
                if (uriAttribute != null) {
                    String uri = uriAttribute.getAttributeValue();
                    uri = uri.substring(0, uri.lastIndexOf("/")) + "/" + declaration.getId();
                    AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", (String)uri);
                }
                changed = true;
            }
            if (!refModel.getId().equals(ref.getLocation())) {
                ref.setLocation(refModel.getId());
                changed = true;
            }
        }
        return changed;
    }

    private static void fixActivity(ActivityType activity, ModelType refModel) {
        if (activity.getImplementation().getLiteral().equals(ActivityImplementationType.SUBPROCESS_LITERAL.getLiteral())) {
            ExternalReferenceUtils.fixSubprocessActivity(activity, refModel);
        }
        if (activity.getImplementation().getLiteral().equals(ActivityImplementationType.APPLICATION_LITERAL.getLiteral())) {
            ExternalReferenceUtils.fixApplicationActivity(activity, refModel);
        }
    }

    private static void fixSubprocessActivity(ActivityType activity, ModelType refModel) {
        ProcessDefinitionType process;
        AttributeType uuidAttribute = AttributeUtil.getAttribute((IExtensibleElement)activity, (String)"carnot:connection:uuid");
        if (uuidAttribute != null && (process = ExternalReferenceUtils.findProcessByModelUUID(refModel, uuidAttribute.getAttributeValue())) != null) {
            IdRef externalReference = activity.getExternalRef();
            if (!externalReference.getRef().equals(process.getId())) {
                externalReference.setRef(process.getId());
                AttributeType uriAttribute = AttributeUtil.getAttribute((IExtensibleElement)activity, (String)"carnot:connection:uri");
                if (uriAttribute != null) {
                    String uri = uriAttribute.getAttributeValue();
                    uri = uri.substring(0, uri.lastIndexOf("/")) + "/" + process.getId();
                    AttributeUtil.setAttribute((IExtensibleElement)activity, (String)"carnot:connection:uri", (String)uri);
                }
            }
            if (!externalReference.getPackageRef().getHref().equals(refModel.getId())) {
                externalReference.getPackageRef().setHref(refModel.getId());
                externalReference.getPackageRef().setId(refModel.getId());
                externalReference.getPackageRef().setName(refModel.getId());
            }
        }
    }

    private static void fixApplicationActivity(ActivityType activity, ModelType refModel) {
        ApplicationType application;
        AttributeType uuidAttribute = AttributeUtil.getAttribute((IExtensibleElement)activity, (String)"carnot:connection:uuid");
        if (uuidAttribute != null && (application = ExternalReferenceUtils.findApplicationByModelUUID(refModel, uuidAttribute.getAttributeValue())) != null) {
            IdRef externalReference = activity.getExternalRef();
            if (!externalReference.getRef().equals(application.getId())) {
                externalReference.setRef(application.getId());
                AttributeType uriAttribute = AttributeUtil.getAttribute((IExtensibleElement)activity, (String)"carnot:connection:uri");
                if (uriAttribute != null) {
                    String uri = uriAttribute.getAttributeValue();
                    uri = uri.substring(0, uri.lastIndexOf("/")) + "/" + application.getId();
                    AttributeUtil.setAttribute((IExtensibleElement)activity, (String)"carnot:connection:uri", (String)uri);
                }
            }
            if (!externalReference.getPackageRef().getHref().equals(refModel.getId())) {
                externalReference.getPackageRef().setHref(refModel.getId());
                externalReference.getPackageRef().setId(refModel.getId());
                externalReference.getPackageRef().setName(refModel.getId());
            }
        }
    }

    private static ApplicationType findApplicationByModelUUID(ModelType refModel, String uuid) {
        for (ApplicationType application : refModel.getApplication()) {
            AttributeType uuidAttribute = AttributeUtil.getAttribute((IExtensibleElement)application, (String)"carnot:model:uuid");
            if (uuidAttribute == null || !uuidAttribute.getAttributeValue().equals(uuid)) continue;
            return application;
        }
        return null;
    }

    private static ProcessDefinitionType findProcessByModelUUID(ModelType refModel, String uuid) {
        for (ProcessDefinitionType process : refModel.getProcessDefinition()) {
            AttributeType uuidAttribute = AttributeUtil.getAttribute((IExtensibleElement)process, (String)"carnot:model:uuid");
            if (uuidAttribute == null || !uuidAttribute.getAttributeValue().equals(uuid)) continue;
            return process;
        }
        return null;
    }

    private static TypeDeclarationType findTypeDeclarationModelUUID(ModelType refModel, String uuid) {
        for (TypeDeclarationType declaration : refModel.getTypeDeclarations().getTypeDeclaration()) {
            ExtendedAttributeType uuidAttribute = ExtendedAttributeUtil.getAttribute((ExtendedAttributesType)declaration.getExtendedAttributes(), (String)"carnot:model:uuid");
            if (uuidAttribute == null || !uuidAttribute.getValue().equals(uuid)) continue;
            return declaration;
        }
        return null;
    }

    public static ExternalPackage getPackageRef(URI uri, ModelType targetModel, ModelType sourceModel) {
        ExternalPackage pkg;
        XpdlFactory xFactory = XpdlFactory.eINSTANCE;
        String packageRef = sourceModel.getId();
        ExternalPackages packages = targetModel.getExternalPackages();
        if (packages == null) {
            packages = xFactory.createExternalPackages();
            targetModel.setExternalPackages(packages);
        }
        if ((pkg = packages.getExternalPackage(packageRef)) == null) {
            pkg = xFactory.createExternalPackage();
            pkg.setId(packageRef);
            pkg.setName(sourceModel.getName());
            pkg.setHref(packageRef);
            if (uri != null) {
                LinkAttribute linkAttribute = new LinkAttribute(uri, false, false, "carnot:connection:uri");
                linkAttribute.setLinkInfo((EObject)pkg, false);
            }
            packages.getExternalPackage().add((Object)pkg);
        }
        return pkg;
    }

    public static boolean isModelReferenced(ModelType modelToCheck, Collection<ModelType> models) {
        for (EObject eObject : models) {
            if (!(eObject instanceof ModelType) || modelToCheck.getId().equals(((ModelType)eObject).getId())) continue;
            List uris = ModelUtils.getURIsForExternalPackages((ModelType)((ModelType)eObject));
            for (String uri : uris) {
                ModelType modelType = ModelUtils.getReferencedModelByURI((ModelType)((ModelType)eObject), (String)uri);
                if (modelType == null || !modelToCheck.getId().equals(modelType.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<ModelType> getReferingModels(String refModelID, Collection<ModelType> models) {
        ArrayList<ModelType> referingModels = new ArrayList<ModelType>();
        for (EObject eObject : models) {
            if (!(eObject instanceof ModelType) || refModelID.equals(((ModelType)eObject).getId())) continue;
            List uris = ModelUtils.getURIsForExternalPackages((ModelType)((ModelType)eObject));
            for (String uri : uris) {
                ModelType modelType = ModelUtils.getReferencedModelByURI((ModelType)((ModelType)eObject), (String)uri);
                if (modelType == null || !modelType.getId().equals(refModelID)) continue;
                referingModels.add((ModelType)eObject);
            }
        }
        return referingModels;
    }

    public static TypeDeclarationType getTypeDeclarationFromProxy(DataType data) {
        EObjectProxyHandler proxyHandler;
        AttributeType attribute;
        TypeDeclarationType typeDeclaration = null;
        if (Proxy.getInvocationHandler(data) instanceof EObjectProxyHandler && (attribute = AttributeUtil.getAttribute((IExtensibleElement)(data = (DataType)(proxyHandler = (EObjectProxyHandler)Proxy.getInvocationHandler(data)).getTarget()), (String)"carnot:engine:dataType")) != null) {
            String typeDeclID = attribute.getValue();
            ModelType refModel = ModelUtils.findContainingModel((EObject)data);
            typeDeclaration = refModel.getTypeDeclarations().getTypeDeclaration(typeDeclID);
        }
        return typeDeclaration;
    }
}

