/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.Direction;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.ObjectNotFoundException;
import org.eclipse.stardust.engine.core.pojo.data.JavaDataTypeUtils;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.engine.core.spi.extensions.model.AccessPoint;
import org.eclipse.stardust.engine.extensions.dms.data.DmsConstants;
import org.eclipse.stardust.model.xpdl.builder.BpmModelBuilder;
import org.eclipse.stardust.model.xpdl.builder.activity.BpmApplicationActivityBuilder;
import org.eclipse.stardust.model.xpdl.builder.activity.BpmManualActivityBuilder;
import org.eclipse.stardust.model.xpdl.builder.activity.BpmRouteActivityBuilder;
import org.eclipse.stardust.model.xpdl.builder.activity.BpmSubProcessActivityBuilder;
import org.eclipse.stardust.model.xpdl.builder.common.AbstractElementBuilder;
import org.eclipse.stardust.model.xpdl.builder.connectionhandler.EObjectProxyHandler;
import org.eclipse.stardust.model.xpdl.builder.connectionhandler.IdRefHandler;
import org.eclipse.stardust.model.xpdl.builder.exception.ModelerErrorClass;
import org.eclipse.stardust.model.xpdl.builder.exception.ModelerException;
import org.eclipse.stardust.model.xpdl.builder.initializer.DataStructInitializer;
import org.eclipse.stardust.model.xpdl.builder.initializer.DmsDocumentInitializer;
import org.eclipse.stardust.model.xpdl.builder.initializer.PrimitiveDataInitializer;
import org.eclipse.stardust.model.xpdl.builder.initializer.SerializableDataInitializer;
import org.eclipse.stardust.model.xpdl.builder.model.BpmPackageBuilder;
import org.eclipse.stardust.model.xpdl.builder.participant.BpmConditionalPerformerBuilder;
import org.eclipse.stardust.model.xpdl.builder.participant.BpmOrganizationBuilder;
import org.eclipse.stardust.model.xpdl.builder.participant.BpmRoleBuilder;
import org.eclipse.stardust.model.xpdl.builder.process.BpmProcessDefinitionBuilder;
import org.eclipse.stardust.model.xpdl.builder.strategy.ModelManagementStrategy;
import org.eclipse.stardust.model.xpdl.builder.utils.DateUtils;
import org.eclipse.stardust.model.xpdl.builder.utils.ExternalReferenceUtils;
import org.eclipse.stardust.model.xpdl.builder.utils.LaneParticipantUtil;
import org.eclipse.stardust.model.xpdl.builder.utils.NameIdUtilsExtension;
import org.eclipse.stardust.model.xpdl.builder.utils.WebModelerConnectionManager;
import org.eclipse.stardust.model.xpdl.builder.utils.XPDLFinderUtils;
import org.eclipse.stardust.model.xpdl.builder.variable.BpmDocumentListVariableBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.BpmDocumentVariableBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.BpmEntityVariableBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.BpmPrimitiveVariableBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.BpmSerializableVariableBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.BpmStructVariableBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.CamelApplicationBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.DecoratorApplicationBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.DocumentAccessPointBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.DroolsApplicationBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.ExternalWebApplicationApplicationBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.MessageTransformationApplicationBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.PrimitiveAccessPointBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.StructAccessPointBuilder;
import org.eclipse.stardust.model.xpdl.builder.variable.WebserviceApplicationBuilder;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.AnnotationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DescriptionType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IAccessPointOwner;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IFlowObjectSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IdRef;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.model.xpdl.carnot.ParameterMappingType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TextType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.extensions.ExtensionsFactory;
import org.eclipse.stardust.model.xpdl.carnot.extensions.FormalParameterMappingsType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataInitializer;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.util.IdFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.BasicTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.DataTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.DeclaredTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributeType;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParameterType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParametersType;
import org.eclipse.stardust.model.xpdl.xpdl2.ModeType;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class ModelBuilderFacade {
    private static final String TIMESTAMP_TYPE = "Timestamp";
    private ModelManagementStrategy modelManagementStrategy;

    public ModelBuilderFacade(ModelManagementStrategy modelManagementStrategy) {
        this.modelManagementStrategy = modelManagementStrategy;
    }

    public ModelBuilderFacade() {
    }

    public ModelManagementStrategy getModelManagementStrategy() {
        return this.modelManagementStrategy;
    }

    public void setTeamLeader(OrganizationType organization, RoleType role) {
        if (null != organization.getTeamLead()) {
            this.addOrganizationParticipant(organization, (IModelParticipant)organization.getTeamLead());
        }
        organization.setTeamLead(role);
        if (null != role) {
            EList participants = organization.getParticipant();
            ParticipantType removeType = null;
            for (ParticipantType participant : participants) {
                if (!participant.getParticipant().getId().equals(role.getId())) continue;
                removeType = participant;
            }
            if (removeType != null) {
                participants.remove(removeType);
            }
        }
    }

    public void addOrganizationParticipant(OrganizationType organization, IModelParticipant participant) {
        ParticipantType participantType = AbstractElementBuilder.F_CWM.createParticipantType();
        participantType.setParticipant(participant);
        organization.getParticipant().add((Object)participantType);
    }

    public static List<OrganizationType> getParentOrganizations(ModelType model, IModelParticipant participant) {
        ArrayList<OrganizationType> belongsTo = new ArrayList<OrganizationType>();
        for (OrganizationType org : model.getOrganization()) {
            for (ParticipantType pt : org.getParticipant()) {
                if (!participant.equals(pt.getParticipant())) continue;
                belongsTo.add(org);
            }
        }
        return belongsTo;
    }

    public TypeDeclarationType createTypeDeclaration(ModelType model, String typeID, String typeName) {
        TypeDeclarationType structuredDataType = XpdlFactory.eINSTANCE.createTypeDeclarationType();
        structuredDataType.setName(typeName);
        if (StringUtils.isEmpty((String)typeID)) {
            typeID = NameIdUtilsExtension.createIdFromName((String)typeName);
        }
        structuredDataType.setId(typeID);
        SchemaTypeType schema = XpdlFactory.eINSTANCE.createSchemaTypeType();
        structuredDataType.setSchemaType(schema);
        XSDSchema xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
        xsdSchema.getQNamePrefixToNamespaceMap().put("xsd", "http://www.w3.org/2001/XMLSchema");
        xsdSchema.setSchemaForSchemaQNamePrefix("xsd");
        xsdSchema.setTargetNamespace(TypeDeclarationUtils.computeTargetNamespace((ModelType)model, (String)structuredDataType.getId()));
        String prefix = TypeDeclarationUtils.computePrefix((String)structuredDataType.getId(), xsdSchema.getQNamePrefixToNamespaceMap().keySet());
        xsdSchema.getQNamePrefixToNamespaceMap().put(prefix, xsdSchema.getTargetNamespace());
        xsdSchema.setSchemaLocation("urn:internal:" + structuredDataType.getId());
        schema.setSchema(xsdSchema);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        xsdComplexTypeDefinition.setName(structuredDataType.getId());
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        XSDModelGroup modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        particle.setContent((XSDParticleContent)modelGroup);
        modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)particle);
        xsdSchema.getContents().add((Object)xsdComplexTypeDefinition);
        XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElementDeclaration.setName(structuredDataType.getId());
        xsdElementDeclaration.setTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdSchema.getContents().add((Object)xsdElementDeclaration);
        schema.getSchema().updateElement(true);
        model.getTypeDeclarations().getTypeDeclaration().add((Object)structuredDataType);
        ModelBuilderFacade.setAttribute(structuredDataType, "carnot:model:uuid", UUID.randomUUID().toString());
        return structuredDataType;
    }

    public FormalParameterType createPrimitiveParameter(ProcessDefinitionType processInterface, DataType data, String id, String name, String primitiveTypeID, ModeType mode) {
        return this.createPrimitiveParameter(processInterface, data, id, name, primitiveTypeID, mode, null);
    }

    public FormalParameterType createPrimitiveParameter(ProcessDefinitionType processInterface, DataType data, String id, String name, String primitiveTypeID, ModeType mode, String structTypeFullID) {
        String refModelId = null;
        String structTypeId = null;
        XpdlFactory xpdlFactory = XpdlPackage.eINSTANCE.getXpdlFactory();
        FormalParameterType parameterType = this.createFormalParameter(processInterface, id, name, mode, xpdlFactory);
        FormalParameterMappingsType parameterMappingsType = processInterface.getFormalParameterMappings();
        if (parameterMappingsType == null) {
            parameterMappingsType = ExtensionsFactory.eINSTANCE.createFormalParameterMappingsType();
        }
        DataTypeType dataTypeType = XpdlFactory.eINSTANCE.createDataTypeType();
        if (StringUtils.isNotEmpty((String)structTypeFullID)) {
            String[] splittedIds = structTypeFullID.split(":");
            if (splittedIds.length > 1) {
                refModelId = splittedIds[0];
                structTypeId = splittedIds[1];
            } else {
                structTypeId = splittedIds[0];
            }
            DeclaredTypeType declaredType = xpdlFactory.createDeclaredTypeType();
            declaredType.setId(structTypeId);
            dataTypeType.setDeclaredType(declaredType);
        } else {
            BasicTypeType basicType = xpdlFactory.createBasicTypeType();
            if (!StringUtils.isEmpty((String)primitiveTypeID)) {
                basicType.setType(this.getPrimitiveType(primitiveTypeID));
            }
            dataTypeType.setBasicType(basicType);
        }
        parameterType.setDataType(dataTypeType);
        String typeId = "primitive";
        dataTypeType.setCarnotType(typeId);
        if (data != null) {
            parameterMappingsType.setMappedData(parameterType, data);
        }
        processInterface.setFormalParameterMappings(parameterMappingsType);
        return parameterType;
    }

    public void setDataForFormalParameter(ProcessDefinitionType processInterface, String parameterID, DataType data) {
        FormalParameterType parameterType = processInterface.getFormalParameters().getFormalParameter(parameterID);
        if (parameterType != null) {
            processInterface.getFormalParameterMappings().setMappedData(parameterType, data);
        }
    }

    public FormalParameterType createStructuredParameter(ProcessDefinitionType processInterface, DataType data, String id, String name, String structTypeFullID, ModeType mode) {
        String[] splittedIds;
        XpdlFactory xpdlFactory = XpdlPackage.eINSTANCE.getXpdlFactory();
        FormalParameterType parameterType = this.createFormalParameter(processInterface, id, name, mode, xpdlFactory);
        DataTypeType dataTypeType = xpdlFactory.createDataTypeType();
        String typeId = "struct";
        parameterType.setDataType(dataTypeType);
        dataTypeType.setCarnotType(typeId);
        String refModelId = null;
        String structTypeId = null;
        if (structTypeFullID == null) {
            structTypeFullID = "TO_BE_DEFINED";
        }
        if ((splittedIds = structTypeFullID.split(":")).length > 1) {
            refModelId = splittedIds[0];
            structTypeId = splittedIds[1];
        } else {
            structTypeId = splittedIds[0];
        }
        ModelType model = ModelUtils.findContainingModel((EObject)processInterface);
        if (refModelId == null || model != null && refModelId.equals(model.getId())) {
            DeclaredTypeType declaredType = xpdlFactory.createDeclaredTypeType();
            declaredType.setId(structTypeId);
            dataTypeType.setDeclaredType(declaredType);
        } else if (model != null) {
            ModelType providerModel = this.findModel(refModelId);
            ExternalReferenceUtils.createStructReferenceForFormalParameter(parameterType, structTypeId, model, providerModel);
        }
        FormalParameterMappingsType parameterMappingsType = processInterface.getFormalParameterMappings();
        if (parameterMappingsType == null) {
            parameterMappingsType = ExtensionsFactory.eINSTANCE.createFormalParameterMappingsType();
        }
        if (data != null) {
            parameterMappingsType.setMappedData(parameterType, data);
        }
        processInterface.setFormalParameterMappings(parameterMappingsType);
        return parameterType;
    }

    public FormalParameterType createDocumentParameter(ProcessDefinitionType processInterface, DataType data, String id, String name, String structTypeFullID, ModeType mode) {
        String[] splittedIds;
        XpdlFactory xpdlFactory = XpdlPackage.eINSTANCE.getXpdlFactory();
        FormalParameterType parameterType = this.createFormalParameter(processInterface, id, name, mode, xpdlFactory);
        DataTypeType dataTypeType = xpdlFactory.createDataTypeType();
        String typeId = "dmsDocument";
        parameterType.setDataType(dataTypeType);
        dataTypeType.setCarnotType(typeId);
        String refModelId = null;
        String structTypeId = null;
        if (structTypeFullID == null) {
            structTypeFullID = "TO_BE_DEFINED";
        }
        if ((splittedIds = structTypeFullID.split(":")).length > 1) {
            refModelId = splittedIds[0];
            structTypeId = splittedIds[1];
        } else {
            structTypeId = splittedIds[0];
        }
        ModelType model = ModelUtils.findContainingModel((EObject)processInterface);
        if (refModelId == null || model != null && refModelId.equals(model.getId())) {
            DeclaredTypeType declaredType = xpdlFactory.createDeclaredTypeType();
            declaredType.setId(structTypeId);
            dataTypeType.setDeclaredType(declaredType);
        } else if (model != null) {
            ModelType providerModel = this.findModel(refModelId);
            ExternalReferenceUtils.createStructReferenceForFormalParameter(parameterType, structTypeId, model, providerModel);
        }
        FormalParameterMappingsType parameterMappingsType = processInterface.getFormalParameterMappings();
        if (parameterMappingsType == null) {
            parameterMappingsType = ExtensionsFactory.eINSTANCE.createFormalParameterMappingsType();
        }
        if (data != null) {
            parameterMappingsType.setMappedData(parameterType, data);
        }
        processInterface.setFormalParameterMappings(parameterMappingsType);
        return parameterType;
    }

    private FormalParameterType createFormalParameter(ProcessDefinitionType processInterface, String id, String name, ModeType mode, XpdlFactory xpdlFactory) {
        FormalParameterType parameterType;
        FormalParametersType parametersType;
        boolean forceSuffix = false;
        if (StringUtils.isEmpty((String)name.trim())) {
            if (StringUtils.isEmpty((String)id.trim())) {
                name = "FormalParameter";
                forceSuffix = true;
            } else {
                name = id;
            }
        }
        if ((parametersType = processInterface.getFormalParameters()) == null) {
            parametersType = xpdlFactory.createFormalParametersType();
            processInterface.setFormalParameters(parametersType);
        }
        if ((parameterType = parametersType.getFormalParameter(id)) == null) {
            parameterType = xpdlFactory.createFormalParameterType();
            parametersType.addFormalParameter(parameterType);
        }
        IdFactory idFactory = new IdFactory(null, name.trim(), XpdlPackage.eINSTANCE.getFormalParameterType(), (EStructuralFeature)XpdlPackage.eINSTANCE.getFormalParameterType_Id(), (EStructuralFeature)XpdlPackage.eINSTANCE.getFormalParameterType_Name());
        List existing = CollectionUtils.copyList((List)parametersType.getFormalParameter());
        existing.remove(parameterType);
        idFactory.computeNames(existing, forceSuffix);
        id = idFactory.getId();
        name = idFactory.getName();
        if (!id.equals(parameterType.getId())) {
            parameterType.setId(id);
        }
        if (!name.equals(parameterType.getName())) {
            parameterType.setName(name);
        }
        if (!CompareHelper.areEqual((Object)mode, (Object)parameterType.getMode())) {
            parameterType.setMode(mode);
        }
        return parameterType;
    }

    public AccessPoint createJavaAccessPoint(String id, String name, String clazz, Direction direction, boolean browsable, Object characteristics) {
        if (clazz == null) {
            clazz = "java.util.Map";
        }
        return JavaDataTypeUtils.createIntrinsicAccessPoint((String)id, (String)name, (String)clazz, (Direction)direction, (boolean)browsable, (Object)characteristics);
    }

    public AccessPointType createPrimitiveAccessPoint(IAccessPointOwner application, String id, String name, String primaryDataTypeID, String direction) {
        return (AccessPointType)((PrimitiveAccessPointBuilder)BpmModelBuilder.newPrimitiveAccessPoint(application).withIdAndName(id, name)).withType(primaryDataTypeID).withDirection(direction).build();
    }

    public AccessPointType createStructuredAccessPoint(IAccessPointOwner application, String id, String name, String structTypeFullID, String direction) {
        AccessPointType accessPoint = (AccessPointType)((StructAccessPointBuilder)BpmModelBuilder.newStructuredAccessPoint(application).withIdAndName(id, name)).withType(structTypeFullID).withDirection(direction).build();
        String declaredType = AttributeUtil.getAttributeValue((IExtensibleElement)accessPoint, (String)"carnot:engine:dataType");
        if (declaredType != null && declaredType.indexOf("{") > 0) {
            ModelType refModel;
            String refModelID = declaredType.substring(declaredType.indexOf("{") + 1, declaredType.indexOf("}"));
            String typeID = declaredType.substring(declaredType.indexOf("}") + 1);
            if (!typeID.equals("TO_BE_DEFINED") && (refModel = this.findModel(refModelID)) != null) {
                ExternalReferenceUtils.createStructReferenceForAccessPoint(accessPoint, typeID, refModel);
            }
        }
        return accessPoint;
    }

    public AccessPointType createDocumentAccessPoint(IAccessPointOwner application, String id, String name, String direction) {
        return (AccessPointType)((DocumentAccessPointBuilder)BpmModelBuilder.newDocumentAccessPoint(application).withIdAndName(id, name)).withDirection(direction).build();
    }

    public void setProcessImplementation(ProcessDefinitionType processInterface, ProcessDefinitionType processImplementation) {
        ModelType interfaceModel = ModelUtils.findContainingModel((EObject)processInterface);
        ModelType implementationModel = ModelUtils.findContainingModel((EObject)processImplementation);
        ExternalPackage packageRef = implementationModel.getExternalPackages().getExternalPackage(interfaceModel.getId());
        IdRef idRef = CarnotWorkflowModelFactory.eINSTANCE.createIdRef();
        idRef.setRef(processInterface.getId());
        idRef.setPackageRef(packageRef);
        processImplementation.setExternalRef(idRef);
        IdRefHandler.adapt((IIdentifiableModelElement)processImplementation);
        FormalParameterMappingsType parameterMappings = ExtensionsFactory.eINSTANCE.createFormalParameterMappingsType();
        FormalParametersType referencedParametersType = processInterface.getFormalParameters();
        FormalParametersType formalParameters = XpdlFactory.eINSTANCE.createFormalParametersType();
        for (FormalParameterType referencedParameterType : referencedParametersType.getFormalParameter()) {
            FormalParameterType parameterType = ModelUtils.cloneFormalParameterType((FormalParameterType)referencedParameterType, null);
            formalParameters.addFormalParameter(parameterType);
            parameterMappings.setMappedData(parameterType, null);
        }
        processImplementation.setFormalParameters(formalParameters);
        processImplementation.setFormalParameterMappings(parameterMappings);
    }

    public void setFormalParameter(ProcessDefinitionType implementingProcess, String parameterID, DataType dataType) {
        FormalParameterType formalParameterType = implementingProcess.getFormalParameters().getFormalParameter(parameterID);
        implementingProcess.getFormalParameterMappings().setMappedData(formalParameterType, dataType);
    }

    public DataType createDocumentData(ModelType model, String dataID, String dataName, String typeDeclarationID) {
        ModelType typeDeclarationModel = null;
        String sourceModelID = null;
        BpmDocumentVariableBuilder documentVariable = BpmModelBuilder.newDocumentVariable(model);
        if (!StringUtils.isEmpty((String)typeDeclarationID)) {
            sourceModelID = this.getModelId(typeDeclarationID);
            if (sourceModelID != null) {
                typeDeclarationModel = this.getModelManagementStrategy().getModels().get(sourceModelID);
            }
            typeDeclarationID = this.stripFullId(typeDeclarationID);
            documentVariable.setTypeDeclarationModel(typeDeclarationModel);
            documentVariable.setTypeDeclaration(typeDeclarationID);
        }
        DataType data = (DataType)((BpmDocumentVariableBuilder)documentVariable.withIdAndName(dataID, dataName)).build();
        return data;
    }

    public DataType createDocumentListData(ModelType model, String dataID, String dataName, String typeDeclarationID) {
        BpmDocumentListVariableBuilder documentVariable = BpmModelBuilder.newDocumentListVariable(model);
        if (!StringUtils.isEmpty((String)typeDeclarationID)) {
            String sourceModelID = this.getModelId(typeDeclarationID);
            if (sourceModelID != null) {
                documentVariable.setTypeDeclarationModel(this.getModelManagementStrategy().getModels().get(sourceModelID));
            }
            documentVariable.setTypeDeclaration(this.stripFullId(typeDeclarationID));
        }
        return (DataType)((BpmDocumentListVariableBuilder)documentVariable.withIdAndName(dataID, dataName)).build();
    }

    public DataType createStructuredData(ModelType model, String dataID, String dataName, String typeFullID) {
        String sourceModelID = this.getModelId(typeFullID);
        ModelType typeDeclarationModel = this.getModelManagementStrategy().getModels().get(sourceModelID);
        BpmStructVariableBuilder structVariable = BpmModelBuilder.newStructVariable(model);
        structVariable.setTypeDeclarationModel(typeDeclarationModel);
        String[] ids = typeFullID.split(":");
        String typeValue = null;
        if (ids.length > 1) {
            typeValue = this.stripFullId(typeFullID);
        }
        DataType data = (DataType)((BpmStructVariableBuilder)structVariable.withIdAndName(dataID, dataName)).ofType(typeValue).build();
        return data;
    }

    public void convertDataType(DataType data, String targetTypeID) {
        if (data.getType().getId().equals(targetTypeID)) {
            return;
        }
        data.getAttribute().clear();
        ModelType model = ModelUtils.findContainingModel((EObject)data);
        data.setType((org.eclipse.stardust.model.xpdl.carnot.DataTypeType)ModelUtils.findIdentifiableElement((List)model.getDataType(), (String)targetTypeID));
        IDataInitializer init = this.getInitializer(targetTypeID);
        init.initialize(data, (List)data.getAttribute());
    }

    public void updatePrimitiveData(DataType data, String primitiveTypeID) {
        AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:type", (String)Type.class.getName(), (String)primitiveTypeID);
    }

    public void updateTypeForPrimitive(DataType data, String typeFullID) {
        ModelType model = ModelUtils.findContainingModel((EObject)data);
        String declaredTypeID = null;
        String sourceModelID = this.getModelId(typeFullID);
        String declarationID = this.stripFullId(typeFullID);
        if (sourceModelID.equals(model.getId())) {
            declaredTypeID = declarationID;
        } else {
            declaredTypeID = "typeDeclaration:{" + sourceModelID + "}" + declarationID;
            ModelType typeDeclarationModel = this.getModelManagementStrategy().getModels().get(sourceModelID);
            ExternalReferenceUtils.createStructReferenceForPrimitive(data, model, declarationID, typeDeclarationModel);
        }
        AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:dataType", (String)declaredTypeID);
    }

    public void updateStructuredDataType(DataType data, String typeFullID) {
        ModelType model = ModelUtils.findContainingModel((EObject)data);
        String sourceModelID = this.getModelId(typeFullID);
        ModelType typeDeclarationModel = this.getModelManagementStrategy().getModels().get(sourceModelID);
        if (typeDeclarationModel != null) {
            String declarationID = this.stripFullId(typeFullID);
            TypeDeclarationType typeDeclaration = this.findTypeDeclaration(typeFullID);
            if (sourceModelID.equals(model.getId())) {
                data.setExternalReference(null);
                AttributeType attribute = AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:dataType", (String)declarationID);
                ModelUtils.setReference((AttributeType)attribute, (ModelType)model, (String)"struct");
                AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", null);
            } else {
                ExternalReferenceUtils.createExternalReferenceToTypeDeclaration(data, model, typeDeclarationModel, typeDeclaration);
            }
        } else if (typeFullID == null || typeFullID.equals("TO_BE_DEFINED")) {
            data.setExternalReference(null);
            AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:dataType", null);
            AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", null);
        }
    }

    public void updateDocumentDataType(DataType data, String typeFullID) {
        ModelType model = ModelUtils.findContainingModel((EObject)data);
        String sourceModelID = this.getModelId(typeFullID);
        ModelType typeDeclarationModel = this.getModelManagementStrategy().getModels().get(sourceModelID);
        if (typeDeclarationModel != null) {
            String qualifiedId = null;
            String declarationID = this.stripFullId(typeFullID);
            TypeDeclarationType typeDeclaration = this.findTypeDeclaration(typeFullID);
            if (sourceModelID.equals(model.getId())) {
                data.setExternalReference(null);
                AttributeType attribute = AttributeUtil.setAttribute((IExtensibleElement)data, (String)DmsConstants.RESOURCE_METADATA_SCHEMA_ATT, (String)declarationID);
                ModelUtils.setReference((AttributeType)attribute, (ModelType)model, (String)"struct");
                AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:connection:uri", null);
                qualifiedId = typeDeclaration.getId();
            } else {
                ExternalReferenceUtils.createExternalReferenceToDocument(data, model, typeDeclarationModel, typeDeclaration);
                qualifiedId = typeDeclarationModel.getId() + "{" + typeDeclaration.getId() + "}";
            }
            AttributeUtil.setAttribute((IExtensibleElement)data, (String)DmsConstants.RESOURCE_METADATA_SCHEMA_ATT, (String)qualifiedId);
        }
    }

    public DataType createEntityData(ModelType model, String dataID, String dataName, String className, String value) {
        BpmEntityVariableBuilder<Object> entityVariable = BpmModelBuilder.newEntityVariable(model);
        entityVariable.withIdAndName(dataID, dataName);
        return (DataType)entityVariable.build();
    }

    public DataType createSerializableData(ModelType model, String dataID, String dataName, String className, String value) {
        BpmSerializableVariableBuilder<Object> serializableVariable = BpmModelBuilder.newSerializableVariable(model);
        serializableVariable.withIdAndName(dataID, dataName);
        serializableVariable.ofClass(className, value);
        return (DataType)serializableVariable.build();
    }

    public DataType createPrimitiveData(ModelType model, String dataID, String dataName, String primitiveTypeID) {
        Type type = null;
        if (primitiveTypeID.equals("string")) {
            type = Type.String;
        } else if (primitiveTypeID.equals("date")) {
            type = Type.Calendar;
        } else if (primitiveTypeID.equals("Calendar")) {
            type = Type.Calendar;
        } else if (primitiveTypeID.equals("timestamp")) {
            type = Type.Timestamp;
        } else if (primitiveTypeID.equals("integer")) {
            type = Type.Integer;
        } else if (primitiveTypeID.equals("double")) {
            type = Type.Double;
        } else if (primitiveTypeID.equals("decimal")) {
            type = Type.Money;
        } else if (primitiveTypeID.equals("Enumeration")) {
            type = Type.Enumeration;
        }
        DataType data = (DataType)((BpmPrimitiveVariableBuilder)BpmModelBuilder.newPrimitiveVariable(model).withIdAndName(dataID, dataName)).ofType(type).build();
        return data;
    }

    public DataType createData(ModelType model, org.eclipse.stardust.model.xpdl.carnot.DataTypeType type, String id, String name, String description) {
        CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
        DataType data = factory.createDataType();
        data.setId(id);
        data.setName(name);
        data.setType(type);
        data.setDescription(ModelUtils.createDescription((String)description));
        data.setPredefined(true);
        model.getData().add((Object)data);
        return data;
    }

    public void createAttribute(DataType data, String name, String type, String value) {
        CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
        AttributeType attribute = factory.createAttributeType();
        attribute.setName(name);
        if (type != null) {
            attribute.setType(type);
        }
        attribute.setValue(value);
        data.getAttribute().add((Object)attribute);
    }

    public DataType importData(ModelType model, String dataFullID) throws IllegalArgumentException {
        DataType consumerData;
        DataType data = null;
        String dataModelId = this.getModelId(dataFullID);
        ModelType dataModel = this.getModelManagementStrategy().getModels().get(dataModelId);
        data = XPDLFinderUtils.findData(dataModel, this.stripFullId(dataFullID));
        if (data == null && dataFullID.endsWith("PROCESS_ATTACHMENTS")) {
            data = this.createProcessAttachementData(model);
        }
        if (model != dataModel && (consumerData = XPDLFinderUtils.findData(model, this.stripFullId(dataFullID))) != null) {
            if (!dataModelId.equals(model.getId()) && this.isExternalReference((EObject)consumerData)) {
                ModelType referencedModel;
                URI proxyUri = ((InternalEObject)consumerData).eProxyURI();
                if (proxyUri == null) {
                    String uri = AttributeUtil.getAttributeValue((IExtensibleElement)consumerData, (String)"carnot:connection:uri");
                    try {
                        proxyUri = URI.createURI((String)uri);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((referencedModel = ModelUtils.getModelByProxyURI((ModelType)model, (URI)proxyUri)) != null) {
                    if (ModelUtils.hasCircularDependency((String)model.getId(), (ModelType)referencedModel)) {
                        throw new ModelerException(ModelerErrorClass.CIRCULAR_DEPENDENCY);
                    }
                    if (!referencedModel.getId().equals(dataModelId)) {
                        throw new IllegalArgumentException("Data with same Id already exists.");
                    }
                }
            }
            return consumerData;
        }
        if (!dataModelId.equals(model.getId())) {
            if (ModelUtils.hasCircularDependency((String)model.getId(), (ModelType)dataModel)) {
                throw new ModelerException(ModelerErrorClass.CIRCULAR_DEPENDENCY);
            }
            data = EObjectProxyHandler.importElement(model, data);
        }
        return data;
    }

    public IModelParticipant importParticipant(ModelType model, String participantFullId) {
        IModelParticipant participant = null;
        String participantModelId = this.getModelId(participantFullId);
        String participantId = this.stripFullId(participantFullId);
        ModelType participantModel = this.getModelManagementStrategy().getModels().get(participantModelId);
        participant = XPDLFinderUtils.findParticipant(participantModel, participantId);
        if (!participantModelId.equals(model.getId())) {
            IModelParticipant localParticipant = null;
            try {
                localParticipant = XPDLFinderUtils.findParticipant(model, participantId);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            if (localParticipant == null) {
                if (ModelUtils.hasCircularDependency((String)model.getId(), (ModelType)participantModel)) {
                    throw new ModelerException(ModelerErrorClass.CIRCULAR_DEPENDENCY);
                }
                localParticipant = EObjectProxyHandler.importElement(model, participant);
            }
            participant = localParticipant;
        }
        return participant;
    }

    public LaneSymbol createLane(ModelType model, ProcessDefinitionType processDefinition, String participantFullID, String laneID, String laneName, String orientationID, int xProperty, int yProperty, int widthProperty, int heightProperty, PoolSymbol parentSymbol) {
        LaneSymbol laneSymbol = AbstractElementBuilder.F_CWM.createLaneSymbol();
        laneSymbol.setName(laneName);
        if (StringUtils.isEmpty((String)laneID)) {
            laneID = NameIdUtilsExtension.createIdFromName(null, (EObject)laneSymbol);
        }
        laneSymbol.setId(laneID);
        parentSymbol.getLanes().add((Object)laneSymbol);
        laneSymbol.setParentPool(parentSymbol);
        ((PoolSymbol)((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols().get(0)).getChildLanes().add((Object)laneSymbol);
        laneSymbol.setXPos((long)xProperty);
        laneSymbol.setYPos((long)yProperty);
        laneSymbol.setWidth(widthProperty);
        laneSymbol.setHeight(heightProperty);
        if (orientationID != null && orientationID.equals("DIAGRAM_FLOW_ORIENTATION_HORIZONTAL")) {
            laneSymbol.setOrientation(OrientationType.HORIZONTAL_LITERAL);
        } else {
            laneSymbol.setOrientation(OrientationType.VERTICAL_LITERAL);
        }
        if (participantFullID != null) {
            LaneParticipantUtil.setParticipant(laneSymbol, this.importParticipant(model, participantFullID));
        }
        return laneSymbol;
    }

    public ActivitySymbolType createActivitySymbol(ModelType model, ActivityType activity, ProcessDefinitionType processDefinition, String parentLaneID, int xProperty, int yProperty, int widthProperty, int heightProperty) {
        ActivitySymbolType activitySymbol = AbstractElementBuilder.F_CWM.createActivitySymbolType();
        LaneSymbol parentLaneSymbol = XPDLFinderUtils.findLaneInProcess(processDefinition, parentLaneID);
        activitySymbol.setXPos((long)xProperty - parentLaneSymbol.getXPos());
        activitySymbol.setYPos((long)yProperty - parentLaneSymbol.getYPos());
        activitySymbol.setWidth(widthProperty);
        activitySymbol.setHeight(heightProperty);
        activitySymbol.setActivity(activity);
        activity.getActivitySymbols().add((Object)activitySymbol);
        ((DiagramType)processDefinition.getDiagram().get(0)).getActivitySymbol().add((Object)activitySymbol);
        parentLaneSymbol.getActivitySymbol().add((Object)activitySymbol);
        return activitySymbol;
    }

    public AnnotationSymbolType createAnnotationSymbol(ModelType model, ProcessDefinitionType processDefinition, String parentLaneID, int xProperty, int yProperty, int widthProperty, int heightProperty, String content) {
        AnnotationSymbolType annotationSymbol = AbstractElementBuilder.F_CWM.createAnnotationSymbolType();
        LaneSymbol parentLaneSymbol = XPDLFinderUtils.findLaneInProcess(processDefinition, parentLaneID);
        annotationSymbol.setXPos((long)xProperty - parentLaneSymbol.getXPos());
        annotationSymbol.setYPos((long)yProperty - parentLaneSymbol.getYPos());
        annotationSymbol.setWidth(widthProperty);
        annotationSymbol.setHeight(heightProperty);
        if (StringUtils.isNotEmpty((String)content)) {
            TextType text = AbstractElementBuilder.F_CWM.createTextType();
            text.getMixed().add((Object)FeatureMapUtil.createRawTextEntry((String)content));
            annotationSymbol.setText(text);
        }
        ((DiagramType)processDefinition.getDiagram().get(0)).getAnnotationSymbol().add((Object)annotationSymbol);
        parentLaneSymbol.getAnnotationSymbol().add((Object)annotationSymbol);
        return annotationSymbol;
    }

    public DataSymbolType createDataSymbol(ModelType model, DataType data, ProcessDefinitionType processDefinition, String parentLaneID, int xProperty, int yProperty, int widthProperty, int heightProperty) {
        DataSymbolType dataSymbol = AbstractElementBuilder.F_CWM.createDataSymbolType();
        LaneSymbol parentLaneSymbol = XPDLFinderUtils.findLaneInProcess(processDefinition, parentLaneID);
        dataSymbol.setData(data);
        ((DiagramType)processDefinition.getDiagram().get(0)).getDataSymbol().add((Object)dataSymbol);
        dataSymbol.setXPos((long)xProperty - parentLaneSymbol.getXPos());
        dataSymbol.setYPos((long)yProperty - parentLaneSymbol.getYPos());
        dataSymbol.setWidth(widthProperty);
        dataSymbol.setHeight(heightProperty);
        parentLaneSymbol.getDataSymbol().add((Object)dataSymbol);
        return dataSymbol;
    }

    public RoleType createRole(ModelType model, String roleID, String roleName) {
        RoleType role = (RoleType)((BpmRoleBuilder)BpmModelBuilder.newRole(model).withIdAndName(roleID, roleName)).build();
        return role;
    }

    public ConditionalPerformerType createConditionalPerformer(ModelType model, String conditionalPerformerID, String conditionalPerformerName) {
        ConditionalPerformerType conditionalPerformer = (ConditionalPerformerType)((BpmConditionalPerformerBuilder)BpmModelBuilder.newConditionalPerformer(model).withIdAndName(conditionalPerformerID, conditionalPerformerName)).build();
        return conditionalPerformer;
    }

    public OrganizationType createOrganization(ModelType model, String orgID, String orgName) {
        OrganizationType org = (OrganizationType)((BpmOrganizationBuilder)BpmModelBuilder.newOrganization(model).withIdAndName(orgID, orgName)).build();
        return org;
    }

    public ApplicationType createApplication(ModelType model, String applicationID, String applicationName, String applicationTypeID) {
        if (applicationTypeID.equalsIgnoreCase("messageTransformationBean")) {
            return (ApplicationType)((MessageTransformationApplicationBuilder)BpmModelBuilder.newMessageTransformationApplication(model).withIdAndName(applicationID, applicationName)).build();
        }
        if (applicationTypeID.equalsIgnoreCase("externalWebApp")) {
            return (ApplicationType)((ExternalWebApplicationApplicationBuilder)BpmModelBuilder.newExternalWebApplication(model).withIdAndName(applicationID, applicationName)).build();
        }
        if (applicationTypeID.equalsIgnoreCase("webservice")) {
            return (ApplicationType)((WebserviceApplicationBuilder)BpmModelBuilder.newWebserviceApplication(model).withIdAndName(applicationID, applicationName)).build();
        }
        if (applicationTypeID.equalsIgnoreCase("decoratorApp")) {
            return (ApplicationType)((DecoratorApplicationBuilder)BpmModelBuilder.newDecoratorApplication(model).withIdAndName(applicationID, applicationName)).build();
        }
        if (applicationTypeID.equalsIgnoreCase("camelSpringProducerApplication")) {
            return (ApplicationType)((CamelApplicationBuilder)BpmModelBuilder.newCamelApplication(model).withIdAndName(applicationID, applicationName)).build();
        }
        if (applicationTypeID.equalsIgnoreCase("rulesEngineBean")) {
            IdFactory idFactory = new IdFactory(applicationID, applicationName);
            idFactory.computeNames((List)model.getApplication(), true);
            applicationID = idFactory.getId();
            applicationName = idFactory.getName();
            return (ApplicationType)((DroolsApplicationBuilder)BpmModelBuilder.newDroolsApplication(model).withIdAndName(applicationID, applicationName)).build();
        }
        return null;
    }

    public ActivityType createActivity(ModelType model, ProcessDefinitionType processDefinition, String activityType, String taskType, String activityID, String activityName, String participantFullID, String applicationFullID, String subProcessFullID) {
        ActivityType activity = null;
        if ("Task".equals(activityType)) {
            ModelBuilderFacade.setAttribute(activity, "taskType", taskType);
            if ("none".equals(taskType)) {
                activity = (ActivityType)((BpmRouteActivityBuilder)BpmModelBuilder.newRouteActivity(processDefinition).withIdAndName(activityID, activityName)).build();
                activity.setImplementation(ActivityImplementationType.ROUTE_LITERAL);
            } else if ("manual".equals(taskType)) {
                activity = participantFullID != null ? (ActivityType)((BpmManualActivityBuilder)((BpmManualActivityBuilder)BpmModelBuilder.newManualActivity(processDefinition).withIdAndName(activityID, activityName)).havingDefaultPerformer(this.stripFullId(participantFullID))).build() : (ActivityType)((BpmManualActivityBuilder)BpmModelBuilder.newManualActivity(processDefinition).withIdAndName(activityID, activityName)).build();
                activity.setImplementation(ActivityImplementationType.MANUAL_LITERAL);
            } else if ("user".equals(taskType) || "service".equals(taskType) || "script".equals(taskType) || "send".equals(taskType) || "receive".equals(taskType) || "rule".equals(taskType)) {
                String stripFullId_ = this.getModelId(applicationFullID);
                if (StringUtils.isEmpty((String)stripFullId_)) {
                    stripFullId_ = model.getId();
                }
                ApplicationType application = this.getApplication(stripFullId_, this.stripFullId(applicationFullID));
                ModelType applicationModel = ModelUtils.findContainingModel((EObject)application);
                BpmApplicationActivityBuilder applicationActivity = BpmModelBuilder.newApplicationActivity(processDefinition);
                applicationActivity.setApplicationModel(applicationModel);
                BpmApplicationActivityBuilder activityBuilder = (BpmApplicationActivityBuilder)applicationActivity.withIdAndName(activityID, activityName);
                if (null != application) {
                    activityBuilder.invokingApplication(application);
                }
                activity = (ActivityType)activityBuilder.build();
                if ("user".equals(taskType) && participantFullID != null) {
                    activity.setPerformer(this.importParticipant(model, participantFullID));
                }
            }
        } else if ("Subprocess".equals(activityType)) {
            String stripFullId = this.getModelId(subProcessFullID);
            if (StringUtils.isEmpty((String)stripFullId)) {
                stripFullId = model.getId();
            }
            ProcessDefinitionType subProcessDefinition = XPDLFinderUtils.findProcessDefinition(this.getModelManagementStrategy().getModels().get(stripFullId), this.stripFullId(subProcessFullID));
            ModelType subProcessModel = ModelUtils.findContainingModel((EObject)subProcessDefinition);
            BpmSubProcessActivityBuilder subProcessActivity = BpmModelBuilder.newSubProcessActivity(processDefinition);
            subProcessActivity.setSubProcessModel(subProcessModel);
            activity = (ActivityType)((BpmSubProcessActivityBuilder)subProcessActivity.withIdAndName(activityID, activityName)).invokingProcess(XPDLFinderUtils.findProcessDefinition(this.getModelManagementStrategy().getModels().get(subProcessModel.getId()), this.stripFullId(subProcessFullID))).build();
        }
        return activity;
    }

    public ProcessDefinitionType createProcess(ModelType model, String processName, String processID) {
        ProcessDefinitionType processDefinition = (ProcessDefinitionType)((BpmProcessDefinitionBuilder)BpmModelBuilder.newProcessDefinition(model).withIdAndName(processID, processName)).build();
        DiagramType diagram = AbstractElementBuilder.F_CWM.createDiagramType();
        diagram.setMode(DiagramModeType.MODE_450_LITERAL);
        diagram.setOrientation(OrientationType.VERTICAL_LITERAL);
        diagram.setName("Diagram 1");
        PoolSymbol poolSymbol = AbstractElementBuilder.F_CWM.createPoolSymbol();
        diagram.getPoolSymbols().add((Object)poolSymbol);
        poolSymbol.setXPos(0L);
        poolSymbol.setYPos(0L);
        poolSymbol.setWidth(500);
        poolSymbol.setHeight(600);
        poolSymbol.setName("DEFAULT_POOL");
        poolSymbol.setId("DEFAULT_POOL");
        poolSymbol.setOrientation(OrientationType.VERTICAL_LITERAL);
        LaneSymbol laneSymbol = AbstractElementBuilder.F_CWM.createLaneSymbol();
        poolSymbol.getChildLanes().add((Object)laneSymbol);
        laneSymbol.setParentPool(poolSymbol);
        laneSymbol.setId("DefaultLane");
        laneSymbol.setName("Default Lane");
        laneSymbol.setXPos(10L);
        laneSymbol.setYPos(10L);
        laneSymbol.setWidth(480);
        laneSymbol.setHeight(580);
        laneSymbol.setOrientation(OrientationType.VERTICAL_LITERAL);
        processDefinition.getDiagram().add((Object)diagram);
        return processDefinition;
    }

    public ProcessDefinitionType createProcess(ModelType model, String id, String name, String defaultLaneName, String defaultPoolName) {
        ProcessDefinitionType processDefinition = (ProcessDefinitionType)((BpmProcessDefinitionBuilder)BpmModelBuilder.newProcessDefinition(model).withIdAndName(id, name)).build();
        DiagramType diagram = AbstractElementBuilder.F_CWM.createDiagramType();
        diagram.setMode(DiagramModeType.MODE_450_LITERAL);
        diagram.setOrientation(OrientationType.VERTICAL_LITERAL);
        diagram.setName("Diagram 1");
        PoolSymbol poolSymbol = AbstractElementBuilder.F_CWM.createPoolSymbol();
        diagram.getPoolSymbols().add((Object)poolSymbol);
        poolSymbol.setXPos(0L);
        poolSymbol.setYPos(0L);
        poolSymbol.setWidth(409);
        poolSymbol.setHeight(670);
        poolSymbol.setName(defaultPoolName);
        poolSymbol.setId("_default_pool__1");
        poolSymbol.setOrientation(OrientationType.VERTICAL_LITERAL);
        LaneSymbol laneSymbol = AbstractElementBuilder.F_CWM.createLaneSymbol();
        poolSymbol.getChildLanes().add((Object)laneSymbol);
        laneSymbol.setParentPool(poolSymbol);
        laneSymbol.setId("DefaultLane");
        laneSymbol.setName(defaultLaneName);
        laneSymbol.setXPos(12L);
        laneSymbol.setYPos(32L);
        laneSymbol.setWidth(375);
        laneSymbol.setHeight(poolSymbol.getHeight() - 70);
        laneSymbol.setOrientation(OrientationType.VERTICAL_LITERAL);
        processDefinition.getDiagram().add((Object)diagram);
        return processDefinition;
    }

    public DataPathType createDataPath() {
        return AbstractElementBuilder.F_CWM.createDataPathType();
    }

    public ModelType findModel(String modelId) {
        return this.getModelManagementStrategy().getModels().get(modelId);
    }

    public ProcessDefinitionType findProcessDefinition(String processFullID) {
        String modelID = this.getModelId(processFullID);
        String processID = this.stripFullId(processFullID);
        ModelType model = this.findModel(modelID);
        for (ProcessDefinitionType processDefinition : model.getProcessDefinition()) {
            if (!processDefinition.getId().equals(processID)) continue;
            return processDefinition;
        }
        throw new ObjectNotFoundException("Process Definition " + processFullID + " does not exist.");
    }

    public ProcessDefinitionType getProcessDefinition(String modelId, String id) {
        return XPDLFinderUtils.findProcessDefinition(this.findModel(modelId), id);
    }

    public TypeDeclarationType findTypeDeclaration(String fullTypeID) {
        String[] ids;
        if (fullTypeID.startsWith("typeDeclaration:{")) {
            fullTypeID = fullTypeID.split(":")[1];
            fullTypeID = fullTypeID.replaceAll("\\{", "");
            fullTypeID = fullTypeID.replaceAll("\\}", ":");
        }
        if ((ids = fullTypeID.split(":")).length > 1) {
            return XPDLFinderUtils.findTypeDeclaration(this.findModel(ids[0]), ids[1]);
        }
        return null;
    }

    public IModelParticipant findParticipant(String fullParticipantID) {
        String modelID = this.getModelId(fullParticipantID);
        String participantID = this.stripFullId(fullParticipantID);
        ModelType model = this.findModel(modelID);
        for (RoleType role : model.getRole()) {
            if (!role.getId().equals(participantID)) continue;
            return role;
        }
        for (OrganizationType organization : model.getOrganization()) {
            if (!organization.getId().equals(participantID)) continue;
            return organization;
        }
        for (ConditionalPerformerType conditionalPerformer : model.getConditionalPerformer()) {
            if (!conditionalPerformer.getId().equals(participantID)) continue;
            return conditionalPerformer;
        }
        throw new ObjectNotFoundException("Participant " + fullParticipantID + " does not exist.");
    }

    public ApplicationType getApplication(String modelId, String appId) {
        ModelType model = this.getModelManagementStrategy().getModels().get(modelId);
        EList apps = model.getApplication();
        for (ApplicationType a : apps) {
            if (!a.getId().equals(appId)) continue;
            return a;
        }
        return null;
    }

    public String createFullId(ModelType model, EObject modelElement) {
        if (null != model && null != modelElement) {
            if (modelElement instanceof IIdentifiableModelElement) {
                return model.getId() + ":" + ((IIdentifiableModelElement)modelElement).getId();
            }
            if (modelElement instanceof TypeDeclarationType) {
                return model.getId() + ":" + ((TypeDeclarationType)modelElement).getId();
            }
        }
        return null;
    }

    public String stripFullId(String fullId) {
        String[] ids = fullId.split(":");
        return ids[ids.length - 1];
    }

    public String getModelId(String fullId) {
        String[] ids = fullId.split(":");
        return ids[0];
    }

    private IDataInitializer getInitializer(String dataTypeTypeID) {
        if (dataTypeTypeID.equals("primitive")) {
            return new PrimitiveDataInitializer();
        }
        if (dataTypeTypeID.equals("struct")) {
            return new DataStructInitializer();
        }
        if (dataTypeTypeID.equals("serializable")) {
            return new SerializableDataInitializer();
        }
        if (dataTypeTypeID.equals("dmsDocument")) {
            return new DmsDocumentInitializer();
        }
        return null;
    }

    private TypeType getPrimitiveType(String primitiveTypeID) {
        TypeType type = null;
        if (primitiveTypeID.equals("string")) {
            type = TypeType.STRING;
        } else if (primitiveTypeID.equals("date")) {
            type = TypeType.DATETIME;
        } else if (primitiveTypeID.equals("int")) {
            type = TypeType.INTEGER;
        } else if (primitiveTypeID.equals("double")) {
            type = TypeType.FLOAT;
        } else if (primitiveTypeID.equals("decimal")) {
            type = TypeType.FLOAT;
        } else if (primitiveTypeID.equals("boolean")) {
            type = TypeType.BOOLEAN;
        } else if (primitiveTypeID.equals("Calendar")) {
            type = TypeType.DATETIME;
        } else if (primitiveTypeID.equals("long")) {
            type = TypeType.INTEGER;
        }
        return type;
    }

    public ContextType getApplicationContext(ApplicationType application, String contextTypeKey) {
        for (ContextType contextType : application.getContext()) {
            if (!contextType.getType().getId().equals(contextTypeKey)) continue;
            return contextType;
        }
        return null;
    }

    public ContextType createApplicationContext(ApplicationType application, String contextId) {
        ModelType model = ModelUtils.findContainingModel((EObject)application);
        ContextType context = AbstractElementBuilder.F_CWM.createContextType();
        ApplicationContextTypeType contextTypeType = null;
        contextTypeType = XPDLFinderUtils.findApplicationContextTypeType(model, contextId);
        if (contextTypeType == null) {
            contextTypeType = AbstractElementBuilder.F_CWM.createApplicationContextTypeType();
            if ("externalWebApp".equals(contextId)) {
                contextTypeType.setName("External Web Application");
                contextTypeType.setId("externalWebApp");
                contextTypeType.setIsPredefined(true);
                model.getApplicationContextType().add((Object)contextTypeType);
            } else if ("application".equals(contextId)) {
                contextTypeType.setName("Noninteractive Application Context");
                contextTypeType.setId("application");
                contextTypeType.setIsPredefined(true);
                model.getApplicationContextType().add((Object)contextTypeType);
            } else if ("engine".equals(contextId)) {
                contextTypeType.setName("Engine Context");
                contextTypeType.setId("engine");
                contextTypeType.setIsPredefined(true);
                model.getApplicationContextType().add((Object)contextTypeType);
            } else if ("default".equals(contextId)) {
                contextTypeType.setName("Default Context");
                contextTypeType.setId("default");
                contextTypeType.setIsPredefined(true);
                model.getApplicationContextType().add((Object)contextTypeType);
            }
        }
        context.setType(contextTypeType);
        application.getContext().add((Object)context);
        return context;
    }

    public Class<?> getClassForType(String type) {
        if (type.equalsIgnoreCase("long")) {
            return Long.class;
        }
        if (type.equalsIgnoreCase("long")) {
            return Short.class;
        }
        if (type.equalsIgnoreCase("float")) {
            return Float.class;
        }
        if (type.equalsIgnoreCase("double")) {
            return Double.class;
        }
        if (type.equalsIgnoreCase("byte")) {
            return Byte.class;
        }
        if (type.equalsIgnoreCase("Calendar")) {
            return Calendar.class;
        }
        if (type.equalsIgnoreCase(TIMESTAMP_TYPE)) {
            return Calendar.class;
        }
        if (type.equalsIgnoreCase("int")) {
            return Integer.class;
        }
        if (type.equalsIgnoreCase("java.lang.Integer")) {
            return Integer.class;
        }
        if (type.equals("String")) {
            return String.class;
        }
        return String.class;
    }

    public ProcessDefinitionType setSubProcess(ActivityType activity, String processFullId) {
        ModelType processModel;
        ProcessDefinitionType process = this.getProcessDefinition(this.getModelId(processFullId), this.stripFullId(processFullId));
        ModelType model = ModelUtils.findContainingModel((EObject)activity);
        if (model.equals(processModel = ModelUtils.findContainingModel((EObject)process))) {
            IdRefHandler.cleanup((IIdentifiableModelElement)activity);
            activity.setImplementationProcess(process);
        } else {
            ExternalReferenceUtils.createExternalReferenceToProcess(activity, process, model, processModel);
        }
        return process;
    }

    public ApplicationType setApplication(ActivityType activity, String applicationFullId) {
        ModelType applicationModel;
        ApplicationType application = this.getApplication(this.getModelId(applicationFullId), this.stripFullId(applicationFullId));
        ModelType model = ModelUtils.findContainingModel((EObject)activity);
        if (model.equals(applicationModel = ModelUtils.findContainingModel((EObject)application))) {
            IdRefHandler.cleanup((IIdentifiableModelElement)activity);
            activity.setApplication(application);
        } else {
            ExternalReferenceUtils.createExternalReferenceToApplication(activity, application, model, applicationModel);
        }
        return application;
    }

    public static void setAttribute(Object element, String name, String value) {
        if (element instanceof Extensible) {
            ExtendedAttributeUtil.setAttribute((Extensible)((Extensible)element), (String)name, (String)value);
        }
        if (element instanceof IExtensibleElement) {
            try {
                AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)name, (String)value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void setTimestampAttribute(IExtensibleElement element, String name, String value) {
        AttributeUtil.setAttribute((IExtensibleElement)element, (String)name, (String)TIMESTAMP_TYPE, (String)value);
    }

    public Date getTimestampAttribute(IExtensibleElement element, String name) {
        Date date = null;
        String attributeValue = AttributeUtil.getAttributeValue((IExtensibleElement)element, (String)name);
        if (attributeValue != null) {
            try {
                date = DateUtils.getNonInteractiveDateFormat().parse(attributeValue);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static void setBooleanAttribute(Object element, String name, boolean value) {
        if (element instanceof Extensible) {
            ExtendedAttributeUtil.setBooleanAttribute((Extensible)((Extensible)element), (String)name, (boolean)value);
        }
        if (element instanceof IExtensibleElement) {
            AttributeUtil.setBooleanAttribute((IExtensibleElement)((IExtensibleElement)element), (String)name, (Boolean)value);
        }
    }

    public boolean getBooleanAttribute(Object element, String name) {
        if (element instanceof Extensible) {
            return ExtendedAttributeUtil.getBooleanValue((Extensible)((Extensible)element), (String)name);
        }
        if (element instanceof IExtensibleElement) {
            return AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)element), (String)name);
        }
        return false;
    }

    public List getAttributes(Object element) {
        if (element instanceof Extensible && ((Extensible)element).getExtendedAttributes() != null) {
            return ((Extensible)element).getExtendedAttributes().getExtendedAttribute();
        }
        if (element instanceof IExtensibleElement) {
            return ((IExtensibleElement)element).getAttribute();
        }
        return new ArrayList();
    }

    public List getAttributes(Object element, boolean excludeBoolean, boolean booleanOnly) {
        if (excludeBoolean == booleanOnly && booleanOnly) {
            return new ArrayList();
        }
        List attributes = this.getAttributes(element);
        if (excludeBoolean == booleanOnly && !booleanOnly) {
            return attributes;
        }
        ArrayList filteredAttributes = new ArrayList();
        for (Object attribute : attributes) {
            if ((!booleanOnly || !this.isBooleanAttribute(attribute)) && (!excludeBoolean || this.isBooleanAttribute(attribute))) continue;
            filteredAttributes.add(attribute);
        }
        return filteredAttributes;
    }

    public Object getAttribute(Object element, String attributeName) {
        for (Object attribute : this.getAttributes(element)) {
            if (!this.getAttributeName(attribute).equals(attributeName)) continue;
            return attribute;
        }
        return null;
    }

    public String getAttributeName(Object attribute) {
        if (attribute instanceof ExtendedAttributeType) {
            return ((ExtendedAttributeType)attribute).getName();
        }
        if (attribute instanceof AttributeType) {
            return ((AttributeType)attribute).getName();
        }
        return null;
    }

    public String getAttributeValue(Object attribute) {
        if (attribute instanceof ExtendedAttributeType) {
            return ((ExtendedAttributeType)attribute).getValue();
        }
        if (attribute instanceof AttributeType) {
            return ((AttributeType)attribute).getValue();
        }
        return null;
    }

    public boolean isBooleanAttribute(Object attribute) {
        ExtendedAttributeType attributeType;
        if (attribute instanceof ExtendedAttributeType) {
            attributeType = (ExtendedAttributeType)attribute;
            if (((ExtendedAttributeType)attribute).getValue() != null && (attributeType.getValue().equalsIgnoreCase("true") || attributeType.getValue().equalsIgnoreCase("false"))) {
                return true;
            }
        }
        return attribute instanceof AttributeType && (attributeType = (AttributeType)attribute).getType() != null && attributeType.getType().equalsIgnoreCase("Boolean");
    }

    public boolean isExternalReference(EObject modelElement) {
        if (modelElement != null) {
            String uri;
            if (modelElement.eIsProxy()) {
                return true;
            }
            if (modelElement instanceof DataType) {
                DataType dataType = (DataType)modelElement;
                if (dataType.eIsProxy()) {
                    return true;
                }
                if (dataType.getType() != null && dataType.getType().getId().equalsIgnoreCase("dmsDocument")) {
                    return false;
                }
                if (dataType.getType() != null && dataType.getType().getId().equalsIgnoreCase("struct")) {
                    return false;
                }
            }
            if (modelElement instanceof IExtensibleElement && AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)modelElement), (String)"carnot:connection:uri") != null) {
                String importString;
                uri = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)modelElement), (String)"carnot:connection:uri");
                ModelType model = ModelUtils.findContainingModel((EObject)modelElement);
                if (model == null) {
                    return false;
                }
                Connection connection = (Connection)model.getConnectionManager().findConnection(uri);
                return connection == null || (importString = connection.getAttribute("importByReference")) != null && (importString == null || !importString.equalsIgnoreCase("false"));
            }
            if (modelElement instanceof Extensible && ExtendedAttributeUtil.getAttributeValue((Extensible)((Extensible)modelElement), (String)"carnot:connection:uri") != null) {
                String importString;
                uri = ExtendedAttributeUtil.getAttributeValue((Extensible)((Extensible)modelElement), (String)"carnot:connection:uri");
                ModelType model = ModelUtils.findContainingModel((EObject)modelElement);
                if (model == null) {
                    return false;
                }
                Connection connection = (Connection)model.getConnectionManager().findConnection(uri);
                return connection == null || (importString = connection.getAttribute("importByReference")) == null || !importString.equalsIgnoreCase("false");
            }
        }
        return false;
    }

    public boolean isEnumerationJavaBound(TypeDeclarationType typeDeclaration) {
        try {
            if (null != typeDeclaration && null != typeDeclaration.getExtendedAttributes()) {
                for (ExtendedAttributeType extendedAttrType : typeDeclaration.getExtendedAttributes().getExtendedAttribute()) {
                    if (!extendedAttrType.getName().equals("carnot:engine:className")) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public void updateTeamLead(OrganizationType organization, String participantFullID) {
        if ("TO_BE_DEFINED".equals(participantFullID)) {
            this.setTeamLeader(organization, null);
            return;
        }
        ModelType model = ModelUtils.findContainingModel((EObject)organization);
        if (participantFullID != null) {
            this.setTeamLeader(organization, (RoleType)this.importParticipant(model, participantFullID));
        }
    }

    public void setModified(ModelType modelType, String modified) {
        AttributeUtil.setAttribute((IExtensibleElement)modelType, (String)"ipp:model:modified", (String)modified);
    }

    public void setModified(ModelType modelType, Date modified) {
        AttributeUtil.setAttribute((IExtensibleElement)modelType, (String)"ipp:model:modified", (String)new Date().toString());
    }

    public String getModified(ModelType modelType) {
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)modelType, (String)"ipp:model:modified");
        if (attribute != null) {
            return this.convertDate(attribute.getValue());
        }
        return "unknown";
    }

    public ModelType createModel(String modelID, String modelName) {
        Map<String, ModelType> models = this.modelManagementStrategy.getModels(false);
        ArrayList<ModelType> ids = new ArrayList<ModelType>(models.values());
        ModelType model = (ModelType)((BpmPackageBuilder)BpmModelBuilder.newBpmModel().withIdAndName(modelID, modelName)).build();
        model.setConnectionManager((IConnectionManager)new WebModelerConnectionManager(model, this.modelManagementStrategy));
        if (StringUtils.isEmpty((String)modelID)) {
            modelID = NameIdUtilsExtension.createIdFromName((String)modelName, ids);
        }
        model.setId(modelID);
        return model;
    }

    public DataType createProcessAttachementData(ModelType model) {
        org.eclipse.stardust.model.xpdl.carnot.DataTypeType dataTypeType = (org.eclipse.stardust.model.xpdl.carnot.DataTypeType)ModelUtils.findIdentifiableElement((List)model.getDataType(), (String)"dmsDocumentList");
        DataType data = CarnotWorkflowModelFactory.eINSTANCE.createDataType();
        data.setId("PROCESS_ATTACHMENTS");
        ResourceBundle rb = ResourceBundle.getBundle("bpm-modeler-messages");
        String name = rb.getString("modeler.processDefinition.propertyPages.processAttachments.heading");
        data.setName(name);
        data.setType(dataTypeType);
        model.getData().add((Object)data);
        AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:className", (String)List.class.getName());
        AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:data:bidirectional", (String)Boolean.TYPE.getName(), (String)Boolean.TRUE.toString());
        return data;
    }

    public ParameterMappingType createParameterMapping(TriggerType trigger, String parameter, String dataFullID, String dataPath) {
        ParameterMappingType mappingType = CarnotWorkflowModelFactory.eINSTANCE.createParameterMappingType();
        mappingType.setParameter(parameter);
        DataType dt = this.importData(ModelUtils.findContainingModel((EObject)trigger), dataFullID);
        mappingType.setData(dt);
        if (dataPath != null) {
            mappingType.setDataPath(dataPath);
        }
        trigger.getParameterMapping().add((Object)mappingType);
        return mappingType;
    }

    public String convertDate(String date) {
        ResourceBundle rb = ResourceBundle.getBundle("portal-common-messages");
        String format = rb.getString("portalFramework.formats.defaultDateTimeFormat");
        if (format == null) {
            format = "MM/dd/yy hh:mm a";
        }
        String pattern = "E MMM dd HH:mm:ss zzz yyyy";
        SimpleDateFormat instance = new SimpleDateFormat(pattern, Locale.ROOT);
        try {
            Date parse = instance.parse(date);
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.applyPattern(format);
            date = sdf.format(parse);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public TransitionType createTransition(ProcessDefinitionType processDefinition, ActivityType sourceActivity, ActivityType targetActivity, String id, String name, String description, boolean otherwise, String condition) {
        TransitionType transition = AbstractElementBuilder.F_CWM.createTransitionType();
        processDefinition.getTransition().add((Object)transition);
        transition.setFrom(sourceActivity);
        transition.setTo(targetActivity);
        if (StringUtils.isEmpty((String)id)) {
            id = this.modelManagementStrategy.uuidMapper().map((EObject)transition);
        }
        transition.setId(id);
        transition.setName(name);
        if (otherwise) {
            transition.setCondition("OTHERWISE");
        } else {
            transition.setCondition("CONDITION");
            if (StringUtils.isEmpty((String)condition)) {
                condition = "true";
            }
            XmlTextNode expression = CarnotWorkflowModelFactory.eINSTANCE.createXmlTextNode();
            ModelUtils.setCDataString((FeatureMap)expression.getMixed(), (String)condition, (boolean)true);
            transition.setExpression(expression);
        }
        ModelBuilderFacade.setDescription((IIdentifiableModelElement)transition, description);
        return transition;
    }

    public TransitionConnectionType createTransitionSymbol(ProcessDefinitionType processDefinition, IFlowObjectSymbol sourceActivitySymbol, IFlowObjectSymbol targetActivitySymbol, TransitionType transition, String fromAnchorOrientation, String toAnchorOrientation) {
        TransitionConnectionType transitionConnection = AbstractElementBuilder.F_CWM.createTransitionConnectionType();
        if (null != transition) {
            transition.getTransitionConnections().add((Object)transitionConnection);
            transitionConnection.setTransition(transition);
        }
        transitionConnection.setSourceNode((INodeSymbol)sourceActivitySymbol);
        transitionConnection.setTargetNode((INodeSymbol)targetActivitySymbol);
        transitionConnection.setSourceAnchor(fromAnchorOrientation);
        transitionConnection.setTargetAnchor(toAnchorOrientation);
        ((PoolSymbol)((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols().get(0)).getTransitionConnection().add((Object)transitionConnection);
        return transitionConnection;
    }

    public TransitionConnectionType createControlFlowConnection(ProcessDefinitionType processDefinition, ActivitySymbolType sourceActivitySymbol, ActivitySymbolType targetActivitySymbol, String id, String name, String description, boolean otherwise, String condition, String fromAnchor, String toAnchor) {
        TransitionType transition = this.createTransition(processDefinition, sourceActivitySymbol.getActivity(), targetActivitySymbol.getActivity(), id, name, description, otherwise, condition);
        return this.createTransitionSymbol(processDefinition, (IFlowObjectSymbol)sourceActivitySymbol, (IFlowObjectSymbol)targetActivitySymbol, transition, fromAnchor, toAnchor);
    }

    public DataMappingConnectionType createDataFlowConnection(ProcessDefinitionType processDefinition, ActivitySymbolType activitySymbol, DataSymbolType dataSymbol, DirectionType direction, String fromAnchor, String toAnchor, String context, String activityAccessPointId) {
        ApplicationType application;
        DataType data = dataSymbol.getData();
        ActivityType activity = activitySymbol.getActivity();
        DataMappingType dataMapping = AbstractElementBuilder.F_CWM.createDataMappingType();
        DataMappingConnectionType dataMappingConnection = AbstractElementBuilder.F_CWM.createDataMappingConnectionType();
        String id = data.getId();
        dataMapping.setId(id);
        dataMapping.setName(id);
        dataMapping.setDirection(direction);
        dataMapping.setData(data);
        this.modelManagementStrategy.uuidMapper().map((EObject)dataMapping);
        if (context.equalsIgnoreCase("default")) {
            context = this.getDefaultContext(activity, direction);
        }
        dataMapping.setContext(context);
        if (activityAccessPointId != null) {
            dataMapping.setApplicationAccessPoint(activityAccessPointId);
        }
        activity.getDataMapping().add((Object)dataMapping);
        ((PoolSymbol)((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols().get(0)).getDataMappingConnection().add((Object)dataMappingConnection);
        dataMappingConnection.setActivitySymbol(activitySymbol);
        dataMappingConnection.setDataSymbol(dataSymbol);
        activitySymbol.getDataMappings().add((Object)dataMappingConnection);
        dataSymbol.getDataMappings().add((Object)dataMappingConnection);
        dataMappingConnection.setSourceAnchor(fromAnchor);
        dataMappingConnection.setTargetAnchor(toAnchor);
        if (null == dataMapping.getApplicationAccessPoint() && activity.getImplementation().getLiteral().equals("Application") && null != (application = activity.getApplication()).getType() && application.getType().getId().equals("webservice")) {
            String dataId = null;
            if (application != null && application.getAccessPoint() != null) {
                for (AccessPointType accPoints : activity.getApplication().getAccessPoint()) {
                    if (accPoints.getDirection().getValue() != 2 || !accPoints.getType().equals(data.getType())) continue;
                    dataId = accPoints.getId();
                    break;
                }
            }
            if (null != dataId) {
                dataMapping.setContext("application");
                dataMapping.setApplicationAccessPoint(dataId);
            }
        }
        return dataMappingConnection;
    }

    public String getDefaultContext(ActivityType activity, DirectionType direction) {
        List contextTypes = ActivityUtil.getContextTypes((ActivityType)activity, (DirectionType)direction);
        if (!contextTypes.isEmpty()) {
            return ((ApplicationContextTypeType)contextTypes.get(0)).getId();
        }
        return "default";
    }

    public DataMappingConnectionType createDataFlowConnection(ProcessDefinitionType processDefinition, ActivitySymbolType activitySymbol, DataSymbolType dataSymbol, String inputContextId, String inputAccessPointId, String outputContextId, String outputAccessPointId, String fromAnchor, String toAnchor) {
        DataMappingType dataMapping;
        DataType data = dataSymbol.getData();
        ActivityType activity = activitySymbol.getActivity();
        if (inputAccessPointId != null) {
            dataMapping = AbstractElementBuilder.F_CWM.createDataMappingType();
            dataMapping.setId(data.getId());
            dataMapping.setName(data.getName());
            dataMapping.setDirection(DirectionType.IN_LITERAL);
            dataMapping.setData(data);
            dataMapping.setContext(inputContextId);
            dataMapping.setApplicationAccessPoint(inputAccessPointId);
            activity.getDataMapping().add((Object)dataMapping);
        }
        if (outputAccessPointId != null) {
            dataMapping = AbstractElementBuilder.F_CWM.createDataMappingType();
            dataMapping.setId(data.getId());
            dataMapping.setName(data.getName());
            dataMapping.setDirection(DirectionType.OUT_LITERAL);
            dataMapping.setData(data);
            dataMapping.setContext(outputContextId);
            dataMapping.setApplicationAccessPoint(outputAccessPointId);
            activity.getDataMapping().add((Object)dataMapping);
        }
        DataMappingConnectionType dataMappingConnection = AbstractElementBuilder.F_CWM.createDataMappingConnectionType();
        ((PoolSymbol)((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols().get(0)).getDataMappingConnection().add((Object)dataMappingConnection);
        dataMappingConnection.setActivitySymbol(activitySymbol);
        dataMappingConnection.setDataSymbol(dataSymbol);
        activitySymbol.getDataMappings().add((Object)dataMappingConnection);
        dataSymbol.getDataMappings().add((Object)dataMappingConnection);
        dataMappingConnection.setSourceAnchor(fromAnchor);
        dataMappingConnection.setTargetAnchor(toAnchor);
        return dataMappingConnection;
    }

    public AccessPointType findFirstApplicationAccessPointForType(ApplicationType application, DirectionType direction) {
        for (AccessPointType accessPoint : application.getAccessPoint()) {
            if (!accessPoint.getDirection().equals((Object)direction)) continue;
            return accessPoint;
        }
        return null;
    }

    public boolean isReadOnly(EObject element) {
        AttributeType attribute;
        return element != null && element instanceof ModelType && (attribute = AttributeUtil.getAttribute((IExtensibleElement)((ModelType)element), (String)"stardust:security:hash")) != null && attribute.getValue() != null && attribute.getValue().length() > 0;
    }

    public static void setDescription(IIdentifiableModelElement element, String description) {
        if (StringUtils.isNotEmpty((String)description)) {
            DescriptionType dt = AbstractElementBuilder.F_CWM.createDescriptionType();
            dt.getMixed().add((Object)FeatureMapUtil.createRawTextEntry((String)description));
            element.setDescription(dt);
        }
    }
}

