/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IConnection;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.util.IObjectReference;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributesType;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.repository.common.Attribute;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionHandler;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.ExternalPackageResolver;
import org.eclipse.stardust.modeling.repository.common.IFilter;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.Repository;
import org.eclipse.stardust.modeling.repository.common.RepositoryFactory;
import org.eclipse.stardust.modeling.repository.common.Repository_Messages;
import org.eclipse.stardust.modeling.repository.common.descriptors.EObjectDescriptor;

public class PepperConnectionManager
implements IConnectionManager {
    private static final IFilter BY_REF_FILTER = new IFilter(){

        public boolean accept(Object object) {
            if (object instanceof EObjectDescriptor) {
                ProcessDefinitionType process;
                DataType dataType;
                ConditionalPerformerType conPerfType;
                OrganizationType orgType;
                RoleType roleType;
                ApplicationType applicationType;
                TypeDeclarationType typeDeclaration;
                ExtendedAttributeType visibility;
                EObjectDescriptor eObjectdescriptor = (EObjectDescriptor)object;
                if (eObjectdescriptor.getEObject() instanceof TypeDeclarationType && (visibility = ExtendedAttributeUtil.getAttribute((ExtendedAttributesType)(typeDeclaration = (TypeDeclarationType)eObjectdescriptor.getEObject()).getExtendedAttributes(), (String)"carnot:engine:visibility")) != null && "Private".equals(visibility.getValue())) {
                    return false;
                }
                if (eObjectdescriptor.getEObject() instanceof ApplicationType && (visibility = AttributeUtil.getAttribute((IExtensibleElement)(applicationType = (ApplicationType)eObjectdescriptor.getEObject()), (String)"carnot:engine:visibility")) != null && "Private".equals(visibility.getValue())) {
                    return false;
                }
                if (eObjectdescriptor.getEObject() instanceof RoleType && (visibility = AttributeUtil.getAttribute((IExtensibleElement)(roleType = (RoleType)eObjectdescriptor.getEObject()), (String)"carnot:engine:visibility")) != null && "Private".equals(visibility.getValue())) {
                    return false;
                }
                if (eObjectdescriptor.getEObject() instanceof OrganizationType && (visibility = AttributeUtil.getAttribute((IExtensibleElement)(orgType = (OrganizationType)eObjectdescriptor.getEObject()), (String)"carnot:engine:visibility")) != null && "Private".equals(visibility.getValue())) {
                    return false;
                }
                if (eObjectdescriptor.getEObject() instanceof ConditionalPerformerType && (visibility = AttributeUtil.getAttribute((IExtensibleElement)(conPerfType = (ConditionalPerformerType)eObjectdescriptor.getEObject()), (String)"carnot:engine:visibility")) != null && "Private".equals(visibility.getValue())) {
                    return false;
                }
                if (eObjectdescriptor.getEObject() instanceof DataType && (visibility = AttributeUtil.getAttribute((IExtensibleElement)(dataType = (DataType)eObjectdescriptor.getEObject()), (String)"carnot:engine:visibility")) != null && "Private".equals(visibility.getValue())) {
                    return false;
                }
                if (eObjectdescriptor.getEObject() instanceof ProcessDefinitionType && (process = (ProcessDefinitionType)eObjectdescriptor.getEObject()).getFormalParameters() == null) {
                    return false;
                }
            }
            return true;
        }
    };
    private Repository repository;
    private Map<Connection, ConnectionHandler> handlers = CollectionUtils.newMap();
    private ModelType model;

    public PepperConnectionManager(ModelType model) {
        this.model = model;
        this.model.setConnectionManager((IConnectionManager)this);
        RepositoryFactory factory = RepositoryFactory.eINSTANCE;
        this.repository = factory.createRepository();
        Map infoMap = CollectionUtils.newMap();
        List infoList = CollectionUtils.newList();
        EList list = model.getAttribute();
        for (int i = 0; i < list.size(); ++i) {
            AttributeType att = (AttributeType)list.get(i);
            String name = att.getName();
            if (!name.startsWith("carnot:connection:")) continue;
            name = name.substring("carnot:connection:".length());
            this.handleAttribute(infoMap, infoList, att, name);
        }
        ExternalPackageResolver externalPackageResolver = new ExternalPackageResolver(model);
        model.eAdapters().add((Object)externalPackageResolver);
        for (int i = 0; i < infoList.size(); ++i) {
            String identifier = (String)infoList.get(i);
            Map attributes = (Map)infoMap.get(identifier);
            Connection connection = factory.createConnection();
            connection.setProperty("ConnectionManager", (Object)this);
            connection.setId((String)attributes.get("id"));
            connection.setName((String)attributes.get("name"));
            connection.setType((String)attributes.get("type"));
            Map connectionAttributes = (Map)attributes.get("attribute");
            if (connectionAttributes != null) {
                for (Map.Entry entry : connectionAttributes.entrySet()) {
                    Attribute attr = factory.createAttribute();
                    attr.setName((String)entry.getKey());
                    attr.setValue((String)entry.getValue());
                    connection.getAttributes().add(attr);
                }
            }
            this.repository.getConnection().add(connection);
            connection.eAdapters().add((Object)externalPackageResolver);
        }
    }

    private void handleAttribute(Map<String, Object> infoMap, List<String> infoList, AttributeType att, String name) {
        int ix = name.indexOf(58);
        if (ix > 0) {
            String identifier = name.substring(0, ix);
            if (infoList != null && !infoList.contains(identifier)) {
                infoList.add(identifier);
            }
            name = name.substring(ix + 1);
            Map map = (Map)infoMap.get(identifier);
            if (map == null) {
                map = CollectionUtils.newMap();
                infoMap.put(identifier, map);
            }
            this.handleAttribute(map, null, att, name);
        } else {
            infoMap.put(name, att.getValue());
        }
    }

    public void close() {
        for (Map.Entry<Connection, ConnectionHandler> entry : this.handlers.entrySet()) {
            try {
                entry.getValue().close(entry.getKey());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.save();
    }

    public void save() {
        EList list = this.model.getAttribute();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            AttributeType att = (AttributeType)i.next();
            String name = att.getName();
            if (!name.startsWith("carnot:connection:")) continue;
            i.remove();
        }
        List connections = this.repository.getConnection();
        for (int i2 = 0; i2 < connections.size(); ++i2) {
            Connection connection = (Connection)connections.get(i2);
            String identifier = "carnot:connection:" + String.valueOf(i2 + 1) + ':';
            AttributeUtil.setAttribute((IExtensibleElement)this.model, (String)(identifier + "id"), (String)connection.getId());
            AttributeUtil.setAttribute((IExtensibleElement)this.model, (String)(identifier + "name"), (String)connection.getName());
            AttributeUtil.setAttribute((IExtensibleElement)this.model, (String)(identifier + "type"), (String)connection.getType());
            List attributes = connection.getAttributes();
            for (int j = 0; j < attributes.size(); ++j) {
                Attribute attribute = (Attribute)attributes.get(j);
                AttributeUtil.setAttribute((IExtensibleElement)this.model, (String)(identifier + "attribute:" + attribute.getName()), (String)attribute.getValue());
            }
        }
    }

    public void setAllConnections(List<Connection> connections) {
        this.repository.getConnection().addAll(connections);
    }

    public List<Connection> getAllConnections() {
        return this.repository.getConnection();
    }

    public Iterator<Connection> getConnections() {
        return this.repository.getConnection().iterator();
    }

    public Connection getConnection(String id) {
        for (Connection connection : this.repository.getConnection()) {
            if (!id.equals(connection.getId())) continue;
            return connection;
        }
        return null;
    }

    public Connection create(String type) throws CoreException {
        Connection connection = this.createConnection(type);
        connection.setProperty("ConnectionManager.CREATED", (Object)"true");
        this.repository.getConnection().add(connection);
        return connection;
    }

    private Connection createConnection(String type) throws CoreException {
        Connection connection2;
        IConfigurationElement config = this.getConfigurationElement(type);
        String baseId = type;
        String baseName = config.getAttribute("name");
        int counter = 0;
        for (Connection connection2 : this.repository.getConnection()) {
            counter = this.getPostfixNumber(connection2.getId(), baseId, '_', counter);
            counter = this.getPostfixNumber(connection2.getName(), baseName, ' ', counter);
        }
        RepositoryFactory factory = RepositoryFactory.eINSTANCE;
        connection2 = factory.createConnection();
        connection2.setProperty("ConnectionManager", (Object)this);
        connection2.setId(counter == 0 ? baseId : baseId + '_' + counter);
        connection2.setName(counter == 0 ? baseName : baseName + ' ' + counter);
        connection2.setType(type);
        Attribute attribute = factory.createAttribute();
        attribute.setName("importByReference");
        attribute.setValue("true");
        connection2.getAttributes().add(attribute);
        return connection2;
    }

    private int getPostfixNumber(String actual, String base, char separator, int c) {
        if (base.equals(actual) && c == 0) {
            c = 1;
        } else if (actual != null && actual.startsWith(base + separator)) {
            try {
                int number = Integer.parseInt(actual.substring(base.length() + 1));
                c = Math.max(c, number + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return c;
    }

    public ConnectionHandler getConnectionHandler(Connection connection) {
        return this.handlers.get(connection);
    }

    public boolean isOpen(Connection connection) {
        return this.handlers.containsKey(connection);
    }

    public void open(Connection connection) throws CoreException {
        ConnectionHandler handler = this.handlers.get(connection);
        if (handler == null) {
            handler = this.createHandler(connection.getType());
            handler.open(connection);
            this.handlers.put(connection, handler);
        }
    }

    private ConnectionHandler createHandler(String type) throws CoreException {
        IConfigurationElement config = this.getConfigurationElement(type);
        return (ConnectionHandler)config.createExecutableExtension("handler");
    }

    public IConfigurationElement getConfigurationElement(String type) throws CoreException {
        List extensions = SpiExtensionRegistry.instance().getExtensionList("org.eclipse.stardust.modeling.repository.common", "connections");
        for (int i = 0; i < extensions.size(); ++i) {
            IConfigurationElement config = (IConfigurationElement)extensions.get(i);
            if (!config.getAttribute("id").equals(type)) continue;
            return config;
        }
        String message = MessageFormat.format(Repository_Messages.MSG_FORMAT_NO_HANDLER_FOUND_FOR_CONNECTION_TYPE_NULL, type);
        throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.repository.common", 0, message, null));
    }

    public void close(Connection connection) throws CoreException {
        ConnectionHandler handler = this.handlers.get(connection);
        if (handler != null) {
            handler.close(connection);
            this.handlers.remove(connection);
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public List<IObjectDescriptor> select(Connection connection, IFilter[] filters) throws CoreException {
        filters = this.getFilters(filters, "true".equals(connection.getAttribute("importByReference")));
        ConnectionHandler handler = this.handlers.get(connection);
        if (handler != null) {
            List<IObjectDescriptor> result = handler.select(filters);
            return filters == null ? result : this.decorateWithFilters(result, filters);
        }
        String message = MessageFormat.format(Repository_Messages.MSG_FORMAT_CONNECTION_NULL_IS_CLOSED, connection.getId());
        throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.repository.common", 0, message, null));
    }

    private List<IObjectDescriptor> decorateWithFilters(List<IObjectDescriptor> result, IFilter[] filters) {
        List descriptors = CollectionUtils.newList((int)result.size());
        for (IObjectDescriptor desc : result) {
            descriptors.add(this.getFilteredObjectDescriptor(desc, filters));
        }
        return descriptors;
    }

    private IObjectDescriptor getFilteredObjectDescriptor(final IObjectDescriptor desc, final IFilter[] filters) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (IObjectDescriptor.class.equals(method.getDeclaringClass()) && "getChildren".equals(method.getName())) {
                    IObjectDescriptor[] children = desc.getChildren();
                    List filtered = CollectionUtils.newList();
                    for (int i = 0; i < children.length; ++i) {
                        if (!BY_REF_FILTER.accept((Object)children[i])) continue;
                        filtered.add(PepperConnectionManager.this.getFilteredObjectDescriptor(children[i], filters));
                    }
                    return filtered.toArray(new IObjectDescriptor[filtered.size()]);
                }
                return method.invoke((Object)desc, args);
            }
        };
        ClassLoader classLoader = desc.getClass().getClassLoader();
        Class<?>[] interfaces = this.getInterfaces(desc);
        return (IObjectDescriptor)Proxy.newProxyInstance(classLoader, interfaces, handler);
    }

    private Class<?>[] getInterfaces(IObjectDescriptor desc) {
        int i;
        ArrayList result = new ArrayList();
        Class<?>[] interfaces = desc.getClass().getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            result.add(interfaces[i]);
        }
        if (desc.getClass().getSuperclass() != null) {
            interfaces = desc.getClass().getSuperclass().getInterfaces();
            for (i = 0; i < interfaces.length; ++i) {
                result.add(interfaces[i]);
            }
        }
        return result.toArray(new Class[result.size()]);
    }

    private IFilter[] getFilters(IFilter[] filters, boolean byReference) {
        if (filters != null || byReference) {
            List list = CollectionUtils.newList();
            if (filters != null) {
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i] == null) continue;
                    list.add(filters[i]);
                }
            }
            if (byReference) {
                list.add(BY_REF_FILTER);
            }
            if (list.size() > 0) {
                return list.toArray(new IFilter[list.size()]);
            }
        }
        return null;
    }

    public static URI makeURI(Connection connection) {
        String id = connection.getId();
        return URI.createURI((String)("cnx://" + id + "/"));
    }

    public EObject find(String uri) {
        try {
            return this.find(URI.createURI((String)uri));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IConnection findConnection(String uri) {
        try {
            return this.findConnection(URI.createURI((String)uri));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public EObject find(URI uri) {
        Connection connection = (Connection)this.findConnection(uri);
        if (connection != null) {
            try {
                this.open(connection);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ConnectionHandler handler = this.handlers.get(connection);
            if (handler != null) {
                return handler.find(uri);
            }
        }
        return null;
    }

    public IConnection findConnection(URI uri) {
        if ("cnx".equals(uri.scheme())) {
            String id = uri.authority();
            return this.getConnection(id);
        }
        return null;
    }

    public boolean mustLink(IObjectDescriptor descriptor) {
        URI uri = descriptor.getURI();
        String id = uri.authority();
        Connection connection = this.getConnection(id);
        if (connection == null) {
            return false;
        }
        return "true".equals(connection.getAttribute("importByReference"));
    }

    private void reloadConnections(ArrayList<Connection> connections) {
        for (Connection connection : connections) {
            ConnectionManager manager = ConnectionManager.getConnectionManager((Connection)connection);
            if (manager == null) continue;
            try {
                manager.close(connection);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            connection.eNotify((Notification)new NotificationImpl(4, null, null, 0));
        }
    }

    private void sortDescriptors(IObjectDescriptor[] descriptors, Map<String, ArrayList<IObjectDescriptor>> container) {
        for (int i = 0; i < descriptors.length; ++i) {
            ArrayList<Object> descriptorValues;
            IObjectDescriptor descriptor = descriptors[i];
            URI uri = descriptor.getURI();
            String id = uri.authority();
            if (container.containsKey(id)) {
                descriptorValues = container.get(id);
                descriptorValues.add(descriptors[i]);
                container.put(id, descriptorValues);
                continue;
            }
            descriptorValues = new ArrayList();
            descriptorValues.add(descriptors[i]);
            container.put(id, descriptorValues);
        }
    }

    public void resolve() {
        for (EObject object : this.model.eContents()) {
            if (!object.eIsProxy() || !(object instanceof EObjectImpl)) continue;
            URI uri = ((EObjectImpl)object).eProxyURI();
            if (uri.opaquePart() != null) {
                try {
                    ExternalPackage pkg;
                    QName qname = QName.valueOf(uri.opaquePart());
                    if (this.model.getExternalPackages() != null && (pkg = this.model.getExternalPackages().getExternalPackage(qname.getNamespaceURI())) != null) {
                        String pkgConnectionUri = ExtendedAttributeUtil.getAttributeValue((Extensible)pkg, (String)"carnot:connection:uri");
                        uri = URI.createURI((String)(pkgConnectionUri + uri.scheme() + '/' + qname.getLocalPart()));
                        ((InternalEObject)object).eSetProxyURI(uri);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.resolve(object, uri);
        }
    }

    private void resolve(EObject object, URI uri) {
        String id;
        Connection connection;
        if ("cnx".equals(uri.scheme()) && (connection = this.getConnection(id = uri.authority())) != null) {
            try {
                this.open(connection);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ConnectionHandler handler = this.handlers.get(connection);
            if (handler != null) {
                handler.resolve(this.model, object);
            }
        }
    }

    public static URI getURI(EObject object) {
        if (object.eIsProxy() && object instanceof InternalEObject) {
            return ((InternalEObject)object).eProxyURI();
        }
        if (object instanceof IExtensibleElement) {
            String uri = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)object), (String)"carnot:connection:uri");
            try {
                return URI.createURI((String)uri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setConnectionManager(Connection connection) {
        connection.setProperty("ConnectionManager", (Object)this);
    }

    public static ConnectionManager getConnectionManager(Connection connection) {
        return (ConnectionManager)connection.getProperty("ConnectionManager");
    }

    public ModelType find(ExternalPackage pkg) {
        ModelType model;
        if (pkg != null && (model = ModelUtils.findContainingModel((EObject)pkg)) != null) {
            String uri = ExtendedAttributeUtil.getAttributeValue((Extensible)pkg, (String)"carnot:connection:uri");
            EObject eObject = this.find(uri);
            if (eObject instanceof IObjectReference) {
                eObject = ((IObjectReference)eObject).getEObject();
            }
            if (eObject instanceof ModelType) {
                return (ModelType)eObject;
            }
        }
        return null;
    }

    public ModelType getModel() {
        return this.model;
    }
}

