/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.transform.TransformerFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.Predicate;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.model.xpdl.builder.strategy.ModelManagementStrategy;
import org.eclipse.stardust.model.xpdl.builder.utils.WebModelerConnectionManager;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.DocumentRoot;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;

public class WebModelerModelManager
extends WorkflowModelManager {
    private static final String TRAX_KEY = TransformerFactory.class.getName();
    private WebModelerConnectionManager manager;
    private ModelManagementStrategy strategy;

    public WebModelerModelManager() {
    }

    public WebModelerModelManager(ModelManagementStrategy strategy) {
        this.strategy = strategy;
    }

    public void setModel(ModelType model) {
        this.model = model;
        this.resource = this.model.eResource();
    }

    public void resolve(ModelType model) {
        WebModelerModelManager.cleanup(model, (Predicate<Object>)new DuplicateReferencesFilter());
        if (model != null && model.getId() != null) {
            this.manager = (WebModelerConnectionManager)model.getConnectionManager();
            if (this.manager == null) {
                this.manager = new WebModelerConnectionManager(model, this.strategy);
            }
            this.manager.resolve();
        }
        super.resolve(model);
    }

    private static void cleanup(ModelType model, Predicate<Object> filter) {
        for (EStructuralFeature feature : model.eClass().getEAllStructuralFeatures()) {
            Object o;
            if (!feature.isMany() || !((o = model.eGet(feature)) instanceof Collection)) continue;
            WebModelerModelManager.cleanup((Collection)o, filter);
        }
    }

    private static void cleanup(Collection<?> list, Predicate<Object> filter) {
        List toRemove = CollectionUtils.newList();
        for (Object o : list) {
            if (filter.accept(o)) continue;
            toRemove.add(o);
        }
        if (!toRemove.isEmpty()) {
            list.removeAll(toRemove);
        }
    }

    public void save(URI uri, OutputStream os) throws IOException {
        if (this.resource == null) {
            this.getResource(uri, false);
            CarnotWorkflowModelFactory cwmFactory = WebModelerModelManager.getFactory();
            DocumentRoot documentRoot = cwmFactory.createDocumentRoot();
            this.resource.getContents().add((Object)documentRoot);
            documentRoot.setModel(this.model);
            this.resolve(this.model);
        }
        super.save(uri, os);
    }

    protected void doSave(OutputStream os) throws IOException {
        if (this.manager == null) {
            this.manager = (WebModelerConnectionManager)this.model.getConnectionManager();
            if (this.manager == null) {
                this.manager = new WebModelerConnectionManager(this.model, this.strategy);
            }
        }
        this.manager.save();
        super.doSave(os);
    }

    public WebModelerConnectionManager getConnectionManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoad(InputStream is) throws IOException {
        String ippTraxFactory = Parameters.instance().getString("Carnot.Xml.TrAX.TransformerFactory");
        String traxFactoryOverride = System.getProperty(TRAX_KEY);
        try {
            if (!StringUtils.isEmpty((String)ippTraxFactory)) {
                System.setProperty(TRAX_KEY, ippTraxFactory);
            }
            try {
                super.doLoad(is);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (!StringUtils.isEmpty((String)ippTraxFactory)) {
                if (StringUtils.isEmpty((String)traxFactoryOverride)) {
                    System.clearProperty(TRAX_KEY);
                } else {
                    System.setProperty(TRAX_KEY, traxFactoryOverride);
                }
            }
        }
    }

    private static class DuplicateReferencesFilter
    implements Predicate<Object> {
        Set<URI> uris = CollectionUtils.newSet();

        private DuplicateReferencesFilter() {
        }

        public boolean accept(Object o) {
            if (o instanceof InternalEObject && ((InternalEObject)o).eIsProxy()) {
                URI uri = ((InternalEObject)o).eProxyURI();
                if (this.uris.contains(uri)) {
                    return false;
                }
                this.uris.add(uri);
            }
            return true;
        }
    }
}

