/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.utils;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.common.error.ErrorCase;
import org.eclipse.stardust.common.error.ObjectNotFoundException;
import org.eclipse.stardust.engine.api.runtime.BpmRuntimeError;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.AnnotationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationTypeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.EndEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.IntermediateEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerTypeType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;

public class XPDLFinderUtils {
    private static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;

    public static AnnotationSymbolType findAnnotationSymbol(LaneSymbol parentLaneSymbol, Long annotationOId) {
        for (AnnotationSymbolType annSymbol : parentLaneSymbol.getAnnotationSymbol()) {
            if (!annotationOId.equals(annSymbol.getElementOid())) continue;
            return annSymbol;
        }
        return null;
    }

    public static ProcessDefinitionType findProcessDefinition(ModelType model, String id) {
        for (ProcessDefinitionType processDefinition : model.getProcessDefinition()) {
            if (!processDefinition.getId().equals(id)) continue;
            return processDefinition;
        }
        return null;
    }

    public static EventHandlerType findEventHandler(ActivityType activity, String id) {
        for (EventHandlerType eventHandler : activity.getEventHandler()) {
            if (!eventHandler.getId().equals(id)) continue;
            return eventHandler;
        }
        return null;
    }

    public static ApplicationType findApplication(ModelType model, String id) {
        for (ApplicationType application : model.getApplication()) {
            if (!application.getId().equals(id)) continue;
            return application;
        }
        return null;
    }

    public static ApplicationTypeType findApplicationTypeType(ModelType model, String id) {
        ApplicationTypeType applicationMetaType;
        for (ApplicationTypeType applicationType : model.getApplicationType()) {
            if (!applicationType.getId().equals(id)) continue;
            return applicationType;
        }
        if (id.equals("camelConsumerApplication") && null == (applicationMetaType = (ApplicationTypeType)ModelUtils.findIdentifiableElement((List)model.getApplicationType(), (String)"camelConsumerApplication"))) {
            CarnotWorkflowModelFactory F_CWM = CarnotWorkflowModelFactory.eINSTANCE;
            applicationMetaType = F_CWM.createApplicationTypeType();
            applicationMetaType.setId("camelConsumerApplication");
            applicationMetaType.setName("Camel Consumer Application");
            applicationMetaType.setIsPredefined(true);
            applicationMetaType.setSynchronous(false);
            AttributeUtil.setAttribute((IExtensibleElement)applicationMetaType, (String)"carnot:engine:accessPointProvider", (String)"org.eclipse.stardust.engine.extensions.camel.app.CamelProducerSpringBeanAccessPointProvider");
            AttributeUtil.setAttribute((IExtensibleElement)applicationMetaType, (String)"carnot:engine:applicationInstance", (String)"org.eclipse.stardust.engine.extensions.camel.app.CamelProducerSpringBeanApplicationInstance");
            AttributeUtil.setAttribute((IExtensibleElement)applicationMetaType, (String)"carnot:engine:validator", (String)"org.eclipse.stardust.engine.extensions.camel.app.CamelProducerSpringBeanValidator");
            model.getApplicationType().add((Object)applicationMetaType);
            return applicationMetaType;
        }
        return null;
    }

    public static TriggerTypeType findTriggerType(ModelType model, String id) {
        CarnotWorkflowModelFactory F_CWM;
        TriggerTypeType triggerMetaType;
        for (TriggerTypeType triggerType : model.getTriggerType()) {
            if (!triggerType.getId().equals(id)) continue;
            return triggerType;
        }
        if (id.equals("camel")) {
            triggerMetaType = (TriggerTypeType)ModelUtils.findIdentifiableElement((List)model.getTriggerType(), (String)"camel");
            if (null == triggerMetaType) {
                F_CWM = CarnotWorkflowModelFactory.eINSTANCE;
                triggerMetaType = F_CWM.createTriggerTypeType();
                triggerMetaType.setId("camel");
                triggerMetaType.setName("Camel Trigger");
                triggerMetaType.setIsPredefined(true);
                triggerMetaType.setPullTrigger(false);
                AttributeUtil.setAttribute((IExtensibleElement)triggerMetaType, (String)"carnot:engine:validator", (String)"org.eclipse.stardust.engine.extensions.camel.trigger.validation.CamelTriggerValidator");
                AttributeUtil.setAttribute((IExtensibleElement)triggerMetaType, (String)"carnot:engine:runtimeValidator", (String)"org.eclipse.stardust.engine.extensions.camel.trigger.validation.CamelTriggerValidator");
                model.getTriggerType().add((Object)triggerMetaType);
                return triggerMetaType;
            }
        } else if (id.equals("scan") && null == (triggerMetaType = (TriggerTypeType)ModelUtils.findIdentifiableElement((List)model.getTriggerType(), (String)"scan"))) {
            F_CWM = CarnotWorkflowModelFactory.eINSTANCE;
            triggerMetaType = F_CWM.createTriggerTypeType();
            triggerMetaType.setId("scan");
            triggerMetaType.setName("Scan Trigger");
            triggerMetaType.setIsPredefined(true);
            triggerMetaType.setPullTrigger(false);
            AttributeUtil.setAttribute((IExtensibleElement)triggerMetaType, (String)"carnot:engine:validator", (String)"org.eclipse.stardust.engine.core.extensions.triggers.manual.ManualTriggerValidator");
            model.getTriggerType().add((Object)triggerMetaType);
            return triggerMetaType;
        }
        return null;
    }

    public static ApplicationContextTypeType findApplicationContextTypeType(ModelType model, String id) {
        for (ApplicationContextTypeType applicationContextType : model.getApplicationContextType()) {
            if (!applicationContextType.getId().equals(id)) continue;
            return applicationContextType;
        }
        return null;
    }

    public static TypeDeclarationType findTypeDeclaration(ModelType model, String id) {
        TypeDeclarationType typeDeclaration = model.getTypeDeclarations().getTypeDeclaration(id);
        if (typeDeclaration == null) {
            throw new ObjectNotFoundException((ErrorCase)BpmRuntimeError.MDL_UNKNOWN_TYPE_DECLARATION_ID.raise((Object)id));
        }
        return typeDeclaration;
    }

    public static DataTypeType findDataType(ModelType model, String id) {
        for (DataTypeType dataType : model.getDataType()) {
            if (!dataType.getId().equals(id)) continue;
            return dataType;
        }
        return null;
    }

    public static DataType findData(ModelType model, String id) {
        for (DataType data : model.getData()) {
            if (!data.getId().equals(id)) continue;
            return data;
        }
        return null;
    }

    public static IModelParticipant findParticipant(ModelType model, String id) {
        for (RoleType role : model.getRole()) {
            if (!role.getId().equals(id)) continue;
            return role;
        }
        for (OrganizationType organization : model.getOrganization()) {
            if (!organization.getId().equals(id)) continue;
            return organization;
        }
        for (ConditionalPerformerType conditionalPerformer : model.getConditionalPerformer()) {
            if (!conditionalPerformer.getId().equals(id)) continue;
            return conditionalPerformer;
        }
        return null;
    }

    public static DataSymbolType findDataSymbol(DiagramType diagram, long oid) {
        for (DataSymbolType dataSymbol : diagram.getDataSymbol()) {
            if (dataSymbol.getElementOid() != oid) continue;
            return dataSymbol;
        }
        for (PoolSymbol poolSymbol : diagram.getPoolSymbols()) {
            for (LaneSymbol childLaneSymbol : poolSymbol.getChildLanes()) {
                DataSymbolType dataSymbol = XPDLFinderUtils.findDataSymbolRecursively(childLaneSymbol, oid);
                if (dataSymbol == null) continue;
                return dataSymbol;
            }
        }
        return null;
    }

    public static DataSymbolType findDataSymbolRecursively(LaneSymbol laneSymbol, long oid) {
        for (DataSymbolType dataSymbol : laneSymbol.getDataSymbol()) {
            if (dataSymbol.getElementOid() != oid) continue;
            return dataSymbol;
        }
        for (LaneSymbol childLaneSymbol : laneSymbol.getChildLanes()) {
            DataSymbolType dataSymbol = XPDLFinderUtils.findDataSymbolRecursively(childLaneSymbol, oid);
            if (dataSymbol == null) continue;
            return dataSymbol;
        }
        return null;
    }

    public static ActivityType findActivity(ProcessDefinitionType processDefinition, String id) {
        for (ActivityType activity : processDefinition.getActivity()) {
            if (!activity.getId().equals(id)) continue;
            return activity;
        }
        return null;
    }

    public static ActivitySymbolType findActivitySymbol(DiagramType diagram, long oid) {
        LaneSymbol laneSymbol = XPDLFinderUtils.findLaneContainingActivitySymbol(diagram, oid);
        if (laneSymbol != null) {
            return XPDLFinderUtils.findActivitySymbol(laneSymbol, oid);
        }
        return null;
    }

    public static LaneSymbol findLaneContainingActivitySymbol(DiagramType diagram, long oid) {
        for (PoolSymbol poolSymbol : diagram.getPoolSymbols()) {
            for (LaneSymbol laneSymbol : poolSymbol.getChildLanes()) {
                LaneSymbol containingLaneSymbol = XPDLFinderUtils.findLaneContainingActivitySymbolRecursively(laneSymbol, oid);
                if (containingLaneSymbol == null) continue;
                return containingLaneSymbol;
            }
        }
        return null;
    }

    public static LaneSymbol findLaneContainingActivitySymbolRecursively(LaneSymbol laneSymbol, long oid) {
        for (ActivitySymbolType activitySymbol : laneSymbol.getActivitySymbol()) {
            if (activitySymbol.getElementOid() != oid) continue;
            return laneSymbol;
        }
        for (LaneSymbol childLaneSymbol : laneSymbol.getChildLanes()) {
            LaneSymbol containingLaneSymbol = XPDLFinderUtils.findLaneContainingActivitySymbolRecursively(childLaneSymbol, oid);
            if (containingLaneSymbol == null) continue;
            return containingLaneSymbol;
        }
        return null;
    }

    public static ActivitySymbolType findActivitySymbol(LaneSymbol laneSymbol, long oid) {
        for (ActivitySymbolType activitySymbol : laneSymbol.getActivitySymbol()) {
            if (activitySymbol.getElementOid() != oid) continue;
            return activitySymbol;
        }
        return null;
    }

    public static AnnotationSymbolType findAnnotationSymbol(DiagramType diagram, long oid) {
        LaneSymbol laneSymbol = XPDLFinderUtils.findLaneContainingAnnotationSymbol(diagram, oid);
        if (laneSymbol != null) {
            return XPDLFinderUtils.findAnnotationSymbol(laneSymbol, (Long)oid);
        }
        return null;
    }

    private static LaneSymbol findLaneContainingAnnotationSymbol(DiagramType diagram, long oid) {
        for (PoolSymbol poolSymbol : diagram.getPoolSymbols()) {
            for (LaneSymbol laneSymbol : poolSymbol.getChildLanes()) {
                LaneSymbol containingLaneSymbol = XPDLFinderUtils.findLaneContainingAnnotationSymbolRecursively(laneSymbol, oid);
                if (containingLaneSymbol == null) continue;
                return containingLaneSymbol;
            }
        }
        return null;
    }

    public static LaneSymbol findLaneContainingAnnotationSymbolRecursively(LaneSymbol laneSymbol, long oid) {
        for (AnnotationSymbolType annotationSymbol : laneSymbol.getAnnotationSymbol()) {
            if (annotationSymbol.getElementOid() != oid) continue;
            return laneSymbol;
        }
        for (LaneSymbol childLaneSymbol : laneSymbol.getChildLanes()) {
            LaneSymbol containingLaneSymbol = XPDLFinderUtils.findLaneContainingAnnotationSymbolRecursively(childLaneSymbol, oid);
            if (containingLaneSymbol == null) continue;
            return containingLaneSymbol;
        }
        return null;
    }

    public static LaneSymbol findLaneInProcess(ProcessDefinitionType processDefinition, String id) {
        for (PoolSymbol poolSymbol : ((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols()) {
            for (LaneSymbol laneSymbol : poolSymbol.getChildLanes()) {
                LaneSymbol foundLaneSymbol = XPDLFinderUtils.findLaneRecursively(laneSymbol, id);
                if (foundLaneSymbol == null) continue;
                return foundLaneSymbol;
            }
        }
        return null;
    }

    public static LaneSymbol findLaneRecursively(LaneSymbol laneSymbol, String id) {
        if (laneSymbol.getId().equals(id)) {
            return laneSymbol;
        }
        for (LaneSymbol childLaneSymbol : laneSymbol.getChildLanes()) {
            LaneSymbol foundLaneSymbol = XPDLFinderUtils.findLaneRecursively(childLaneSymbol, id);
            if (foundLaneSymbol == null) continue;
            return foundLaneSymbol;
        }
        return null;
    }

    public static StartEventSymbol findStartEventSymbol(DiagramType diagram, long oid) {
        return XPDLFinderUtils.findSymbolRecursively(oid, StartEventSymbol.class, diagram, PKG_CWM.getISymbolContainer_StartEventSymbols());
    }

    public static <S extends IGraphicalObject> S findSymbolRecursively(long oid, Class<S> symbolType, DiagramType diagram, EReference containmentFeature) {
        S symbol = XPDLFinderUtils.findSymbol(oid, symbolType, (ISymbolContainer)diagram, containmentFeature);
        if (null != symbol) {
            return symbol;
        }
        for (PoolSymbol poolSymbol : diagram.getPoolSymbols()) {
            symbol = XPDLFinderUtils.findSymbolRecursively(oid, symbolType, poolSymbol, containmentFeature);
            if (null == symbol) continue;
            return symbol;
        }
        return null;
    }

    public static <S extends IGraphicalObject> S findSymbol(long oid, Class<S> symbolType, ISymbolContainer container, EReference containmentFeature) {
        if (containmentFeature.isMany()) {
            List containedSymbols = (List)container.eGet((EStructuralFeature)containmentFeature);
            for (IGraphicalObject symbol : containedSymbols) {
                if (symbol.getElementOid() != oid) continue;
                return (S)((IGraphicalObject)symbolType.cast(symbol));
            }
        } else {
            IGraphicalObject containedSymbol = (IGraphicalObject)container.eGet((EStructuralFeature)containmentFeature);
            if (null != containedSymbol && containedSymbol.getElementOid() == oid) {
                return (S)((IGraphicalObject)symbolType.cast(containedSymbol));
            }
        }
        return null;
    }

    public static <S extends IGraphicalObject, C extends ISymbolContainer & ISwimlaneSymbol> S findSymbolRecursively(long oid, Class<S> symbolType, C container, EReference containmentFeature) {
        S symbol = XPDLFinderUtils.findSymbol(oid, symbolType, container, containmentFeature);
        if (null != symbol) {
            return symbol;
        }
        if (INodeSymbol.class.isAssignableFrom(symbolType)) {
            for (LaneSymbol childLaneSymbol : ((ISwimlaneSymbol)container).getChildLanes()) {
                symbol = XPDLFinderUtils.findSymbolRecursively(oid, symbolType, childLaneSymbol, containmentFeature);
                if (null == symbol) continue;
                return symbol;
            }
        }
        return null;
    }

    public static TransitionConnectionType findTransitionConnectionByModelOid(ProcessDefinitionType processDefinition, long oid) {
        DiagramType diagram = (DiagramType)processDefinition.getDiagram().get(0);
        TransitionConnectionType connection = XPDLFinderUtils.findSymbolRecursively(oid, TransitionConnectionType.class, diagram, PKG_CWM.getISymbolContainer_TransitionConnection());
        if (null != connection) {
            return connection;
        }
        return null;
    }

    public static DataMappingConnectionType findDataMappingConnectionByModelOid(ProcessDefinitionType processDefinition, long oid) {
        for (DataMappingConnectionType dataMappingConnectionType : ((DiagramType)processDefinition.getDiagram().get(0)).getDataMappingConnection()) {
            if (dataMappingConnectionType.getElementOid() != oid) continue;
            return dataMappingConnectionType;
        }
        for (DataMappingConnectionType dataMappingConnectionType : ((PoolSymbol)((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols().get(0)).getDataMappingConnection()) {
            if (dataMappingConnectionType.getElementOid() != oid) continue;
            return dataMappingConnectionType;
        }
        return null;
    }

    public static LaneSymbol findLaneSymbolById(ProcessDefinitionType processDefinition, String id) {
        for (PoolSymbol poolSymbol : ((DiagramType)processDefinition.getDiagram().get(0)).getPoolSymbols()) {
            for (LaneSymbol laneSymbol : poolSymbol.getLanes()) {
                if (!laneSymbol.getId().equals(id)) continue;
                return laneSymbol;
            }
        }
        return null;
    }

    public static EndEventSymbol findEndEventSymbol(ISymbolContainer container, long oid) {
        return XPDLFinderUtils.findSymbol(oid, EndEventSymbol.class, container, PKG_CWM.getISymbolContainer_EndEventSymbols());
    }

    public static StartEventSymbol findStartEventSymbol(LaneSymbol laneSymbol, long oid) {
        return XPDLFinderUtils.findSymbol(oid, StartEventSymbol.class, (ISymbolContainer)laneSymbol, PKG_CWM.getISymbolContainer_StartEventSymbols());
    }

    public static IntermediateEventSymbol findIntermediateEventSymbol(DiagramType diagram, long oid) {
        return XPDLFinderUtils.findSymbolRecursively(oid, IntermediateEventSymbol.class, diagram, PKG_CWM.getISymbolContainer_IntermediateEventSymbols());
    }

    public static IntermediateEventSymbol findIntermediateEventSymbol(LaneSymbol laneSymbol, long oid) {
        return XPDLFinderUtils.findSymbol(oid, IntermediateEventSymbol.class, (ISymbolContainer)laneSymbol, PKG_CWM.getISymbolContainer_IntermediateEventSymbols());
    }

    public static EndEventSymbol findEndEventSymbol(DiagramType diagram, long oid) {
        return XPDLFinderUtils.findSymbolRecursively(oid, EndEventSymbol.class, diagram, PKG_CWM.getISymbolContainer_EndEventSymbols());
    }

    public static DataPathType findDataPath(ProcessDefinitionType processDefinition, String id) {
        EList dataPaths = processDefinition.getDataPath();
        DataPathType dataPath = null;
        for (DataPathType foundType : dataPaths) {
            if (!foundType.getId().equals(id)) continue;
            dataPath = foundType;
        }
        return dataPath;
    }
}

