/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.variable;

import java.util.Date;
import java.util.List;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.builder.common.AbstractModelElementBuilder;
import org.eclipse.stardust.model.xpdl.builder.common.Var;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public class BpmPrimitiveVariableBuilder<P>
extends AbstractModelElementBuilder<DataType, BpmPrimitiveVariableBuilder<P>>
implements Var<P> {
    public BpmPrimitiveVariableBuilder() {
        super(F_CWM.createDataType());
    }

    @Override
    public String variableId() {
        return ((DataType)this.element).getId();
    }

    @Override
    protected void setModel(ModelType model) {
        DataTypeType primitiveMetaType;
        super.setModel(model);
        if (null == ((DataType)this.element).getType() && null != this.model && null != (primitiveMetaType = (DataTypeType)ModelUtils.findIdentifiableElement((List)this.model.getDataType(), (String)"primitive"))) {
            ((DataType)this.element).setType(primitiveMetaType);
        }
    }

    @Override
    protected DataType finalizeElement() {
        super.finalizeElement();
        if (null == AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)this.element), (String)"carnot:engine:type")) {
            this.ofType(Type.String);
        }
        this.model.getData().add((Object)this.element);
        return (DataType)this.element;
    }

    @Override
    protected String getDefaultElementIdPrefix() {
        return "Data";
    }

    public static BpmPrimitiveVariableBuilder<Object> newPrimitiveVariable() {
        return new BpmPrimitiveVariableBuilder<Object>();
    }

    public static BpmPrimitiveVariableBuilder<Object> newPrimitiveVariable(ModelType model) {
        return (BpmPrimitiveVariableBuilder)BpmPrimitiveVariableBuilder.newPrimitiveVariable().inModel(model);
    }

    public <T> BpmPrimitiveVariableBuilder<T> ofType(Class<T> type) {
        Type primitiveType;
        if (Boolean.class == type || Boolean.TYPE == type) {
            primitiveType = Type.Boolean;
        } else if (Byte.class == type || Byte.TYPE == type) {
            primitiveType = Type.Byte;
        } else if (Character.class == type || Character.TYPE == type) {
            primitiveType = Type.Char;
        } else if (Double.class == type || Double.TYPE == type) {
            primitiveType = Type.Double;
        } else if (Float.class == type || Float.TYPE == type) {
            primitiveType = Type.Float;
        } else if (Integer.class == type || Integer.TYPE == type) {
            primitiveType = Type.Integer;
        } else if (Long.class == type || Long.TYPE == type) {
            primitiveType = Type.Long;
        } else if (Short.class == type || Short.TYPE == type) {
            primitiveType = Type.Short;
        } else if (String.class == type) {
            primitiveType = Type.String;
        } else if (Date.class == type) {
            primitiveType = Type.Timestamp;
        } else {
            throw new IllegalArgumentException("Illegal primitive variable type: " + type);
        }
        return this.ofType(primitiveType);
    }

    public BpmPrimitiveVariableBuilder<P> ofType(Type typeCode) {
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)this.element), (String)"carnot:engine:type", (String)Type.class.getName(), (String)typeCode.getId());
        return this;
    }

    public BpmPrimitiveVariableBuilder<P> havingDefaultValue(P defaultValue) {
        if (null != defaultValue) {
            AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)this.element), (String)"carnot:engine:defaultValue", (String)defaultValue.toString());
        }
        return this;
    }
}

