/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.builder.variable;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.engine.extensions.transformation.model.MappingModelUtil;
import org.eclipse.stardust.engine.extensions.transformation.model.mapping.MappingFactory;
import org.eclipse.stardust.engine.extensions.transformation.model.mapping.TransformationProperty;
import org.eclipse.stardust.model.xpdl.builder.common.AbstractModelElementBuilder;
import org.eclipse.stardust.model.xpdl.builder.utils.ModelBuilderFacade;
import org.eclipse.stardust.model.xpdl.builder.utils.XPDLFinderUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IAccessPointOwner;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public class StructAccessPointBuilder
extends AbstractModelElementBuilder<AccessPointType, StructAccessPointBuilder> {
    private ModelBuilderFacade facade;
    private IAccessPointOwner owner;

    @Override
    protected EList<? super AccessPointType> getElementContainer() {
        return this.owner.getAccessPoint();
    }

    public StructAccessPointBuilder() {
        super(F_CWM.createAccessPointType());
    }

    public StructAccessPointBuilder(IAccessPointOwner anOwner) {
        super(F_CWM.createAccessPointType());
        this.owner = anOwner;
        this.forModel(ModelUtils.findContainingModel((EObject)anOwner));
    }

    private void createApplicationAccessPoint(IAccessPointOwner anOwner) {
        ApplicationType applicationType = (ApplicationType)anOwner;
        if (applicationType.isInteractive()) {
            this.createExternalWebApplicationAccessPoint(applicationType);
        } else if (applicationType.getType().getId().equals("messageTransformationBean")) {
            this.createMessageTransformationApplicationAccessPoint(applicationType);
        } else {
            applicationType.getAccessPoint().add((Object)this.element);
        }
    }

    private void createDefaultAccessPoint(IAccessPointOwner owner2) {
        this.owner.getAccessPoint().add((Object)this.element);
    }

    private void createMessageTransformationApplicationAccessPoint(ApplicationType applicationType) {
        applicationType.getAccessPoint().add((Object)this.element);
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)this.element), (String)"carnot:engine:path:separator", (String)"/");
        AttributeUtil.setBooleanAttribute((IExtensibleElement)((IExtensibleElement)this.element), (String)"carnot:engine:data:bidirectional", (Boolean)true);
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)this.element), (String)"RootElement", (String)((AccessPointType)this.element).getId());
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)this.element), (String)"FullXPath", (String)(((AccessPointType)this.element).getId() + "/"));
        TransformationProperty property = MappingFactory.eINSTANCE.createTransformationProperty();
        String xmlString = MappingModelUtil.transformEcore2XML((EObject)property);
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)this.element), (String)"messageTransformation:TransformationProperty", (String)xmlString);
    }

    private void createExternalWebApplicationAccessPoint(ApplicationType applicationType) {
        ContextType contextType = this.getModelBuilderFacade().getApplicationContext(applicationType, "externalWebApp");
        contextType.getAccessPoint().add((Object)this.element);
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)this.element), (String)"carnot:engine:path:separator", (String)"/");
        AttributeUtil.setBooleanAttribute((IExtensibleElement)((IExtensibleElement)this.element), (String)"carnot:engine:data:bidirectional", (Boolean)true);
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)this.element), (String)"RootElement", (String)((AccessPointType)this.element).getId());
        TransformationProperty property = MappingFactory.eINSTANCE.createTransformationProperty();
        String xmlString = MappingModelUtil.transformEcore2XML((EObject)property);
        AttributeUtil.setAttribute((IExtensibleElement)contextType, (String)"messageTransformation:TransformationProperty", (String)xmlString);
    }

    private void createInteractiveAccessPoint(ContextType contextType) {
        contextType.getAccessPoint().add((Object)this.element);
        if (contextType.getType().getId().equals("externalWebApp")) {
            AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)this.element), (String)"RootElement", (String)((AccessPointType)this.element).getId());
            TransformationProperty property = MappingFactory.eINSTANCE.createTransformationProperty();
            String xmlString = MappingModelUtil.transformEcore2XML((EObject)property);
            AttributeUtil.setAttribute((IExtensibleElement)contextType, (String)"messageTransformation:TransformationProperty", (String)xmlString);
        }
    }

    @Override
    protected String getDefaultElementIdPrefix() {
        return "StructAccessPoint";
    }

    public static StructAccessPointBuilder newAccessPoint(IAccessPointOwner anOwner) {
        return new StructAccessPointBuilder(anOwner);
    }

    @Override
    protected AccessPointType finalizeElement() {
        super.finalizeElement();
        if (this.owner instanceof ApplicationType) {
            this.createApplicationAccessPoint(this.owner);
        } else if (this.owner instanceof ContextType) {
            this.createInteractiveAccessPoint((ContextType)this.owner);
        } else {
            this.createDefaultAccessPoint(this.owner);
        }
        return (AccessPointType)this.element;
    }

    public StructAccessPointBuilder withDirection(String direction) {
        DirectionType directionType = direction.equals(DirectionType.IN_LITERAL.getName()) ? DirectionType.IN_LITERAL : (direction.equals(DirectionType.INOUT_LITERAL.getName()) ? DirectionType.INOUT_LITERAL : DirectionType.OUT_LITERAL);
        ((AccessPointType)this.element).setDirection(directionType);
        return (StructAccessPointBuilder)this.self();
    }

    public StructAccessPointBuilder withType(String structTypeFullID) {
        String declaredTypeID = null;
        declaredTypeID = this.model.getId().equals(this.getModelBuilderFacade().getModelId(structTypeFullID)) ? this.getModelBuilderFacade().stripFullId(structTypeFullID) : "typeDeclaration:{" + this.getModelBuilderFacade().getModelId(structTypeFullID) + "}" + this.getModelBuilderFacade().stripFullId(structTypeFullID);
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)this.element), (String)"carnot:engine:dataType", (String)declaredTypeID);
        DataTypeType dataTypeType = XPDLFinderUtils.findDataType(this.model, "struct");
        ((AccessPointType)this.element).setType(dataTypeType);
        return (StructAccessPointBuilder)this.self();
    }

    private ModelBuilderFacade getModelBuilderFacade() {
        if (this.facade == null) {
            this.facade = new ModelBuilderFacade();
        }
        return this.facade;
    }
}

