/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SubProcessModeType implements Enumerator
{
    SYNC_SHARED_LITERAL(0, "sync_shared", "Synchronous / Shared Data"),
    SYNC_SEPARATE_LITERAL(1, "sync_separate", "Synchronous / Separate Data"),
    ASYNC_SEPARATE_LITERAL(2, "async_separate", "Asynchronous / Separate Data");

    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";
    public static final int SYNC_SHARED = 0;
    public static final int SYNC_SEPARATE = 1;
    public static final int ASYNC_SEPARATE = 2;
    private static final SubProcessModeType[] VALUES_ARRAY;
    public static final List<SubProcessModeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SubProcessModeType[]{SYNC_SHARED_LITERAL, SYNC_SEPARATE_LITERAL, ASYNC_SEPARATE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SubProcessModeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SubProcessModeType result = VALUES_ARRAY[i];
            if (result.name().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SubProcessModeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SubProcessModeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SubProcessModeType get(int value) {
        switch (value) {
            case 0: {
                return SYNC_SHARED_LITERAL;
            }
            case 1: {
                return SYNC_SEPARATE_LITERAL;
            }
            case 2: {
                return ASYNC_SEPARATE_LITERAL;
            }
        }
        return null;
    }

    private SubProcessModeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

